/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.CardInput;
import software.amazon.awssdk.services.qapps.model.CardListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppDefinitionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppDefinitionInput> {
    private static final SdkField<List<CardInput>> CARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cards").getter(AppDefinitionInput.getter(AppDefinitionInput::cards)).setter(AppDefinitionInput.setter(Builder::cards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CardInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INITIAL_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initialPrompt").getter(AppDefinitionInput.getter(AppDefinitionInput::initialPrompt)).setter(AppDefinitionInput.setter(Builder::initialPrompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialPrompt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARDS_FIELD, INITIAL_PROMPT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CardInput> cards;
    private final String initialPrompt;

    private AppDefinitionInput(BuilderImpl builder) {
        this.cards = builder.cards;
        this.initialPrompt = builder.initialPrompt;
    }

    public final boolean hasCards() {
        return this.cards != null && !(this.cards instanceof SdkAutoConstructList);
    }

    public final List<CardInput> cards() {
        return this.cards;
    }

    public final String initialPrompt() {
        return this.initialPrompt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCards() ? this.cards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.initialPrompt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppDefinitionInput)) {
            return false;
        }
        AppDefinitionInput other = (AppDefinitionInput)obj;
        return this.hasCards() == other.hasCards() && Objects.equals(this.cards(), other.cards()) && Objects.equals(this.initialPrompt(), other.initialPrompt());
    }

    public final String toString() {
        return ToString.builder((String)"AppDefinitionInput").add("Cards", this.hasCards() ? this.cards() : null).add("InitialPrompt", (Object)this.initialPrompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cards": {
                return Optional.ofNullable(clazz.cast(this.cards()));
            }
            case "initialPrompt": {
                return Optional.ofNullable(clazz.cast(this.initialPrompt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppDefinitionInput, T> g) {
        return obj -> g.apply((AppDefinitionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CardInput> cards = DefaultSdkAutoConstructList.getInstance();
        private String initialPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(AppDefinitionInput model) {
            this.cards(model.cards);
            this.initialPrompt(model.initialPrompt);
        }

        public final List<CardInput.Builder> getCards() {
            List<CardInput.Builder> result = CardListCopier.copyToBuilder(this.cards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCards(Collection<CardInput.BuilderImpl> cards) {
            this.cards = CardListCopier.copyFromBuilder(cards);
        }

        @Override
        public final Builder cards(Collection<CardInput> cards) {
            this.cards = CardListCopier.copy(cards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cards(CardInput ... cards) {
            this.cards(Arrays.asList(cards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cards(Consumer<CardInput.Builder> ... cards) {
            this.cards(Stream.of(cards).map(c -> (CardInput)((CardInput.Builder)CardInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInitialPrompt() {
            return this.initialPrompt;
        }

        public final void setInitialPrompt(String initialPrompt) {
            this.initialPrompt = initialPrompt;
        }

        @Override
        public final Builder initialPrompt(String initialPrompt) {
            this.initialPrompt = initialPrompt;
            return this;
        }

        public AppDefinitionInput build() {
            return new AppDefinitionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppDefinitionInput> {
        public Builder cards(Collection<CardInput> var1);

        public Builder cards(CardInput ... var1);

        public Builder cards(Consumer<CardInput.Builder> ... var1);

        public Builder initialPrompt(String var1);
    }
}

