/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A card representing a component or step in an Amazon Q App's flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Card implements SdkPojo, Serializable, ToCopyableBuilder<Card.Builder, Card> {
    private static final SdkField<TextInputCard> TEXT_INPUT_FIELD = SdkField.<TextInputCard> builder(MarshallingType.SDK_POJO)
            .memberName("textInput").getter(getter(Card::textInput)).setter(setter(Builder::textInput))
            .constructor(TextInputCard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textInput").build()).build();

    private static final SdkField<QQueryCard> Q_QUERY_FIELD = SdkField.<QQueryCard> builder(MarshallingType.SDK_POJO)
            .memberName("qQuery").getter(getter(Card::qQuery)).setter(setter(Builder::qQuery)).constructor(QQueryCard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qQuery").build()).build();

    private static final SdkField<QPluginCard> Q_PLUGIN_FIELD = SdkField.<QPluginCard> builder(MarshallingType.SDK_POJO)
            .memberName("qPlugin").getter(getter(Card::qPlugin)).setter(setter(Builder::qPlugin))
            .constructor(QPluginCard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qPlugin").build()).build();

    private static final SdkField<FileUploadCard> FILE_UPLOAD_FIELD = SdkField.<FileUploadCard> builder(MarshallingType.SDK_POJO)
            .memberName("fileUpload").getter(getter(Card::fileUpload)).setter(setter(Builder::fileUpload))
            .constructor(FileUploadCard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileUpload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_INPUT_FIELD,
            Q_QUERY_FIELD, Q_PLUGIN_FIELD, FILE_UPLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final TextInputCard textInput;

    private final QQueryCard qQuery;

    private final QPluginCard qPlugin;

    private final FileUploadCard fileUpload;

    private final Type type;

    private Card(BuilderImpl builder) {
        this.textInput = builder.textInput;
        this.qQuery = builder.qQuery;
        this.qPlugin = builder.qPlugin;
        this.fileUpload = builder.fileUpload;
        this.type = builder.type;
    }

    /**
     * <p>
     * A container for the properties of the text input card.
     * </p>
     * 
     * @return A container for the properties of the text input card.
     */
    public final TextInputCard textInput() {
        return textInput;
    }

    /**
     * <p>
     * A container for the properties of the query card.
     * </p>
     * 
     * @return A container for the properties of the query card.
     */
    public final QQueryCard qQuery() {
        return qQuery;
    }

    /**
     * <p>
     * A container for the properties of the plugin card.
     * </p>
     * 
     * @return A container for the properties of the plugin card.
     */
    public final QPluginCard qPlugin() {
        return qPlugin;
    }

    /**
     * <p>
     * A container for the properties of the file upload card.
     * </p>
     * 
     * @return A container for the properties of the file upload card.
     */
    public final FileUploadCard fileUpload() {
        return fileUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textInput());
        hashCode = 31 * hashCode + Objects.hashCode(qQuery());
        hashCode = 31 * hashCode + Objects.hashCode(qPlugin());
        hashCode = 31 * hashCode + Objects.hashCode(fileUpload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Card)) {
            return false;
        }
        Card other = (Card) obj;
        return Objects.equals(textInput(), other.textInput()) && Objects.equals(qQuery(), other.qQuery())
                && Objects.equals(qPlugin(), other.qPlugin()) && Objects.equals(fileUpload(), other.fileUpload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Card").add("TextInput", textInput()).add("QQuery", qQuery()).add("QPlugin", qPlugin())
                .add("FileUpload", fileUpload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textInput":
            return Optional.ofNullable(clazz.cast(textInput()));
        case "qQuery":
            return Optional.ofNullable(clazz.cast(qQuery()));
        case "qPlugin":
            return Optional.ofNullable(clazz.cast(qPlugin()));
        case "fileUpload":
            return Optional.ofNullable(clazz.cast(fileUpload()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #textInput()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the text input card.
     * </p>
     * 
     * @param textInput
     *        A container for the properties of the text input card.
     */
    public static Card fromTextInput(TextInputCard textInput) {
        return builder().textInput(textInput).build();
    }

    /**
     * Create an instance of this class with {@link #textInput()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the text input card.
     * </p>
     * 
     * @param textInput
     *        A container for the properties of the text input card.
     */
    public static Card fromTextInput(Consumer<TextInputCard.Builder> textInput) {
        TextInputCard.Builder builder = TextInputCard.builder();
        textInput.accept(builder);
        return fromTextInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #qQuery()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the query card.
     * </p>
     * 
     * @param qQuery
     *        A container for the properties of the query card.
     */
    public static Card fromQQuery(QQueryCard qQuery) {
        return builder().qQuery(qQuery).build();
    }

    /**
     * Create an instance of this class with {@link #qQuery()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the query card.
     * </p>
     * 
     * @param qQuery
     *        A container for the properties of the query card.
     */
    public static Card fromQQuery(Consumer<QQueryCard.Builder> qQuery) {
        QQueryCard.Builder builder = QQueryCard.builder();
        qQuery.accept(builder);
        return fromQQuery(builder.build());
    }

    /**
     * Create an instance of this class with {@link #qPlugin()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the plugin card.
     * </p>
     * 
     * @param qPlugin
     *        A container for the properties of the plugin card.
     */
    public static Card fromQPlugin(QPluginCard qPlugin) {
        return builder().qPlugin(qPlugin).build();
    }

    /**
     * Create an instance of this class with {@link #qPlugin()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the plugin card.
     * </p>
     * 
     * @param qPlugin
     *        A container for the properties of the plugin card.
     */
    public static Card fromQPlugin(Consumer<QPluginCard.Builder> qPlugin) {
        QPluginCard.Builder builder = QPluginCard.builder();
        qPlugin.accept(builder);
        return fromQPlugin(builder.build());
    }

    /**
     * Create an instance of this class with {@link #fileUpload()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the file upload card.
     * </p>
     * 
     * @param fileUpload
     *        A container for the properties of the file upload card.
     */
    public static Card fromFileUpload(FileUploadCard fileUpload) {
        return builder().fileUpload(fileUpload).build();
    }

    /**
     * Create an instance of this class with {@link #fileUpload()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the file upload card.
     * </p>
     * 
     * @param fileUpload
     *        A container for the properties of the file upload card.
     */
    public static Card fromFileUpload(Consumer<FileUploadCard.Builder> fileUpload) {
        FileUploadCard.Builder builder = FileUploadCard.builder();
        fileUpload.accept(builder);
        return fromFileUpload(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Card, T> g) {
        return obj -> g.apply((Card) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Card> {
        /**
         * <p>
         * A container for the properties of the text input card.
         * </p>
         * 
         * @param textInput
         *        A container for the properties of the text input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textInput(TextInputCard textInput);

        /**
         * <p>
         * A container for the properties of the text input card.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextInputCard.Builder} avoiding the need
         * to create one manually via {@link TextInputCard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextInputCard.Builder#build()} is called immediately and its
         * result is passed to {@link #textInput(TextInputCard)}.
         * 
         * @param textInput
         *        a consumer that will call methods on {@link TextInputCard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textInput(TextInputCard)
         */
        default Builder textInput(Consumer<TextInputCard.Builder> textInput) {
            return textInput(TextInputCard.builder().applyMutation(textInput).build());
        }

        /**
         * <p>
         * A container for the properties of the query card.
         * </p>
         * 
         * @param qQuery
         *        A container for the properties of the query card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qQuery(QQueryCard qQuery);

        /**
         * <p>
         * A container for the properties of the query card.
         * </p>
         * This is a convenience method that creates an instance of the {@link QQueryCard.Builder} avoiding the need to
         * create one manually via {@link QQueryCard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QQueryCard.Builder#build()} is called immediately and its result
         * is passed to {@link #qQuery(QQueryCard)}.
         * 
         * @param qQuery
         *        a consumer that will call methods on {@link QQueryCard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qQuery(QQueryCard)
         */
        default Builder qQuery(Consumer<QQueryCard.Builder> qQuery) {
            return qQuery(QQueryCard.builder().applyMutation(qQuery).build());
        }

        /**
         * <p>
         * A container for the properties of the plugin card.
         * </p>
         * 
         * @param qPlugin
         *        A container for the properties of the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qPlugin(QPluginCard qPlugin);

        /**
         * <p>
         * A container for the properties of the plugin card.
         * </p>
         * This is a convenience method that creates an instance of the {@link QPluginCard.Builder} avoiding the need to
         * create one manually via {@link QPluginCard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QPluginCard.Builder#build()} is called immediately and its result
         * is passed to {@link #qPlugin(QPluginCard)}.
         * 
         * @param qPlugin
         *        a consumer that will call methods on {@link QPluginCard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qPlugin(QPluginCard)
         */
        default Builder qPlugin(Consumer<QPluginCard.Builder> qPlugin) {
            return qPlugin(QPluginCard.builder().applyMutation(qPlugin).build());
        }

        /**
         * <p>
         * A container for the properties of the file upload card.
         * </p>
         * 
         * @param fileUpload
         *        A container for the properties of the file upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileUpload(FileUploadCard fileUpload);

        /**
         * <p>
         * A container for the properties of the file upload card.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileUploadCard.Builder} avoiding the need
         * to create one manually via {@link FileUploadCard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileUploadCard.Builder#build()} is called immediately and its
         * result is passed to {@link #fileUpload(FileUploadCard)}.
         * 
         * @param fileUpload
         *        a consumer that will call methods on {@link FileUploadCard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileUpload(FileUploadCard)
         */
        default Builder fileUpload(Consumer<FileUploadCard.Builder> fileUpload) {
            return fileUpload(FileUploadCard.builder().applyMutation(fileUpload).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextInputCard textInput;

        private QQueryCard qQuery;

        private QPluginCard qPlugin;

        private FileUploadCard fileUpload;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Card model) {
            textInput(model.textInput);
            qQuery(model.qQuery);
            qPlugin(model.qPlugin);
            fileUpload(model.fileUpload);
        }

        public final TextInputCard.Builder getTextInput() {
            return textInput != null ? textInput.toBuilder() : null;
        }

        public final void setTextInput(TextInputCard.BuilderImpl textInput) {
            Object oldValue = this.textInput;
            this.textInput = textInput != null ? textInput.build() : null;
            handleUnionValueChange(Type.TEXT_INPUT, oldValue, this.textInput);
        }

        @Override
        public final Builder textInput(TextInputCard textInput) {
            Object oldValue = this.textInput;
            this.textInput = textInput;
            handleUnionValueChange(Type.TEXT_INPUT, oldValue, this.textInput);
            return this;
        }

        public final QQueryCard.Builder getQQuery() {
            return qQuery != null ? qQuery.toBuilder() : null;
        }

        public final void setQQuery(QQueryCard.BuilderImpl qQuery) {
            Object oldValue = this.qQuery;
            this.qQuery = qQuery != null ? qQuery.build() : null;
            handleUnionValueChange(Type.Q_QUERY, oldValue, this.qQuery);
        }

        @Override
        public final Builder qQuery(QQueryCard qQuery) {
            Object oldValue = this.qQuery;
            this.qQuery = qQuery;
            handleUnionValueChange(Type.Q_QUERY, oldValue, this.qQuery);
            return this;
        }

        public final QPluginCard.Builder getQPlugin() {
            return qPlugin != null ? qPlugin.toBuilder() : null;
        }

        public final void setQPlugin(QPluginCard.BuilderImpl qPlugin) {
            Object oldValue = this.qPlugin;
            this.qPlugin = qPlugin != null ? qPlugin.build() : null;
            handleUnionValueChange(Type.Q_PLUGIN, oldValue, this.qPlugin);
        }

        @Override
        public final Builder qPlugin(QPluginCard qPlugin) {
            Object oldValue = this.qPlugin;
            this.qPlugin = qPlugin;
            handleUnionValueChange(Type.Q_PLUGIN, oldValue, this.qPlugin);
            return this;
        }

        public final FileUploadCard.Builder getFileUpload() {
            return fileUpload != null ? fileUpload.toBuilder() : null;
        }

        public final void setFileUpload(FileUploadCard.BuilderImpl fileUpload) {
            Object oldValue = this.fileUpload;
            this.fileUpload = fileUpload != null ? fileUpload.build() : null;
            handleUnionValueChange(Type.FILE_UPLOAD, oldValue, this.fileUpload);
        }

        @Override
        public final Builder fileUpload(FileUploadCard fileUpload) {
            Object oldValue = this.fileUpload;
            this.fileUpload = fileUpload;
            handleUnionValueChange(Type.FILE_UPLOAD, oldValue, this.fileUpload);
            return this;
        }

        @Override
        public Card build() {
            return new Card(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Card#type()
     */
    public enum Type {
        TEXT_INPUT,

        Q_QUERY,

        Q_PLUGIN,

        FILE_UPLOAD,

        UNKNOWN_TO_SDK_VERSION
    }
}
