/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value or result associated with a card in a Amazon Q App session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CardValue implements SdkPojo, Serializable, ToCopyableBuilder<CardValue.Builder, CardValue> {
    private static final SdkField<String> CARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cardId")
            .getter(getter(CardValue::cardId)).setter(setter(Builder::cardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardId").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(CardValue::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_ID_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cardId;

    private final String value;

    private CardValue(BuilderImpl builder) {
        this.cardId = builder.cardId;
        this.value = builder.value;
    }

    /**
     * <p>
     * The unique identifier of the card.
     * </p>
     * 
     * @return The unique identifier of the card.
     */
    public final String cardId() {
        return cardId;
    }

    /**
     * <p>
     * The value or result associated with the card.
     * </p>
     * 
     * @return The value or result associated with the card.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cardId());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CardValue)) {
            return false;
        }
        CardValue other = (CardValue) obj;
        return Objects.equals(cardId(), other.cardId()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CardValue").add("CardId", cardId()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cardId":
            return Optional.ofNullable(clazz.cast(cardId()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CardValue, T> g) {
        return obj -> g.apply((CardValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CardValue> {
        /**
         * <p>
         * The unique identifier of the card.
         * </p>
         * 
         * @param cardId
         *        The unique identifier of the card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardId(String cardId);

        /**
         * <p>
         * The value or result associated with the card.
         * </p>
         * 
         * @param value
         *        The value or result associated with the card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String cardId;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CardValue model) {
            cardId(model.cardId);
            value(model.value);
        }

        public final String getCardId() {
            return cardId;
        }

        public final void setCardId(String cardId) {
            this.cardId = cardId;
        }

        @Override
        public final Builder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public CardValue build() {
            return new CardValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
