/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartQAppSessionRequest extends QAppsRequest implements
        ToCopyableBuilder<StartQAppSessionRequest.Builder, StartQAppSessionRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(StartQAppSessionRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(StartQAppSessionRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<Integer> APP_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("appVersion").getter(getter(StartQAppSessionRequest::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<List<CardValue>> INITIAL_VALUES_FIELD = SdkField
            .<List<CardValue>> builder(MarshallingType.LIST)
            .memberName("initialValues")
            .getter(getter(StartQAppSessionRequest::initialValues))
            .setter(setter(Builder::initialValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CardValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(CardValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartQAppSessionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            APP_ID_FIELD, APP_VERSION_FIELD, INITIAL_VALUES_FIELD, TAGS_FIELD));

    private final String instanceId;

    private final String appId;

    private final Integer appVersion;

    private final List<CardValue> initialValues;

    private final Map<String, String> tags;

    private StartQAppSessionRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.appId = builder.appId;
        this.appVersion = builder.appVersion;
        this.initialValues = builder.initialValues;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application environment instance.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application environment instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier of the Q App to start a session for.
     * </p>
     * 
     * @return The unique identifier of the Q App to start a session for.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The version of the Q App to use for the session.
     * </p>
     * 
     * @return The version of the Q App to use for the session.
     */
    public final Integer appVersion() {
        return appVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the InitialValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInitialValues() {
        return initialValues != null && !(initialValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional initial input values to provide for the Q App session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitialValues} method.
     * </p>
     * 
     * @return Optional initial input values to provide for the Q App session.
     */
    public final List<CardValue> initialValues() {
        return initialValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional tags to associate with the new Q App session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional tags to associate with the new Q App session.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasInitialValues() ? initialValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQAppSessionRequest)) {
            return false;
        }
        StartQAppSessionRequest other = (StartQAppSessionRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(appId(), other.appId())
                && Objects.equals(appVersion(), other.appVersion()) && hasInitialValues() == other.hasInitialValues()
                && Objects.equals(initialValues(), other.initialValues()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartQAppSessionRequest").add("InstanceId", instanceId()).add("AppId", appId())
                .add("AppVersion", appVersion()).add("InitialValues", hasInitialValues() ? initialValues() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "initialValues":
            return Optional.ofNullable(clazz.cast(initialValues()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartQAppSessionRequest, T> g) {
        return obj -> g.apply((StartQAppSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartQAppSessionRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Q Business application environment instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier of the Amazon Q Business application environment instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier of the Q App to start a session for.
         * </p>
         * 
         * @param appId
         *        The unique identifier of the Q App to start a session for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The version of the Q App to use for the session.
         * </p>
         * 
         * @param appVersion
         *        The version of the Q App to use for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(Integer appVersion);

        /**
         * <p>
         * Optional initial input values to provide for the Q App session.
         * </p>
         * 
         * @param initialValues
         *        Optional initial input values to provide for the Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialValues(Collection<CardValue> initialValues);

        /**
         * <p>
         * Optional initial input values to provide for the Q App session.
         * </p>
         * 
         * @param initialValues
         *        Optional initial input values to provide for the Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialValues(CardValue... initialValues);

        /**
         * <p>
         * Optional initial input values to provide for the Q App session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.CardValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qapps.model.CardValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qapps.model.CardValue.Builder#build()} is called immediately and its
         * result is passed to {@link #initialValues(List<CardValue>)}.
         * 
         * @param initialValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qapps.model.CardValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialValues(java.util.Collection<CardValue>)
         */
        Builder initialValues(Consumer<CardValue.Builder>... initialValues);

        /**
         * <p>
         * Optional tags to associate with the new Q App session.
         * </p>
         * 
         * @param tags
         *        Optional tags to associate with the new Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QAppsRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String appId;

        private Integer appVersion;

        private List<CardValue> initialValues = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartQAppSessionRequest model) {
            super(model);
            instanceId(model.instanceId);
            appId(model.appId);
            appVersion(model.appVersion);
            initialValues(model.initialValues);
            tags(model.tags);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final Integer getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(Integer appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(Integer appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final List<CardValue.Builder> getInitialValues() {
            List<CardValue.Builder> result = CardValueListCopier.copyToBuilder(this.initialValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInitialValues(Collection<CardValue.BuilderImpl> initialValues) {
            this.initialValues = CardValueListCopier.copyFromBuilder(initialValues);
        }

        @Override
        public final Builder initialValues(Collection<CardValue> initialValues) {
            this.initialValues = CardValueListCopier.copy(initialValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initialValues(CardValue... initialValues) {
            initialValues(Arrays.asList(initialValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initialValues(Consumer<CardValue.Builder>... initialValues) {
            initialValues(Stream.of(initialValues).map(c -> CardValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQAppSessionRequest build() {
            return new StartQAppSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
