/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status and value of a card in an active Amazon Q App session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CardStatus implements SdkPojo, Serializable, ToCopyableBuilder<CardStatus.Builder, CardStatus> {
    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentState").getter(getter(CardStatus::currentStateAsString)).setter(setter(Builder::currentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentState").build()).build();

    private static final SdkField<String> CURRENT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentValue").getter(getter(CardStatus::currentValue)).setter(setter(Builder::currentValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_STATE_FIELD,
            CURRENT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String currentState;

    private final String currentValue;

    private CardStatus(BuilderImpl builder) {
        this.currentState = builder.currentState;
        this.currentValue = builder.currentValue;
    }

    /**
     * <p>
     * The current state of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentStateAsString}.
     * </p>
     * 
     * @return The current state of the card.
     * @see ExecutionStatus
     */
    public final ExecutionStatus currentState() {
        return ExecutionStatus.fromValue(currentState);
    }

    /**
     * <p>
     * The current state of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentStateAsString}.
     * </p>
     * 
     * @return The current state of the card.
     * @see ExecutionStatus
     */
    public final String currentStateAsString() {
        return currentState;
    }

    /**
     * <p>
     * The current value or result associated with the card.
     * </p>
     * 
     * @return The current value or result associated with the card.
     */
    public final String currentValue() {
        return currentValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CardStatus)) {
            return false;
        }
        CardStatus other = (CardStatus) obj;
        return Objects.equals(currentStateAsString(), other.currentStateAsString())
                && Objects.equals(currentValue(), other.currentValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CardStatus").add("CurrentState", currentStateAsString()).add("CurrentValue", currentValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "currentState":
            return Optional.ofNullable(clazz.cast(currentStateAsString()));
        case "currentValue":
            return Optional.ofNullable(clazz.cast(currentValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CardStatus, T> g) {
        return obj -> g.apply((CardStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CardStatus> {
        /**
         * <p>
         * The current state of the card.
         * </p>
         * 
         * @param currentState
         *        The current state of the card.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder currentState(String currentState);

        /**
         * <p>
         * The current state of the card.
         * </p>
         * 
         * @param currentState
         *        The current state of the card.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder currentState(ExecutionStatus currentState);

        /**
         * <p>
         * The current value or result associated with the card.
         * </p>
         * 
         * @param currentValue
         *        The current value or result associated with the card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentValue(String currentValue);
    }

    static final class BuilderImpl implements Builder {
        private String currentState;

        private String currentValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CardStatus model) {
            currentState(model.currentState);
            currentValue(model.currentValue);
        }

        public final String getCurrentState() {
            return currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(ExecutionStatus currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public final String getCurrentValue() {
            return currentValue;
        }

        public final void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }

        @Override
        public final Builder currentValue(String currentValue) {
            this.currentValue = currentValue;
            return this;
        }

        @Override
        public CardStatus build() {
            return new CardStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
