/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input shape for defining a plugin card in an Amazon Q App.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QPluginCardInput implements SdkPojo, Serializable,
        ToCopyableBuilder<QPluginCardInput.Builder, QPluginCardInput> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(QPluginCardInput::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(QPluginCardInput::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(QPluginCardInput::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prompt")
            .getter(getter(QPluginCardInput::prompt)).setter(setter(Builder::prompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()).build();

    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginId").getter(getter(QPluginCardInput::pluginId)).setter(setter(Builder::pluginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ID_FIELD,
            TYPE_FIELD, PROMPT_FIELD, PLUGIN_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String id;

    private final String type;

    private final String prompt;

    private final String pluginId;

    private QPluginCardInput(BuilderImpl builder) {
        this.title = builder.title;
        this.id = builder.id;
        this.type = builder.type;
        this.prompt = builder.prompt;
        this.pluginId = builder.pluginId;
    }

    /**
     * <p>
     * The title or label of the plugin card.
     * </p>
     * 
     * @return The title or label of the plugin card.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The unique identifier of the plugin card.
     * </p>
     * 
     * @return The unique identifier of the plugin card.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final CardType type() {
        return CardType.fromValue(type);
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The prompt or instructions displayed for the plugin card.
     * </p>
     * 
     * @return The prompt or instructions displayed for the plugin card.
     */
    public final String prompt() {
        return prompt;
    }

    /**
     * <p>
     * The unique identifier of the plugin used by the card.
     * </p>
     * 
     * @return The unique identifier of the plugin used by the card.
     */
    public final String pluginId() {
        return pluginId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prompt());
        hashCode = 31 * hashCode + Objects.hashCode(pluginId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QPluginCardInput)) {
            return false;
        }
        QPluginCardInput other = (QPluginCardInput) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(id(), other.id())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(prompt(), other.prompt())
                && Objects.equals(pluginId(), other.pluginId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QPluginCardInput").add("Title", title()).add("Id", id()).add("Type", typeAsString())
                .add("Prompt", prompt()).add("PluginId", pluginId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "prompt":
            return Optional.ofNullable(clazz.cast(prompt()));
        case "pluginId":
            return Optional.ofNullable(clazz.cast(pluginId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QPluginCardInput, T> g) {
        return obj -> g.apply((QPluginCardInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QPluginCardInput> {
        /**
         * <p>
         * The title or label of the plugin card.
         * </p>
         * 
         * @param title
         *        The title or label of the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The unique identifier of the plugin card.
         * </p>
         * 
         * @param id
         *        The unique identifier of the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(CardType type);

        /**
         * <p>
         * The prompt or instructions displayed for the plugin card.
         * </p>
         * 
         * @param prompt
         *        The prompt or instructions displayed for the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prompt(String prompt);

        /**
         * <p>
         * The unique identifier of the plugin used by the card.
         * </p>
         * 
         * @param pluginId
         *        The unique identifier of the plugin used by the card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginId(String pluginId);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String id;

        private String type;

        private String prompt;

        private String pluginId;

        private BuilderImpl() {
        }

        private BuilderImpl(QPluginCardInput model) {
            title(model.title);
            id(model.id);
            type(model.type);
            prompt(model.prompt);
            pluginId(model.pluginId);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPrompt() {
            return prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public final String getPluginId() {
            return pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @Override
        public QPluginCardInput build() {
            return new QPluginCardInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
