/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.PermissionOutputActionEnum;
import software.amazon.awssdk.services.qapps.model.PrincipalOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PermissionOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PermissionOutput> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(PermissionOutput.getter(PermissionOutput::actionAsString)).setter(PermissionOutput.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<PrincipalOutput> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("principal").getter(PermissionOutput.getter(PermissionOutput::principal)).setter(PermissionOutput.setter(Builder::principal)).constructor(PrincipalOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, PRINCIPAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("action", ACTION_FIELD);
            this.put("principal", PRINCIPAL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String action;
    private final PrincipalOutput principal;

    private PermissionOutput(BuilderImpl builder) {
        this.action = builder.action;
        this.principal = builder.principal;
    }

    public final PermissionOutputActionEnum action() {
        return PermissionOutputActionEnum.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final PrincipalOutput principal() {
        return this.principal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionOutput)) {
            return false;
        }
        PermissionOutput other = (PermissionOutput)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.principal(), other.principal());
    }

    public final String toString() {
        return ToString.builder((String)"PermissionOutput").add("Action", (Object)this.actionAsString()).add("Principal", (Object)this.principal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PermissionOutput, T> g) {
        return obj -> g.apply((PermissionOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private PrincipalOutput principal;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionOutput model) {
            this.action(model.action);
            this.principal(model.principal);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(PermissionOutputActionEnum action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final PrincipalOutput.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(PrincipalOutput.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(PrincipalOutput principal) {
            this.principal = principal;
            return this;
        }

        public PermissionOutput build() {
            return new PermissionOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PermissionOutput> {
        public Builder action(String var1);

        public Builder action(PermissionOutputActionEnum var1);

        public Builder principal(PrincipalOutput var1);

        default public Builder principal(Consumer<PrincipalOutput.Builder> principal) {
            return this.principal((PrincipalOutput)((PrincipalOutput.Builder)PrincipalOutput.builder().applyMutation(principal)).build());
        }
    }
}

