/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.User;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QAppSessionData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QAppSessionData> {
    private static final SdkField<String> CARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cardId").getter(QAppSessionData.getter(QAppSessionData::cardId)).setter(QAppSessionData.setter(Builder::cardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardId").build()}).build();
    private static final SdkField<Document> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("value").getter(QAppSessionData.getter(QAppSessionData::value)).setter(QAppSessionData.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<User> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("user").getter(QAppSessionData.getter(QAppSessionData::user)).setter(QAppSessionData.setter(Builder::user)).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<String> SUBMISSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("submissionId").getter(QAppSessionData.getter(QAppSessionData::submissionId)).setter(QAppSessionData.setter(Builder::submissionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submissionId").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(QAppSessionData.getter(QAppSessionData::timestamp)).setter(QAppSessionData.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_ID_FIELD, VALUE_FIELD, USER_FIELD, SUBMISSION_ID_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cardId", CARD_ID_FIELD);
            this.put("value", VALUE_FIELD);
            this.put("user", USER_FIELD);
            this.put("submissionId", SUBMISSION_ID_FIELD);
            this.put("timestamp", TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String cardId;
    private final Document value;
    private final User user;
    private final String submissionId;
    private final Instant timestamp;

    private QAppSessionData(BuilderImpl builder) {
        this.cardId = builder.cardId;
        this.value = builder.value;
        this.user = builder.user;
        this.submissionId = builder.submissionId;
        this.timestamp = builder.timestamp;
    }

    public final String cardId() {
        return this.cardId;
    }

    public final Document value() {
        return this.value;
    }

    public final User user() {
        return this.user;
    }

    public final String submissionId() {
        return this.submissionId;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.submissionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QAppSessionData)) {
            return false;
        }
        QAppSessionData other = (QAppSessionData)obj;
        return Objects.equals(this.cardId(), other.cardId()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.submissionId(), other.submissionId()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"QAppSessionData").add("CardId", (Object)this.cardId()).add("Value", (Object)this.value()).add("User", (Object)this.user()).add("SubmissionId", (Object)this.submissionId()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cardId": {
                return Optional.ofNullable(clazz.cast(this.cardId()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "submissionId": {
                return Optional.ofNullable(clazz.cast(this.submissionId()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QAppSessionData, T> g) {
        return obj -> g.apply((QAppSessionData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cardId;
        private Document value;
        private User user;
        private String submissionId;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(QAppSessionData model) {
            this.cardId(model.cardId);
            this.value(model.value);
            this.user(model.user);
            this.submissionId(model.submissionId);
            this.timestamp(model.timestamp);
        }

        public final String getCardId() {
            return this.cardId;
        }

        public final void setCardId(String cardId) {
            this.cardId = cardId;
        }

        @Override
        public final Builder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public final Document getValue() {
            return this.value;
        }

        public final void setValue(Document value) {
            this.value = value;
        }

        @Override
        public final Builder value(Document value) {
            this.value = value;
            return this;
        }

        public final User.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(User.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final String getSubmissionId() {
            return this.submissionId;
        }

        public final void setSubmissionId(String submissionId) {
            this.submissionId = submissionId;
        }

        @Override
        public final Builder submissionId(String submissionId) {
            this.submissionId = submissionId;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public QAppSessionData build() {
            return new QAppSessionData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QAppSessionData> {
        public Builder cardId(String var1);

        public Builder value(Document var1);

        public Builder user(User var1);

        default public Builder user(Consumer<User.Builder> user) {
            return this.user((User)((User.Builder)User.builder().applyMutation(user)).build());
        }

        public Builder submissionId(String var1);

        public Builder timestamp(Instant var1);
    }
}

