/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.qapps.internal.QAppsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.qapps.model.AccessDeniedException;
import software.amazon.awssdk.services.qapps.model.AssociateLibraryItemReviewRequest;
import software.amazon.awssdk.services.qapps.model.AssociateLibraryItemReviewResponse;
import software.amazon.awssdk.services.qapps.model.AssociateQAppWithUserRequest;
import software.amazon.awssdk.services.qapps.model.AssociateQAppWithUserResponse;
import software.amazon.awssdk.services.qapps.model.BatchCreateCategoryRequest;
import software.amazon.awssdk.services.qapps.model.BatchCreateCategoryResponse;
import software.amazon.awssdk.services.qapps.model.BatchDeleteCategoryRequest;
import software.amazon.awssdk.services.qapps.model.BatchDeleteCategoryResponse;
import software.amazon.awssdk.services.qapps.model.BatchUpdateCategoryRequest;
import software.amazon.awssdk.services.qapps.model.BatchUpdateCategoryResponse;
import software.amazon.awssdk.services.qapps.model.ConflictException;
import software.amazon.awssdk.services.qapps.model.ContentTooLargeException;
import software.amazon.awssdk.services.qapps.model.CreateLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.CreateLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.CreatePresignedUrlRequest;
import software.amazon.awssdk.services.qapps.model.CreatePresignedUrlResponse;
import software.amazon.awssdk.services.qapps.model.CreateQAppRequest;
import software.amazon.awssdk.services.qapps.model.CreateQAppResponse;
import software.amazon.awssdk.services.qapps.model.DeleteLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.DeleteLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.DeleteQAppRequest;
import software.amazon.awssdk.services.qapps.model.DeleteQAppResponse;
import software.amazon.awssdk.services.qapps.model.DescribeQAppPermissionsRequest;
import software.amazon.awssdk.services.qapps.model.DescribeQAppPermissionsResponse;
import software.amazon.awssdk.services.qapps.model.DisassociateLibraryItemReviewRequest;
import software.amazon.awssdk.services.qapps.model.DisassociateLibraryItemReviewResponse;
import software.amazon.awssdk.services.qapps.model.DisassociateQAppFromUserRequest;
import software.amazon.awssdk.services.qapps.model.DisassociateQAppFromUserResponse;
import software.amazon.awssdk.services.qapps.model.ExportQAppSessionDataRequest;
import software.amazon.awssdk.services.qapps.model.ExportQAppSessionDataResponse;
import software.amazon.awssdk.services.qapps.model.GetLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.GetLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.GetQAppRequest;
import software.amazon.awssdk.services.qapps.model.GetQAppResponse;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionMetadataRequest;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionMetadataResponse;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.ImportDocumentRequest;
import software.amazon.awssdk.services.qapps.model.ImportDocumentResponse;
import software.amazon.awssdk.services.qapps.model.InternalServerException;
import software.amazon.awssdk.services.qapps.model.ListCategoriesRequest;
import software.amazon.awssdk.services.qapps.model.ListCategoriesResponse;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse;
import software.amazon.awssdk.services.qapps.model.ListQAppSessionDataRequest;
import software.amazon.awssdk.services.qapps.model.ListQAppSessionDataResponse;
import software.amazon.awssdk.services.qapps.model.ListQAppsRequest;
import software.amazon.awssdk.services.qapps.model.ListQAppsResponse;
import software.amazon.awssdk.services.qapps.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qapps.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qapps.model.PredictQAppRequest;
import software.amazon.awssdk.services.qapps.model.PredictQAppResponse;
import software.amazon.awssdk.services.qapps.model.QAppsException;
import software.amazon.awssdk.services.qapps.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qapps.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.qapps.model.StartQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.StartQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.StopQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.StopQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.TagResourceRequest;
import software.amazon.awssdk.services.qapps.model.TagResourceResponse;
import software.amazon.awssdk.services.qapps.model.ThrottlingException;
import software.amazon.awssdk.services.qapps.model.UnauthorizedException;
import software.amazon.awssdk.services.qapps.model.UntagResourceRequest;
import software.amazon.awssdk.services.qapps.model.UntagResourceResponse;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemMetadataRequest;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemMetadataResponse;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionMetadataRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionMetadataResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.ValidationException;
import software.amazon.awssdk.services.qapps.transform.AssociateLibraryItemReviewRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.AssociateQAppWithUserRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.BatchCreateCategoryRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.BatchDeleteCategoryRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.BatchUpdateCategoryRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.CreateLibraryItemRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.CreatePresignedUrlRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.CreateQAppRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.DeleteLibraryItemRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.DeleteQAppRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.DescribeQAppPermissionsRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.DisassociateLibraryItemReviewRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.DisassociateQAppFromUserRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.ExportQAppSessionDataRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.GetLibraryItemRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.GetQAppRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.GetQAppSessionMetadataRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.GetQAppSessionRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.ImportDocumentRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.ListCategoriesRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.ListLibraryItemsRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.ListQAppSessionDataRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.ListQAppsRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.PredictQAppRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.StartQAppSessionRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.StopQAppSessionRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.UpdateLibraryItemMetadataRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.UpdateLibraryItemRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.UpdateQAppPermissionsRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.UpdateQAppRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.UpdateQAppSessionMetadataRequestMarshaller;
import software.amazon.awssdk.services.qapps.transform.UpdateQAppSessionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link QAppsClient}.
 *
 * @see QAppsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultQAppsClient implements QAppsClient {
    private static final Logger log = Logger.loggerFor(DefaultQAppsClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQAppsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates a rating or review for a library item with the user submitting the request. This increments the rating
     * count for the specified library item.
     * </p>
     *
     * @param associateLibraryItemReviewRequest
     * @return Result of the AssociateLibraryItemReview operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.AssociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateLibraryItemReviewResponse associateLibraryItemReview(
            AssociateLibraryItemReviewRequest associateLibraryItemReviewRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateLibraryItemReviewResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateLibraryItemReviewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateLibraryItemReviewRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateLibraryItemReviewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateLibraryItemReview");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateLibraryItemReviewRequest, AssociateLibraryItemReviewResponse>()
                            .withOperationName("AssociateLibraryItemReview").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateLibraryItemReviewRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateLibraryItemReviewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This operation creates a link between the user's identity calling the operation and a specific Q App. This is
     * useful to mark the Q App as a <i>favorite</i> for the user if the user doesn't own the Amazon Q App so they can
     * still run it and see it in their inventory of Q Apps.
     * </p>
     *
     * @param associateQAppWithUserRequest
     * @return Result of the AssociateQAppWithUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.AssociateQAppWithUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateQAppWithUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateQAppWithUserResponse associateQAppWithUser(AssociateQAppWithUserRequest associateQAppWithUserRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateQAppWithUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateQAppWithUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateQAppWithUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateQAppWithUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateQAppWithUser");

            return clientHandler.execute(new ClientExecutionParams<AssociateQAppWithUserRequest, AssociateQAppWithUserResponse>()
                    .withOperationName("AssociateQAppWithUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateQAppWithUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateQAppWithUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param batchCreateCategoryRequest
     * @return Result of the BatchCreateCategory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.BatchCreateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchCreateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchCreateCategoryResponse batchCreateCategory(BatchCreateCategoryRequest batchCreateCategoryRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateCategoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreateCategoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateCategoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchCreateCategoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateCategory");

            return clientHandler.execute(new ClientExecutionParams<BatchCreateCategoryRequest, BatchCreateCategoryResponse>()
                    .withOperationName("BatchCreateCategory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchCreateCategoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchCreateCategoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param batchDeleteCategoryRequest
     * @return Result of the BatchDeleteCategory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.BatchDeleteCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchDeleteCategory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchDeleteCategoryResponse batchDeleteCategory(BatchDeleteCategoryRequest batchDeleteCategoryRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteCategoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteCategoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteCategoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteCategoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteCategory");

            return clientHandler.execute(new ClientExecutionParams<BatchDeleteCategoryRequest, BatchDeleteCategoryResponse>()
                    .withOperationName("BatchDeleteCategory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchDeleteCategoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchDeleteCategoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param batchUpdateCategoryRequest
     * @return Result of the BatchUpdateCategory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.BatchUpdateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchUpdateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchUpdateCategoryResponse batchUpdateCategory(BatchUpdateCategoryRequest batchUpdateCategoryRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateCategoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdateCategoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateCategoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdateCategoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateCategory");

            return clientHandler.execute(new ClientExecutionParams<BatchUpdateCategoryRequest, BatchUpdateCategoryResponse>()
                    .withOperationName("BatchUpdateCategory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchUpdateCategoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchUpdateCategoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new library item for an Amazon Q App, allowing it to be discovered and used by other allowed users.
     * </p>
     *
     * @param createLibraryItemRequest
     * @return Result of the CreateLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.CreateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateLibraryItemResponse createLibraryItem(CreateLibraryItemRequest createLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLibraryItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateLibraryItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLibraryItemRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLibraryItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLibraryItem");

            return clientHandler.execute(new ClientExecutionParams<CreateLibraryItemRequest, CreateLibraryItemResponse>()
                    .withOperationName("CreateLibraryItem").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createLibraryItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLibraryItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a presigned URL for an S3 POST operation to upload a file. You can use this URL to set a default file for
     * a <code>FileUploadCard</code> in a Q App definition or to provide a file for a single Q App run. The
     * <code>scope</code> parameter determines how the file will be used, either at the app definition level or the app
     * session level.
     * </p>
     *
     * @param createPresignedUrlRequest
     * @return Result of the CreatePresignedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.CreatePresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreatePresignedUrl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePresignedUrlResponse createPresignedUrl(CreatePresignedUrlRequest createPresignedUrlRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePresignedUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePresignedUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPresignedUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPresignedUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedUrl");

            return clientHandler.execute(new ClientExecutionParams<CreatePresignedUrlRequest, CreatePresignedUrlResponse>()
                    .withOperationName("CreatePresignedUrl").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPresignedUrlRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePresignedUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Amazon Q App based on the provided definition. The Q App definition specifies the cards and flow of
     * the Q App. This operation also calculates the dependencies between the cards by inspecting the references in the
     * prompts.
     * </p>
     *
     * @param createQAppRequest
     * @return Result of the CreateQApp operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ContentTooLargeException
     *         The requested operation could not be completed because the content exceeds the maximum allowed size.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.CreateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateQAppResponse createQApp(CreateQAppRequest createQAppRequest) throws AccessDeniedException, ConflictException,
            ValidationException, InternalServerException, UnauthorizedException, ServiceQuotaExceededException,
            ContentTooLargeException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateQAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateQAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQApp");

            return clientHandler.execute(new ClientExecutionParams<CreateQAppRequest, CreateQAppResponse>()
                    .withOperationName("CreateQApp").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createQAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateQAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a library item for an Amazon Q App, removing it from the library so it can no longer be discovered or
     * used by other users.
     * </p>
     *
     * @param deleteLibraryItemRequest
     * @return Result of the DeleteLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DeleteLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLibraryItemResponse deleteLibraryItem(DeleteLibraryItemRequest deleteLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLibraryItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteLibraryItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLibraryItemRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLibraryItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLibraryItem");

            return clientHandler.execute(new ClientExecutionParams<DeleteLibraryItemRequest, DeleteLibraryItemResponse>()
                    .withOperationName("DeleteLibraryItem").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteLibraryItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLibraryItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q App owned by the user. If the Q App was previously published to the library, it is also
     * removed from the library.
     * </p>
     *
     * @param deleteQAppRequest
     * @return Result of the DeleteQApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DeleteQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteQApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteQAppResponse deleteQApp(DeleteQAppRequest deleteQAppRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteQAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteQAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQApp");

            return clientHandler.execute(new ClientExecutionParams<DeleteQAppRequest, DeleteQAppResponse>()
                    .withOperationName("DeleteQApp").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteQAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteQAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     *
     * @param describeQAppPermissionsRequest
     * @return Result of the DescribeQAppPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DescribeQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DescribeQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeQAppPermissionsResponse describeQAppPermissions(DescribeQAppPermissionsRequest describeQAppPermissionsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeQAppPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeQAppPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeQAppPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeQAppPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeQAppPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeQAppPermissionsRequest, DescribeQAppPermissionsResponse>()
                            .withOperationName("DescribeQAppPermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeQAppPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeQAppPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a rating or review previously submitted by the user for a library item.
     * </p>
     *
     * @param disassociateLibraryItemReviewRequest
     * @return Result of the DisassociateLibraryItemReview operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DisassociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateLibraryItemReviewResponse disassociateLibraryItemReview(
            DisassociateLibraryItemReviewRequest disassociateLibraryItemReviewRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateLibraryItemReviewResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateLibraryItemReviewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateLibraryItemReviewRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateLibraryItemReviewRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateLibraryItemReview");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateLibraryItemReviewRequest, DisassociateLibraryItemReviewResponse>()
                            .withOperationName("DisassociateLibraryItemReview").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateLibraryItemReviewRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateLibraryItemReviewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a Q App from a user removing the user's access to run the Q App.
     * </p>
     *
     * @param disassociateQAppFromUserRequest
     * @return Result of the DisassociateQAppFromUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DisassociateQAppFromUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateQAppFromUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateQAppFromUserResponse disassociateQAppFromUser(
            DisassociateQAppFromUserRequest disassociateQAppFromUserRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateQAppFromUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateQAppFromUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateQAppFromUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateQAppFromUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateQAppFromUser");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateQAppFromUserRequest, DisassociateQAppFromUserResponse>()
                            .withOperationName("DisassociateQAppFromUser").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateQAppFromUserRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateQAppFromUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports the collected data of a Q App data collection session.
     * </p>
     *
     * @param exportQAppSessionDataRequest
     * @return Result of the ExportQAppSessionData operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ExportQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ExportQAppSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ExportQAppSessionDataResponse exportQAppSessionData(ExportQAppSessionDataRequest exportQAppSessionDataRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ServiceQuotaExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportQAppSessionDataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExportQAppSessionDataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportQAppSessionDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportQAppSessionDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportQAppSessionData");

            return clientHandler.execute(new ClientExecutionParams<ExportQAppSessionDataRequest, ExportQAppSessionDataResponse>()
                    .withOperationName("ExportQAppSessionData").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(exportQAppSessionDataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExportQAppSessionDataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details about a library item for an Amazon Q App, including its metadata, categories, ratings, and
     * usage statistics.
     * </p>
     *
     * @param getLibraryItemRequest
     * @return Result of the GetLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLibraryItemResponse getLibraryItem(GetLibraryItemRequest getLibraryItemRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLibraryItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLibraryItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLibraryItemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLibraryItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLibraryItem");

            return clientHandler.execute(new ClientExecutionParams<GetLibraryItemRequest, GetLibraryItemResponse>()
                    .withOperationName("GetLibraryItem").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLibraryItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLibraryItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the full details of an Q App, including its definition specifying the cards and flow.
     * </p>
     *
     * @param getQAppRequest
     * @return Result of the GetQApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetQAppResponse getQApp(GetQAppRequest getQAppRequest) throws ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetQAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQApp");

            return clientHandler.execute(new ClientExecutionParams<GetQAppRequest, GetQAppResponse>()
                    .withOperationName("GetQApp").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getQAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetQAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current state and results for an active session of an Amazon Q App.
     * </p>
     *
     * @param getQAppSessionRequest
     * @return Result of the GetQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetQAppSessionResponse getQAppSession(GetQAppSessionRequest getQAppSessionRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQAppSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetQAppSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQAppSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQAppSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQAppSession");

            return clientHandler.execute(new ClientExecutionParams<GetQAppSessionRequest, GetQAppSessionResponse>()
                    .withOperationName("GetQAppSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getQAppSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetQAppSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current configuration of a Q App session.
     * </p>
     *
     * @param getQAppSessionMetadataRequest
     * @return Result of the GetQAppSessionMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSessionMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetQAppSessionMetadataResponse getQAppSessionMetadata(GetQAppSessionMetadataRequest getQAppSessionMetadataRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQAppSessionMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetQAppSessionMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQAppSessionMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQAppSessionMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQAppSessionMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<GetQAppSessionMetadataRequest, GetQAppSessionMetadataResponse>()
                            .withOperationName("GetQAppSessionMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getQAppSessionMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetQAppSessionMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Uploads a file that can then be used either as a default in a <code>FileUploadCard</code> from Q App definition
     * or as a file that is used inside a single Q App run. The purpose of the document is determined by a scope
     * parameter that indicates whether it is at the app definition level or at the app session level.
     * </p>
     *
     * @param importDocumentRequest
     * @return Result of the ImportDocument operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ContentTooLargeException
     *         The requested operation could not be completed because the content exceeds the maximum allowed size.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ImportDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ImportDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ImportDocumentResponse importDocument(ImportDocumentRequest importDocumentRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ContentTooLargeException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportDocumentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportDocument");

            return clientHandler.execute(new ClientExecutionParams<ImportDocumentRequest, ImportDocumentResponse>()
                    .withOperationName("ImportDocument").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the categories of a Amazon Q Business application environment instance. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param listCategoriesRequest
     * @return Result of the ListCategories operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListCategories" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCategoriesResponse listCategories(ListCategoriesRequest listCategoriesRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCategoriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCategoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCategoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCategoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCategories");

            return clientHandler.execute(new ClientExecutionParams<ListCategoriesRequest, ListCategoriesResponse>()
                    .withOperationName("ListCategories").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCategoriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCategoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the library items for Amazon Q Apps that are published and available for users in your Amazon Web Services
     * account.
     * </p>
     *
     * @param listLibraryItemsRequest
     * @return Result of the ListLibraryItems operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListLibraryItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLibraryItemsResponse listLibraryItems(ListLibraryItemsRequest listLibraryItemsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLibraryItemsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLibraryItemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLibraryItemsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLibraryItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLibraryItems");

            return clientHandler.execute(new ClientExecutionParams<ListLibraryItemsRequest, ListLibraryItemsResponse>()
                    .withOperationName("ListLibraryItems").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listLibraryItemsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLibraryItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the collected data of a Q App data collection session.
     * </p>
     *
     * @param listQAppSessionDataRequest
     * @return Result of the ListQAppSessionData operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQAppSessionData" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListQAppSessionDataResponse listQAppSessionData(ListQAppSessionDataRequest listQAppSessionDataRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListQAppSessionDataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListQAppSessionDataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQAppSessionDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQAppSessionDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQAppSessionData");

            return clientHandler.execute(new ClientExecutionParams<ListQAppSessionDataRequest, ListQAppSessionDataResponse>()
                    .withOperationName("ListQAppSessionData").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listQAppSessionDataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListQAppSessionDataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the Amazon Q Apps owned by or associated with the user either because they created it or because they used
     * it from the library in the past. The user identity is extracted from the credentials used to invoke this
     * operation..
     * </p>
     *
     * @param listQAppsRequest
     * @return Result of the ListQApps operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListQApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListQAppsResponse listQApps(ListQAppsRequest listQAppsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListQAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListQAppsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQAppsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQAppsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQApps");

            return clientHandler.execute(new ClientExecutionParams<ListQAppsRequest, ListQAppsResponse>()
                    .withOperationName("ListQApps").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listQAppsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListQAppsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags associated with an Amazon Q Apps resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates an Amazon Q App definition based on either a conversation or a problem statement provided as input.The
     * resulting app definition can be used to call <code>CreateQApp</code>. This API doesn't create Amazon Q Apps
     * directly.
     * </p>
     *
     * @param predictQAppRequest
     * @return Result of the PredictQApp operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.PredictQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/PredictQApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PredictQAppResponse predictQApp(PredictQAppRequest predictQAppRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PredictQAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PredictQAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(predictQAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, predictQAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PredictQApp");

            return clientHandler.execute(new ClientExecutionParams<PredictQAppRequest, PredictQAppResponse>()
                    .withOperationName("PredictQApp").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(predictQAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PredictQAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a new session for an Amazon Q App, allowing inputs to be provided and the app to be run.
     * </p>
     * <note>
     * <p>
     * Each Q App session will be condensed into a single conversation in the web experience.
     * </p>
     * </note>
     *
     * @param startQAppSessionRequest
     * @return Result of the StartQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.StartQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StartQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartQAppSessionResponse startQAppSession(StartQAppSessionRequest startQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartQAppSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartQAppSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startQAppSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startQAppSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartQAppSession");

            return clientHandler.execute(new ClientExecutionParams<StartQAppSessionRequest, StartQAppSessionResponse>()
                    .withOperationName("StartQAppSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startQAppSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartQAppSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops an active session for an Amazon Q App.This deletes all data related to the session and makes it invalid for
     * future uses. The results of the session will be persisted as part of the conversation.
     * </p>
     *
     * @param stopQAppSessionRequest
     * @return Result of the StopQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.StopQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StopQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopQAppSessionResponse stopQAppSession(StopQAppSessionRequest stopQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopQAppSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopQAppSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopQAppSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopQAppSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopQAppSession");

            return clientHandler.execute(new ClientExecutionParams<StopQAppSessionRequest, StopQAppSessionResponse>()
                    .withOperationName("StopQAppSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopQAppSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopQAppSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates tags with an Amazon Q Apps resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates tags from an Amazon Q Apps resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the library item for an Amazon Q App.
     * </p>
     *
     * @param updateLibraryItemRequest
     * @return Result of the UpdateLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateLibraryItemResponse updateLibraryItem(UpdateLibraryItemRequest updateLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLibraryItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateLibraryItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLibraryItemRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLibraryItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLibraryItem");

            return clientHandler.execute(new ClientExecutionParams<UpdateLibraryItemRequest, UpdateLibraryItemResponse>()
                    .withOperationName("UpdateLibraryItem").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateLibraryItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateLibraryItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the verification status of a library item for an Amazon Q App.
     * </p>
     *
     * @param updateLibraryItemMetadataRequest
     * @return Result of the UpdateLibraryItemMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateLibraryItemMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItemMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateLibraryItemMetadataResponse updateLibraryItemMetadata(
            UpdateLibraryItemMetadataRequest updateLibraryItemMetadataRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLibraryItemMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateLibraryItemMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLibraryItemMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLibraryItemMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLibraryItemMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateLibraryItemMetadataRequest, UpdateLibraryItemMetadataResponse>()
                            .withOperationName("UpdateLibraryItemMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateLibraryItemMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateLibraryItemMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Q App, allowing modifications to its title, description, and definition.
     * </p>
     *
     * @param updateQAppRequest
     * @return Result of the UpdateQApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ContentTooLargeException
     *         The requested operation could not be completed because the content exceeds the maximum allowed size.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateQAppResponse updateQApp(UpdateQAppRequest updateQAppRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ContentTooLargeException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateQAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateQAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQApp");

            return clientHandler.execute(new ClientExecutionParams<UpdateQAppRequest, UpdateQAppResponse>()
                    .withOperationName("UpdateQApp").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateQAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateQAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     *
     * @param updateQAppPermissionsRequest
     * @return Result of the UpdateQAppPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateQAppPermissionsResponse updateQAppPermissions(UpdateQAppPermissionsRequest updateQAppPermissionsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateQAppPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateQAppPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQAppPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQAppPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQAppPermissions");

            return clientHandler.execute(new ClientExecutionParams<UpdateQAppPermissionsRequest, UpdateQAppPermissionsResponse>()
                    .withOperationName("UpdateQAppPermissions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateQAppPermissionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateQAppPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the session for a given Q App <code>sessionId</code>. This is only valid when at least one card of the
     * session is in the <code>WAITING</code> state. Data for each <code>WAITING</code> card can be provided as input.
     * If inputs are not provided, the call will be accepted but session will not move forward. Inputs for cards that
     * are not in the <code>WAITING</code> status will be ignored.
     * </p>
     *
     * @param updateQAppSessionRequest
     * @return Result of the UpdateQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateQAppSessionResponse updateQAppSession(UpdateQAppSessionRequest updateQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateQAppSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateQAppSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQAppSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQAppSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQAppSession");

            return clientHandler.execute(new ClientExecutionParams<UpdateQAppSessionRequest, UpdateQAppSessionResponse>()
                    .withOperationName("UpdateQAppSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateQAppSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateQAppSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration metadata of a session for a given Q App <code>sessionId</code>.
     * </p>
     *
     * @param updateQAppSessionMetadataRequest
     * @return Result of the UpdateQAppSessionMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSessionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateQAppSessionMetadataResponse updateQAppSessionMetadata(
            UpdateQAppSessionMetadataRequest updateQAppSessionMetadataRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateQAppSessionMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateQAppSessionMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQAppSessionMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQAppSessionMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QApps");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQAppSessionMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateQAppSessionMetadataRequest, UpdateQAppSessionMetadataResponse>()
                            .withOperationName("UpdateQAppSessionMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateQAppSessionMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateQAppSessionMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        QAppsServiceClientConfigurationBuilder serviceConfigBuilder = new QAppsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(QAppsException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ContentTooLargeException")
                                .exceptionBuilderSupplier(ContentTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public final QAppsServiceClientConfiguration serviceClientConfiguration() {
        return new QAppsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
