/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for defining an Q App.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppDefinitionInput implements SdkPojo, Serializable,
        ToCopyableBuilder<AppDefinitionInput.Builder, AppDefinitionInput> {
    private static final SdkField<List<CardInput>> CARDS_FIELD = SdkField
            .<List<CardInput>> builder(MarshallingType.LIST)
            .memberName("cards")
            .getter(getter(AppDefinitionInput::cards))
            .setter(setter(Builder::cards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CardInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CardInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INITIAL_PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initialPrompt").getter(getter(AppDefinitionInput::initialPrompt)).setter(setter(Builder::initialPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialPrompt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARDS_FIELD,
            INITIAL_PROMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CardInput> cards;

    private final String initialPrompt;

    private AppDefinitionInput(BuilderImpl builder) {
        this.cards = builder.cards;
        this.initialPrompt = builder.initialPrompt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cards property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCards() {
        return cards != null && !(cards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cards that make up the Q App definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCards} method.
     * </p>
     * 
     * @return The cards that make up the Q App definition.
     */
    public final List<CardInput> cards() {
        return cards;
    }

    /**
     * <p>
     * The initial prompt displayed when the Q App is started.
     * </p>
     * 
     * @return The initial prompt displayed when the Q App is started.
     */
    public final String initialPrompt() {
        return initialPrompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCards() ? cards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(initialPrompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppDefinitionInput)) {
            return false;
        }
        AppDefinitionInput other = (AppDefinitionInput) obj;
        return hasCards() == other.hasCards() && Objects.equals(cards(), other.cards())
                && Objects.equals(initialPrompt(), other.initialPrompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppDefinitionInput").add("Cards", hasCards() ? cards() : null)
                .add("InitialPrompt", initialPrompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cards":
            return Optional.ofNullable(clazz.cast(cards()));
        case "initialPrompt":
            return Optional.ofNullable(clazz.cast(initialPrompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cards", CARDS_FIELD);
        map.put("initialPrompt", INITIAL_PROMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppDefinitionInput, T> g) {
        return obj -> g.apply((AppDefinitionInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppDefinitionInput> {
        /**
         * <p>
         * The cards that make up the Q App definition.
         * </p>
         * 
         * @param cards
         *        The cards that make up the Q App definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cards(Collection<CardInput> cards);

        /**
         * <p>
         * The cards that make up the Q App definition.
         * </p>
         * 
         * @param cards
         *        The cards that make up the Q App definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cards(CardInput... cards);

        /**
         * <p>
         * The cards that make up the Q App definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.CardInput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qapps.model.CardInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qapps.model.CardInput.Builder#build()} is called immediately and its
         * result is passed to {@link #cards(List<CardInput>)}.
         * 
         * @param cards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qapps.model.CardInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cards(java.util.Collection<CardInput>)
         */
        Builder cards(Consumer<CardInput.Builder>... cards);

        /**
         * <p>
         * The initial prompt displayed when the Q App is started.
         * </p>
         * 
         * @param initialPrompt
         *        The initial prompt displayed when the Q App is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialPrompt(String initialPrompt);
    }

    static final class BuilderImpl implements Builder {
        private List<CardInput> cards = DefaultSdkAutoConstructList.getInstance();

        private String initialPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(AppDefinitionInput model) {
            cards(model.cards);
            initialPrompt(model.initialPrompt);
        }

        public final List<CardInput.Builder> getCards() {
            List<CardInput.Builder> result = CardListCopier.copyToBuilder(this.cards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCards(Collection<CardInput.BuilderImpl> cards) {
            this.cards = CardListCopier.copyFromBuilder(cards);
        }

        @Override
        public final Builder cards(Collection<CardInput> cards) {
            this.cards = CardListCopier.copy(cards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cards(CardInput... cards) {
            cards(Arrays.asList(cards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cards(Consumer<CardInput.Builder>... cards) {
            cards(Stream.of(cards).map(c -> CardInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInitialPrompt() {
            return initialPrompt;
        }

        public final void setInitialPrompt(String initialPrompt) {
            this.initialPrompt = initialPrompt;
        }

        @Override
        public final Builder initialPrompt(String initialPrompt) {
            this.initialPrompt = initialPrompt;
            return this;
        }

        @Override
        public AppDefinitionInput build() {
            return new AppDefinitionInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
