/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateCategoryRequest extends QAppsRequest implements
        ToCopyableBuilder<BatchUpdateCategoryRequest.Builder, BatchUpdateCategoryRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(BatchUpdateCategoryRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()).build();

    private static final SdkField<List<CategoryInput>> CATEGORIES_FIELD = SdkField
            .<List<CategoryInput>> builder(MarshallingType.LIST)
            .memberName("categories")
            .getter(getter(BatchUpdateCategoryRequest::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CategoryInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CategoryInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final List<CategoryInput> categories;

    private BatchUpdateCategoryRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.categories = builder.categories;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application environment instance.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application environment instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of categories to be updated with their new values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return The list of categories to be updated with their new values.
     */
    public final List<CategoryInput> categories() {
        return categories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateCategoryRequest)) {
            return false;
        }
        BatchUpdateCategoryRequest other = (BatchUpdateCategoryRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && hasCategories() == other.hasCategories()
                && Objects.equals(categories(), other.categories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateCategoryRequest").add("InstanceId", instanceId())
                .add("Categories", hasCategories() ? categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "categories":
            return Optional.ofNullable(clazz.cast(categories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instance-id", INSTANCE_ID_FIELD);
        map.put("categories", CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateCategoryRequest, T> g) {
        return obj -> g.apply((BatchUpdateCategoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateCategoryRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Q Business application environment instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier of the Amazon Q Business application environment instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The list of categories to be updated with their new values.
         * </p>
         * 
         * @param categories
         *        The list of categories to be updated with their new values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<CategoryInput> categories);

        /**
         * <p>
         * The list of categories to be updated with their new values.
         * </p>
         * 
         * @param categories
         *        The list of categories to be updated with their new values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(CategoryInput... categories);

        /**
         * <p>
         * The list of categories to be updated with their new values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.CategoryInput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qapps.model.CategoryInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qapps.model.CategoryInput.Builder#build()} is called immediately and
         * its result is passed to {@link #categories(List<CategoryInput>)}.
         * 
         * @param categories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qapps.model.CategoryInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(java.util.Collection<CategoryInput>)
         */
        Builder categories(Consumer<CategoryInput.Builder>... categories);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QAppsRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<CategoryInput> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateCategoryRequest model) {
            super(model);
            instanceId(model.instanceId);
            categories(model.categories);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final List<CategoryInput.Builder> getCategories() {
            List<CategoryInput.Builder> result = CategoryListInputCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<CategoryInput.BuilderImpl> categories) {
            this.categories = CategoryListInputCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<CategoryInput> categories) {
            this.categories = CategoryListInputCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(CategoryInput... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<CategoryInput.Builder>... categories) {
            categories(Stream.of(categories).map(c -> CategoryInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateCategoryRequest build() {
            return new BatchUpdateCategoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
