/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportQAppSessionDataResponse extends QAppsResponse implements
        ToCopyableBuilder<ExportQAppSessionDataResponse.Builder, ExportQAppSessionDataResponse> {
    private static final SdkField<String> CSV_FILE_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("csvFileLink").getter(getter(ExportQAppSessionDataResponse::csvFileLink))
            .setter(setter(Builder::csvFileLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csvFileLink").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt")
            .getter(getter(ExportQAppSessionDataResponse::expiresAt))
            .setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(ExportQAppSessionDataResponse::sessionArn))
            .setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FILE_LINK_FIELD,
            EXPIRES_AT_FIELD, SESSION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String csvFileLink;

    private final Instant expiresAt;

    private final String sessionArn;

    private ExportQAppSessionDataResponse(BuilderImpl builder) {
        super(builder);
        this.csvFileLink = builder.csvFileLink;
        this.expiresAt = builder.expiresAt;
        this.sessionArn = builder.sessionArn;
    }

    /**
     * <p>
     * The link where the exported Q App session data can be downloaded from.
     * </p>
     * 
     * @return The link where the exported Q App session data can be downloaded from.
     */
    public final String csvFileLink() {
        return csvFileLink;
    }

    /**
     * <p>
     * The date and time when the link for the exported Q App session data expires.
     * </p>
     * 
     * @return The date and time when the link for the exported Q App session data expires.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Q App data collection session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Q App data collection session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(csvFileLink());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportQAppSessionDataResponse)) {
            return false;
        }
        ExportQAppSessionDataResponse other = (ExportQAppSessionDataResponse) obj;
        return Objects.equals(csvFileLink(), other.csvFileLink()) && Objects.equals(expiresAt(), other.expiresAt())
                && Objects.equals(sessionArn(), other.sessionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportQAppSessionDataResponse").add("CsvFileLink", csvFileLink()).add("ExpiresAt", expiresAt())
                .add("SessionArn", sessionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "csvFileLink":
            return Optional.ofNullable(clazz.cast(csvFileLink()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("csvFileLink", CSV_FILE_LINK_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportQAppSessionDataResponse, T> g) {
        return obj -> g.apply((ExportQAppSessionDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExportQAppSessionDataResponse> {
        /**
         * <p>
         * The link where the exported Q App session data can be downloaded from.
         * </p>
         * 
         * @param csvFileLink
         *        The link where the exported Q App session data can be downloaded from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvFileLink(String csvFileLink);

        /**
         * <p>
         * The date and time when the link for the exported Q App session data expires.
         * </p>
         * 
         * @param expiresAt
         *        The date and time when the link for the exported Q App session data expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Q App data collection session.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the Q App data collection session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private String csvFileLink;

        private Instant expiresAt;

        private String sessionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportQAppSessionDataResponse model) {
            super(model);
            csvFileLink(model.csvFileLink);
            expiresAt(model.expiresAt);
            sessionArn(model.sessionArn);
        }

        public final String getCsvFileLink() {
            return csvFileLink;
        }

        public final void setCsvFileLink(String csvFileLink) {
            this.csvFileLink = csvFileLink;
        }

        @Override
        public final Builder csvFileLink(String csvFileLink) {
            this.csvFileLink = csvFileLink;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        @Override
        public ExportQAppSessionDataResponse build() {
            return new ExportQAppSessionDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
