/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A card in an Amazon Q App that allows the user to upload a file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileUploadCard implements SdkPojo, Serializable, ToCopyableBuilder<FileUploadCard.Builder, FileUploadCard> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FileUploadCard::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(FileUploadCard::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dependencies")
            .getter(getter(FileUploadCard::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FileUploadCard::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> FILENAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filename").getter(getter(FileUploadCard::filename)).setter(setter(Builder::filename))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filename").build()).build();

    private static final SdkField<String> FILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fileId")
            .getter(getter(FileUploadCard::fileId)).setter(setter(Builder::fileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileId").build()).build();

    private static final SdkField<Boolean> ALLOW_OVERRIDE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowOverride").getter(getter(FileUploadCard::allowOverride)).setter(setter(Builder::allowOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowOverride").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD,
            DEPENDENCIES_FIELD, TYPE_FIELD, FILENAME_FIELD, FILE_ID_FIELD, ALLOW_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String title;

    private final List<String> dependencies;

    private final String type;

    private final String filename;

    private final String fileId;

    private final Boolean allowOverride;

    private FileUploadCard(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.dependencies = builder.dependencies;
        this.type = builder.type;
        this.filename = builder.filename;
        this.fileId = builder.fileId;
        this.allowOverride = builder.allowOverride;
    }

    /**
     * <p>
     * The unique identifier of the file upload card.
     * </p>
     * 
     * @return The unique identifier of the file upload card.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The title of the file upload card.
     * </p>
     * 
     * @return The title of the file upload card.
     */
    public final String title() {
        return title;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dependencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any dependencies or requirements for the file upload card.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencies} method.
     * </p>
     * 
     * @return Any dependencies or requirements for the file upload card.
     */
    public final List<String> dependencies() {
        return dependencies;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final CardType type() {
        return CardType.fromValue(type);
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the file being uploaded.
     * </p>
     * 
     * @return The name of the file being uploaded.
     */
    public final String filename() {
        return filename;
    }

    /**
     * <p>
     * The unique identifier of the file associated with the card.
     * </p>
     * 
     * @return The unique identifier of the file associated with the card.
     */
    public final String fileId() {
        return fileId;
    }

    /**
     * <p>
     * A flag indicating if the user can override the default file for the upload card.
     * </p>
     * 
     * @return A flag indicating if the user can override the default file for the upload card.
     */
    public final Boolean allowOverride() {
        return allowOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filename());
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        hashCode = 31 * hashCode + Objects.hashCode(allowOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileUploadCard)) {
            return false;
        }
        FileUploadCard other = (FileUploadCard) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(title(), other.title())
                && hasDependencies() == other.hasDependencies() && Objects.equals(dependencies(), other.dependencies())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(filename(), other.filename())
                && Objects.equals(fileId(), other.fileId()) && Objects.equals(allowOverride(), other.allowOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileUploadCard").add("Id", id()).add("Title", title())
                .add("Dependencies", hasDependencies() ? dependencies() : null).add("Type", typeAsString())
                .add("Filename", filename()).add("FileId", fileId()).add("AllowOverride", allowOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "filename":
            return Optional.ofNullable(clazz.cast(filename()));
        case "fileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        case "allowOverride":
            return Optional.ofNullable(clazz.cast(allowOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("dependencies", DEPENDENCIES_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("filename", FILENAME_FIELD);
        map.put("fileId", FILE_ID_FIELD);
        map.put("allowOverride", ALLOW_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileUploadCard, T> g) {
        return obj -> g.apply((FileUploadCard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileUploadCard> {
        /**
         * <p>
         * The unique identifier of the file upload card.
         * </p>
         * 
         * @param id
         *        The unique identifier of the file upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The title of the file upload card.
         * </p>
         * 
         * @param title
         *        The title of the file upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Any dependencies or requirements for the file upload card.
         * </p>
         * 
         * @param dependencies
         *        Any dependencies or requirements for the file upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Collection<String> dependencies);

        /**
         * <p>
         * Any dependencies or requirements for the file upload card.
         * </p>
         * 
         * @param dependencies
         *        Any dependencies or requirements for the file upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(String... dependencies);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(CardType type);

        /**
         * <p>
         * The name of the file being uploaded.
         * </p>
         * 
         * @param filename
         *        The name of the file being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filename(String filename);

        /**
         * <p>
         * The unique identifier of the file associated with the card.
         * </p>
         * 
         * @param fileId
         *        The unique identifier of the file associated with the card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(String fileId);

        /**
         * <p>
         * A flag indicating if the user can override the default file for the upload card.
         * </p>
         * 
         * @param allowOverride
         *        A flag indicating if the user can override the default file for the upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOverride(Boolean allowOverride);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String title;

        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String filename;

        private String fileId;

        private Boolean allowOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(FileUploadCard model) {
            id(model.id);
            title(model.title);
            dependencies(model.dependencies);
            type(model.type);
            filename(model.filename);
            fileId(model.fileId);
            allowOverride(model.allowOverride);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<String> getDependencies() {
            if (dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String... dependencies) {
            dependencies(Arrays.asList(dependencies));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFilename() {
            return filename;
        }

        public final void setFilename(String filename) {
            this.filename = filename;
        }

        @Override
        public final Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public final String getFileId() {
            return fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final Boolean getAllowOverride() {
            return allowOverride;
        }

        public final void setAllowOverride(Boolean allowOverride) {
            this.allowOverride = allowOverride;
        }

        @Override
        public final Builder allowOverride(Boolean allowOverride) {
            this.allowOverride = allowOverride;
            return this;
        }

        @Override
        public FileUploadCard build() {
            return new FileUploadCard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
