/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQAppResponse extends QAppsResponse implements ToCopyableBuilder<GetQAppResponse.Builder, GetQAppResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(GetQAppResponse::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(GetQAppResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(GetQAppResponse::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetQAppResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> INITIAL_PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initialPrompt").getter(getter(GetQAppResponse::initialPrompt)).setter(setter(Builder::initialPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialPrompt").build()).build();

    private static final SdkField<Integer> APP_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("appVersion").getter(getter(GetQAppResponse::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetQAppResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetQAppResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetQAppResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetQAppResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetQAppResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<List<String>> REQUIRED_CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("requiredCapabilities")
            .getter(getter(GetQAppResponse::requiredCapabilitiesAsStrings))
            .setter(setter(Builder::requiredCapabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredCapabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AppDefinition> APP_DEFINITION_FIELD = SdkField
            .<AppDefinition> builder(MarshallingType.SDK_POJO).memberName("appDefinition")
            .getter(getter(GetQAppResponse::appDefinition)).setter(setter(Builder::appDefinition))
            .constructor(AppDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, APP_ARN_FIELD,
            TITLE_FIELD, DESCRIPTION_FIELD, INITIAL_PROMPT_FIELD, APP_VERSION_FIELD, STATUS_FIELD, CREATED_AT_FIELD,
            CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, REQUIRED_CAPABILITIES_FIELD, APP_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appId;

    private final String appArn;

    private final String title;

    private final String description;

    private final String initialPrompt;

    private final Integer appVersion;

    private final String status;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final List<String> requiredCapabilities;

    private final AppDefinition appDefinition;

    private GetQAppResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.appArn = builder.appArn;
        this.title = builder.title;
        this.description = builder.description;
        this.initialPrompt = builder.initialPrompt;
        this.appVersion = builder.appVersion;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.requiredCapabilities = builder.requiredCapabilities;
        this.appDefinition = builder.appDefinition;
    }

    /**
     * <p>
     * The unique identifier of the Q App.
     * </p>
     * 
     * @return The unique identifier of the Q App.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Q App.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Q App.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The title of the Q App.
     * </p>
     * 
     * @return The title of the Q App.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description of the Q App.
     * </p>
     * 
     * @return The description of the Q App.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The initial prompt displayed when the Q App is started.
     * </p>
     * 
     * @return The initial prompt displayed when the Q App is started.
     */
    public final String initialPrompt() {
        return initialPrompt;
    }

    /**
     * <p>
     * The version of the Q App.
     * </p>
     * 
     * @return The version of the Q App.
     */
    public final Integer appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * The status of the Q App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Q App.
     * @see AppStatus
     */
    public final AppStatus status() {
        return AppStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Q App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Q App.
     * @see AppStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time the Q App was created.
     * </p>
     * 
     * @return The date and time the Q App was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the Q App.
     * </p>
     * 
     * @return The user who created the Q App.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the Q App was last updated.
     * </p>
     * 
     * @return The date and time the Q App was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user who last updated the Q App.
     * </p>
     * 
     * @return The user who last updated the Q App.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The capabilities required to run the Q App, such as file upload or third-party integrations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredCapabilities} method.
     * </p>
     * 
     * @return The capabilities required to run the Q App, such as file upload or third-party integrations.
     */
    public final List<AppRequiredCapability> requiredCapabilities() {
        return AppRequiredCapabilitiesCopier.copyStringToEnum(requiredCapabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredCapabilities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequiredCapabilities() {
        return requiredCapabilities != null && !(requiredCapabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capabilities required to run the Q App, such as file upload or third-party integrations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredCapabilities} method.
     * </p>
     * 
     * @return The capabilities required to run the Q App, such as file upload or third-party integrations.
     */
    public final List<String> requiredCapabilitiesAsStrings() {
        return requiredCapabilities;
    }

    /**
     * <p>
     * The full definition of the Q App, specifying the cards and flow.
     * </p>
     * 
     * @return The full definition of the Q App, specifying the cards and flow.
     */
    public final AppDefinition appDefinition() {
        return appDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(initialPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiredCapabilities() ? requiredCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(appDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQAppResponse)) {
            return false;
        }
        GetQAppResponse other = (GetQAppResponse) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(appArn(), other.appArn())
                && Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(initialPrompt(), other.initialPrompt()) && Objects.equals(appVersion(), other.appVersion())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy()) && hasRequiredCapabilities() == other.hasRequiredCapabilities()
                && Objects.equals(requiredCapabilitiesAsStrings(), other.requiredCapabilitiesAsStrings())
                && Objects.equals(appDefinition(), other.appDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQAppResponse").add("AppId", appId()).add("AppArn", appArn()).add("Title", title())
                .add("Description", description()).add("InitialPrompt", initialPrompt()).add("AppVersion", appVersion())
                .add("Status", statusAsString()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy())
                .add("RequiredCapabilities", hasRequiredCapabilities() ? requiredCapabilitiesAsStrings() : null)
                .add("AppDefinition", appDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "initialPrompt":
            return Optional.ofNullable(clazz.cast(initialPrompt()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "requiredCapabilities":
            return Optional.ofNullable(clazz.cast(requiredCapabilitiesAsStrings()));
        case "appDefinition":
            return Optional.ofNullable(clazz.cast(appDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("appArn", APP_ARN_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("initialPrompt", INITIAL_PROMPT_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("requiredCapabilities", REQUIRED_CAPABILITIES_FIELD);
        map.put("appDefinition", APP_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQAppResponse, T> g) {
        return obj -> g.apply((GetQAppResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQAppResponse> {
        /**
         * <p>
         * The unique identifier of the Q App.
         * </p>
         * 
         * @param appId
         *        The unique identifier of the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Q App.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The title of the Q App.
         * </p>
         * 
         * @param title
         *        The title of the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the Q App.
         * </p>
         * 
         * @param description
         *        The description of the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The initial prompt displayed when the Q App is started.
         * </p>
         * 
         * @param initialPrompt
         *        The initial prompt displayed when the Q App is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialPrompt(String initialPrompt);

        /**
         * <p>
         * The version of the Q App.
         * </p>
         * 
         * @param appVersion
         *        The version of the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(Integer appVersion);

        /**
         * <p>
         * The status of the Q App.
         * </p>
         * 
         * @param status
         *        The status of the Q App.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Q App.
         * </p>
         * 
         * @param status
         *        The status of the Q App.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(AppStatus status);

        /**
         * <p>
         * The date and time the Q App was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the Q App was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the Q App.
         * </p>
         * 
         * @param createdBy
         *        The user who created the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the Q App was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the Q App was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user who last updated the Q App.
         * </p>
         * 
         * @param updatedBy
         *        The user who last updated the Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The capabilities required to run the Q App, such as file upload or third-party integrations.
         * </p>
         * 
         * @param requiredCapabilities
         *        The capabilities required to run the Q App, such as file upload or third-party integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredCapabilitiesWithStrings(Collection<String> requiredCapabilities);

        /**
         * <p>
         * The capabilities required to run the Q App, such as file upload or third-party integrations.
         * </p>
         * 
         * @param requiredCapabilities
         *        The capabilities required to run the Q App, such as file upload or third-party integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredCapabilitiesWithStrings(String... requiredCapabilities);

        /**
         * <p>
         * The capabilities required to run the Q App, such as file upload or third-party integrations.
         * </p>
         * 
         * @param requiredCapabilities
         *        The capabilities required to run the Q App, such as file upload or third-party integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredCapabilities(Collection<AppRequiredCapability> requiredCapabilities);

        /**
         * <p>
         * The capabilities required to run the Q App, such as file upload or third-party integrations.
         * </p>
         * 
         * @param requiredCapabilities
         *        The capabilities required to run the Q App, such as file upload or third-party integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredCapabilities(AppRequiredCapability... requiredCapabilities);

        /**
         * <p>
         * The full definition of the Q App, specifying the cards and flow.
         * </p>
         * 
         * @param appDefinition
         *        The full definition of the Q App, specifying the cards and flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appDefinition(AppDefinition appDefinition);

        /**
         * <p>
         * The full definition of the Q App, specifying the cards and flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppDefinition.Builder} avoiding the need
         * to create one manually via {@link AppDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #appDefinition(AppDefinition)}.
         * 
         * @param appDefinition
         *        a consumer that will call methods on {@link AppDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appDefinition(AppDefinition)
         */
        default Builder appDefinition(Consumer<AppDefinition.Builder> appDefinition) {
            return appDefinition(AppDefinition.builder().applyMutation(appDefinition).build());
        }
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private String appId;

        private String appArn;

        private String title;

        private String description;

        private String initialPrompt;

        private Integer appVersion;

        private String status;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private List<String> requiredCapabilities = DefaultSdkAutoConstructList.getInstance();

        private AppDefinition appDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQAppResponse model) {
            super(model);
            appId(model.appId);
            appArn(model.appArn);
            title(model.title);
            description(model.description);
            initialPrompt(model.initialPrompt);
            appVersion(model.appVersion);
            status(model.status);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            requiredCapabilitiesWithStrings(model.requiredCapabilities);
            appDefinition(model.appDefinition);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInitialPrompt() {
            return initialPrompt;
        }

        public final void setInitialPrompt(String initialPrompt) {
            this.initialPrompt = initialPrompt;
        }

        @Override
        public final Builder initialPrompt(String initialPrompt) {
            this.initialPrompt = initialPrompt;
            return this;
        }

        public final Integer getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(Integer appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(Integer appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Collection<String> getRequiredCapabilities() {
            if (requiredCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return requiredCapabilities;
        }

        public final void setRequiredCapabilities(Collection<String> requiredCapabilities) {
            this.requiredCapabilities = AppRequiredCapabilitiesCopier.copy(requiredCapabilities);
        }

        @Override
        public final Builder requiredCapabilitiesWithStrings(Collection<String> requiredCapabilities) {
            this.requiredCapabilities = AppRequiredCapabilitiesCopier.copy(requiredCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredCapabilitiesWithStrings(String... requiredCapabilities) {
            requiredCapabilitiesWithStrings(Arrays.asList(requiredCapabilities));
            return this;
        }

        @Override
        public final Builder requiredCapabilities(Collection<AppRequiredCapability> requiredCapabilities) {
            this.requiredCapabilities = AppRequiredCapabilitiesCopier.copyEnumToString(requiredCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredCapabilities(AppRequiredCapability... requiredCapabilities) {
            requiredCapabilities(Arrays.asList(requiredCapabilities));
            return this;
        }

        public final AppDefinition.Builder getAppDefinition() {
            return appDefinition != null ? appDefinition.toBuilder() : null;
        }

        public final void setAppDefinition(AppDefinition.BuilderImpl appDefinition) {
            this.appDefinition = appDefinition != null ? appDefinition.build() : null;
        }

        @Override
        public final Builder appDefinition(AppDefinition appDefinition) {
            this.appDefinition = appDefinition;
            return this;
        }

        @Override
        public GetQAppResponse build() {
            return new GetQAppResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
