/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQAppSessionResponse extends QAppsResponse implements
        ToCopyableBuilder<GetQAppSessionResponse.Builder, GetQAppSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(GetQAppSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(GetQAppSessionResponse::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionName").getter(getter(GetQAppSessionResponse::sessionName)).setter(setter(Builder::sessionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionName").build()).build();

    private static final SdkField<Integer> APP_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("appVersion").getter(getter(GetQAppSessionResponse::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<Integer> LATEST_PUBLISHED_APP_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("latestPublishedAppVersion")
            .getter(getter(GetQAppSessionResponse::latestPublishedAppVersion)).setter(setter(Builder::latestPublishedAppVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestPublishedAppVersion").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetQAppSessionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, CardStatus>> CARD_STATUS_FIELD = SdkField
            .<Map<String, CardStatus>> builder(MarshallingType.MAP)
            .memberName("cardStatus")
            .getter(getter(GetQAppSessionResponse::cardStatus))
            .setter(setter(Builder::cardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardStatus").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CardStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(CardStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> USER_IS_HOST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("userIsHost").getter(getter(GetQAppSessionResponse::userIsHost)).setter(setter(Builder::userIsHost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIsHost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            SESSION_ARN_FIELD, SESSION_NAME_FIELD, APP_VERSION_FIELD, LATEST_PUBLISHED_APP_VERSION_FIELD, STATUS_FIELD,
            CARD_STATUS_FIELD, USER_IS_HOST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String sessionArn;

    private final String sessionName;

    private final Integer appVersion;

    private final Integer latestPublishedAppVersion;

    private final String status;

    private final Map<String, CardStatus> cardStatus;

    private final Boolean userIsHost;

    private GetQAppSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.sessionArn = builder.sessionArn;
        this.sessionName = builder.sessionName;
        this.appVersion = builder.appVersion;
        this.latestPublishedAppVersion = builder.latestPublishedAppVersion;
        this.status = builder.status;
        this.cardStatus = builder.cardStatus;
        this.userIsHost = builder.userIsHost;
    }

    /**
     * <p>
     * The unique identifier of the Q App session.
     * </p>
     * 
     * @return The unique identifier of the Q App session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Q App session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Q App session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * The name of the Q App session.
     * </p>
     * 
     * @return The name of the Q App session.
     */
    public final String sessionName() {
        return sessionName;
    }

    /**
     * <p>
     * The version of the Q App used for the session.
     * </p>
     * 
     * @return The version of the Q App used for the session.
     */
    public final Integer appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * The latest published version of the Q App used for the session.
     * </p>
     * 
     * @return The latest published version of the Q App used for the session.
     */
    public final Integer latestPublishedAppVersion() {
        return latestPublishedAppVersion;
    }

    /**
     * <p>
     * The current status of the Q App session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Q App session.
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Q App session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Q App session.
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the CardStatus property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCardStatus() {
        return cardStatus != null && !(cardStatus instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The current status for each card in the Q App session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCardStatus} method.
     * </p>
     * 
     * @return The current status for each card in the Q App session.
     */
    public final Map<String, CardStatus> cardStatus() {
        return cardStatus;
    }

    /**
     * <p>
     * Indicates whether the current user is the owner of the Q App data collection session.
     * </p>
     * 
     * @return Indicates whether the current user is the owner of the Q App data collection session.
     */
    public final Boolean userIsHost() {
        return userIsHost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestPublishedAppVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCardStatus() ? cardStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userIsHost());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQAppSessionResponse)) {
            return false;
        }
        GetQAppSessionResponse other = (GetQAppSessionResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(sessionArn(), other.sessionArn())
                && Objects.equals(sessionName(), other.sessionName()) && Objects.equals(appVersion(), other.appVersion())
                && Objects.equals(latestPublishedAppVersion(), other.latestPublishedAppVersion())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasCardStatus() == other.hasCardStatus()
                && Objects.equals(cardStatus(), other.cardStatus()) && Objects.equals(userIsHost(), other.userIsHost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQAppSessionResponse").add("SessionId", sessionId()).add("SessionArn", sessionArn())
                .add("SessionName", sessionName()).add("AppVersion", appVersion())
                .add("LatestPublishedAppVersion", latestPublishedAppVersion()).add("Status", statusAsString())
                .add("CardStatus", hasCardStatus() ? cardStatus() : null).add("UserIsHost", userIsHost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "sessionName":
            return Optional.ofNullable(clazz.cast(sessionName()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "latestPublishedAppVersion":
            return Optional.ofNullable(clazz.cast(latestPublishedAppVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "cardStatus":
            return Optional.ofNullable(clazz.cast(cardStatus()));
        case "userIsHost":
            return Optional.ofNullable(clazz.cast(userIsHost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionName", SESSION_NAME_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("latestPublishedAppVersion", LATEST_PUBLISHED_APP_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("cardStatus", CARD_STATUS_FIELD);
        map.put("userIsHost", USER_IS_HOST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQAppSessionResponse, T> g) {
        return obj -> g.apply((GetQAppSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQAppSessionResponse> {
        /**
         * <p>
         * The unique identifier of the Q App session.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Q App session.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * The name of the Q App session.
         * </p>
         * 
         * @param sessionName
         *        The name of the Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionName(String sessionName);

        /**
         * <p>
         * The version of the Q App used for the session.
         * </p>
         * 
         * @param appVersion
         *        The version of the Q App used for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(Integer appVersion);

        /**
         * <p>
         * The latest published version of the Q App used for the session.
         * </p>
         * 
         * @param latestPublishedAppVersion
         *        The latest published version of the Q App used for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestPublishedAppVersion(Integer latestPublishedAppVersion);

        /**
         * <p>
         * The current status of the Q App session.
         * </p>
         * 
         * @param status
         *        The current status of the Q App session.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Q App session.
         * </p>
         * 
         * @param status
         *        The current status of the Q App session.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The current status for each card in the Q App session.
         * </p>
         * 
         * @param cardStatus
         *        The current status for each card in the Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardStatus(Map<String, CardStatus> cardStatus);

        /**
         * <p>
         * Indicates whether the current user is the owner of the Q App data collection session.
         * </p>
         * 
         * @param userIsHost
         *        Indicates whether the current user is the owner of the Q App data collection session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIsHost(Boolean userIsHost);
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String sessionArn;

        private String sessionName;

        private Integer appVersion;

        private Integer latestPublishedAppVersion;

        private String status;

        private Map<String, CardStatus> cardStatus = DefaultSdkAutoConstructMap.getInstance();

        private Boolean userIsHost;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQAppSessionResponse model) {
            super(model);
            sessionId(model.sessionId);
            sessionArn(model.sessionArn);
            sessionName(model.sessionName);
            appVersion(model.appVersion);
            latestPublishedAppVersion(model.latestPublishedAppVersion);
            status(model.status);
            cardStatus(model.cardStatus);
            userIsHost(model.userIsHost);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionName() {
            return sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final Integer getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(Integer appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(Integer appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final Integer getLatestPublishedAppVersion() {
            return latestPublishedAppVersion;
        }

        public final void setLatestPublishedAppVersion(Integer latestPublishedAppVersion) {
            this.latestPublishedAppVersion = latestPublishedAppVersion;
        }

        @Override
        public final Builder latestPublishedAppVersion(Integer latestPublishedAppVersion) {
            this.latestPublishedAppVersion = latestPublishedAppVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, CardStatus.Builder> getCardStatus() {
            Map<String, CardStatus.Builder> result = CardStatusMapCopier.copyToBuilder(this.cardStatus);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCardStatus(Map<String, CardStatus.BuilderImpl> cardStatus) {
            this.cardStatus = CardStatusMapCopier.copyFromBuilder(cardStatus);
        }

        @Override
        public final Builder cardStatus(Map<String, CardStatus> cardStatus) {
            this.cardStatus = CardStatusMapCopier.copy(cardStatus);
            return this;
        }

        public final Boolean getUserIsHost() {
            return userIsHost;
        }

        public final void setUserIsHost(Boolean userIsHost) {
            this.userIsHost = userIsHost;
        }

        @Override
        public final Builder userIsHost(Boolean userIsHost) {
            this.userIsHost = userIsHost;
            return this;
        }

        @Override
        public GetQAppSessionResponse build() {
            return new GetQAppSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
