/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLibraryItemsRequest extends QAppsRequest implements
        ToCopyableBuilder<ListLibraryItemsRequest.Builder, ListLibraryItemsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(ListLibraryItemsRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(ListLibraryItemsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLibraryItemsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> CATEGORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("categoryId").getter(getter(ListLibraryItemsRequest::categoryId)).setter(setter(Builder::categoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("categoryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            LIMIT_FIELD, NEXT_TOKEN_FIELD, CATEGORY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final Integer limit;

    private final String nextToken;

    private final String categoryId;

    private ListLibraryItemsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.categoryId = builder.categoryId;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application environment instance.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application environment instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The maximum number of library items to return in the response.
     * </p>
     * 
     * @return The maximum number of library items to return in the response.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Optional category to filter the library items by.
     * </p>
     * 
     * @return Optional category to filter the library items by.
     */
    public final String categoryId() {
        return categoryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(categoryId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLibraryItemsRequest)) {
            return false;
        }
        ListLibraryItemsRequest other = (ListLibraryItemsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(categoryId(), other.categoryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLibraryItemsRequest").add("InstanceId", instanceId()).add("Limit", limit())
                .add("NextToken", nextToken()).add("CategoryId", categoryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "categoryId":
            return Optional.ofNullable(clazz.cast(categoryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instance-id", INSTANCE_ID_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("categoryId", CATEGORY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLibraryItemsRequest, T> g) {
        return obj -> g.apply((ListLibraryItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLibraryItemsRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Q Business application environment instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier of the Amazon Q Business application environment instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The maximum number of library items to return in the response.
         * </p>
         * 
         * @param limit
         *        The maximum number of library items to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Optional category to filter the library items by.
         * </p>
         * 
         * @param categoryId
         *        Optional category to filter the library items by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryId(String categoryId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QAppsRequest.BuilderImpl implements Builder {
        private String instanceId;

        private Integer limit;

        private String nextToken;

        private String categoryId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLibraryItemsRequest model) {
            super(model);
            instanceId(model.instanceId);
            limit(model.limit);
            nextToken(model.nextToken);
            categoryId(model.categoryId);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getCategoryId() {
            return categoryId;
        }

        public final void setCategoryId(String categoryId) {
            this.categoryId = categoryId;
        }

        @Override
        public final Builder categoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLibraryItemsRequest build() {
            return new ListLibraryItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
