/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQAppSessionDataResponse extends QAppsResponse implements
        ToCopyableBuilder<ListQAppSessionDataResponse.Builder, ListQAppSessionDataResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(ListQAppSessionDataResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(ListQAppSessionDataResponse::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final SdkField<List<QAppSessionData>> SESSION_DATA_FIELD = SdkField
            .<List<QAppSessionData>> builder(MarshallingType.LIST)
            .memberName("sessionData")
            .getter(getter(ListQAppSessionDataResponse::sessionData))
            .setter(setter(Builder::sessionData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QAppSessionData> builder(MarshallingType.SDK_POJO)
                                            .constructor(QAppSessionData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListQAppSessionDataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            SESSION_ARN_FIELD, SESSION_DATA_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String sessionArn;

    private final List<QAppSessionData> sessionData;

    private final String nextToken;

    private ListQAppSessionDataResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.sessionArn = builder.sessionArn;
        this.sessionData = builder.sessionData;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the Q App data collection session.
     * </p>
     * 
     * @return The unique identifier of the Q App data collection session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Q App data collection session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Q App data collection session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionData property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionData() {
        return sessionData != null && !(sessionData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The collected responses of a Q App session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionData} method.
     * </p>
     * 
     * @return The collected responses of a Q App session.
     */
    public final List<QAppSessionData> sessionData() {
        return sessionData;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionData() ? sessionData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQAppSessionDataResponse)) {
            return false;
        }
        ListQAppSessionDataResponse other = (ListQAppSessionDataResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(sessionArn(), other.sessionArn())
                && hasSessionData() == other.hasSessionData() && Objects.equals(sessionData(), other.sessionData())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQAppSessionDataResponse").add("SessionId", sessionId()).add("SessionArn", sessionArn())
                .add("SessionData", hasSessionData() ? sessionData() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "sessionData":
            return Optional.ofNullable(clazz.cast(sessionData()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionData", SESSION_DATA_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQAppSessionDataResponse, T> g) {
        return obj -> g.apply((ListQAppSessionDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQAppSessionDataResponse> {
        /**
         * <p>
         * The unique identifier of the Q App data collection session.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the Q App data collection session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Q App data collection session.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the Q App data collection session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * The collected responses of a Q App session.
         * </p>
         * 
         * @param sessionData
         *        The collected responses of a Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionData(Collection<QAppSessionData> sessionData);

        /**
         * <p>
         * The collected responses of a Q App session.
         * </p>
         * 
         * @param sessionData
         *        The collected responses of a Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionData(QAppSessionData... sessionData);

        /**
         * <p>
         * The collected responses of a Q App session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.QAppSessionData.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qapps.model.QAppSessionData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qapps.model.QAppSessionData.Builder#build()} is called immediately and
         * its result is passed to {@link #sessionData(List<QAppSessionData>)}.
         * 
         * @param sessionData
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qapps.model.QAppSessionData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionData(java.util.Collection<QAppSessionData>)
         */
        Builder sessionData(Consumer<QAppSessionData.Builder>... sessionData);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String sessionArn;

        private List<QAppSessionData> sessionData = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQAppSessionDataResponse model) {
            super(model);
            sessionId(model.sessionId);
            sessionArn(model.sessionArn);
            sessionData(model.sessionData);
            nextToken(model.nextToken);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final List<QAppSessionData.Builder> getSessionData() {
            List<QAppSessionData.Builder> result = QAppSessionDataListCopier.copyToBuilder(this.sessionData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionData(Collection<QAppSessionData.BuilderImpl> sessionData) {
            this.sessionData = QAppSessionDataListCopier.copyFromBuilder(sessionData);
        }

        @Override
        public final Builder sessionData(Collection<QAppSessionData> sessionData) {
            this.sessionData = QAppSessionDataListCopier.copy(sessionData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionData(QAppSessionData... sessionData) {
            sessionData(Arrays.asList(sessionData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionData(Consumer<QAppSessionData.Builder>... sessionData) {
            sessionData(Stream.of(sessionData).map(c -> QAppSessionData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQAppSessionDataResponse build() {
            return new ListQAppSessionDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
