/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The permission granted to the Amazon Q App.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<PermissionOutput.Builder, PermissionOutput> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(PermissionOutput::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<PrincipalOutput> PRINCIPAL_FIELD = SdkField.<PrincipalOutput> builder(MarshallingType.SDK_POJO)
            .memberName("principal").getter(getter(PermissionOutput::principal)).setter(setter(Builder::principal))
            .constructor(PrincipalOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACTION_FIELD, PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final PrincipalOutput principal;

    private PermissionOutput(BuilderImpl builder) {
        this.action = builder.action;
        this.principal = builder.principal;
    }

    /**
     * <p>
     * The action associated with the permission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link PermissionOutputActionEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action associated with the permission.
     * @see PermissionOutputActionEnum
     */
    public final PermissionOutputActionEnum action() {
        return PermissionOutputActionEnum.fromValue(action);
    }

    /**
     * <p>
     * The action associated with the permission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link PermissionOutputActionEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action associated with the permission.
     * @see PermissionOutputActionEnum
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The principal user to which the permission applies.
     * </p>
     * 
     * @return The principal user to which the permission applies.
     */
    public final PrincipalOutput principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionOutput)) {
            return false;
        }
        PermissionOutput other = (PermissionOutput) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(principal(), other.principal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionOutput").add("Action", actionAsString()).add("Principal", principal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PermissionOutput, T> g) {
        return obj -> g.apply((PermissionOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionOutput> {
        /**
         * <p>
         * The action associated with the permission.
         * </p>
         * 
         * @param action
         *        The action associated with the permission.
         * @see PermissionOutputActionEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionOutputActionEnum
         */
        Builder action(String action);

        /**
         * <p>
         * The action associated with the permission.
         * </p>
         * 
         * @param action
         *        The action associated with the permission.
         * @see PermissionOutputActionEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionOutputActionEnum
         */
        Builder action(PermissionOutputActionEnum action);

        /**
         * <p>
         * The principal user to which the permission applies.
         * </p>
         * 
         * @param principal
         *        The principal user to which the permission applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(PrincipalOutput principal);

        /**
         * <p>
         * The principal user to which the permission applies.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrincipalOutput.Builder} avoiding the
         * need to create one manually via {@link PrincipalOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrincipalOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(PrincipalOutput)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link PrincipalOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(PrincipalOutput)
         */
        default Builder principal(Consumer<PrincipalOutput.Builder> principal) {
            return principal(PrincipalOutput.builder().applyMutation(principal).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private PrincipalOutput principal;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionOutput model) {
            action(model.action);
            principal(model.principal);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(PermissionOutputActionEnum action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final PrincipalOutput.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(PrincipalOutput.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(PrincipalOutput principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public PermissionOutput build() {
            return new PermissionOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
