/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of an Amazon Q App generated based on input such as a conversation or problem statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictAppDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictAppDefinition.Builder, PredictAppDefinition> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(PredictAppDefinition::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PredictAppDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<AppDefinitionInput> APP_DEFINITION_FIELD = SdkField
            .<AppDefinitionInput> builder(MarshallingType.SDK_POJO).memberName("appDefinition")
            .getter(getter(PredictAppDefinition::appDefinition)).setter(setter(Builder::appDefinition))
            .constructor(AppDefinitionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            DESCRIPTION_FIELD, APP_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String description;

    private final AppDefinitionInput appDefinition;

    private PredictAppDefinition(BuilderImpl builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.appDefinition = builder.appDefinition;
    }

    /**
     * <p>
     * The title of the generated Q App definition.
     * </p>
     * 
     * @return The title of the generated Q App definition.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description of the generated Q App definition.
     * </p>
     * 
     * @return The description of the generated Q App definition.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The definition specifying the cards and flow of the generated Q App.
     * </p>
     * 
     * @return The definition specifying the cards and flow of the generated Q App.
     */
    public final AppDefinitionInput appDefinition() {
        return appDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(appDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictAppDefinition)) {
            return false;
        }
        PredictAppDefinition other = (PredictAppDefinition) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(appDefinition(), other.appDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictAppDefinition").add("Title", title()).add("Description", description())
                .add("AppDefinition", appDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "appDefinition":
            return Optional.ofNullable(clazz.cast(appDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("appDefinition", APP_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictAppDefinition, T> g) {
        return obj -> g.apply((PredictAppDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictAppDefinition> {
        /**
         * <p>
         * The title of the generated Q App definition.
         * </p>
         * 
         * @param title
         *        The title of the generated Q App definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the generated Q App definition.
         * </p>
         * 
         * @param description
         *        The description of the generated Q App definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The definition specifying the cards and flow of the generated Q App.
         * </p>
         * 
         * @param appDefinition
         *        The definition specifying the cards and flow of the generated Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appDefinition(AppDefinitionInput appDefinition);

        /**
         * <p>
         * The definition specifying the cards and flow of the generated Q App.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppDefinitionInput.Builder} avoiding the
         * need to create one manually via {@link AppDefinitionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppDefinitionInput.Builder#build()} is called immediately and its
         * result is passed to {@link #appDefinition(AppDefinitionInput)}.
         * 
         * @param appDefinition
         *        a consumer that will call methods on {@link AppDefinitionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appDefinition(AppDefinitionInput)
         */
        default Builder appDefinition(Consumer<AppDefinitionInput.Builder> appDefinition) {
            return appDefinition(AppDefinitionInput.builder().applyMutation(appDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String description;

        private AppDefinitionInput appDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictAppDefinition model) {
            title(model.title);
            description(model.description);
            appDefinition(model.appDefinition);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AppDefinitionInput.Builder getAppDefinition() {
            return appDefinition != null ? appDefinition.toBuilder() : null;
        }

        public final void setAppDefinition(AppDefinitionInput.BuilderImpl appDefinition) {
            this.appDefinition = appDefinition != null ? appDefinition.build() : null;
        }

        @Override
        public final Builder appDefinition(AppDefinitionInput appDefinition) {
            this.appDefinition = appDefinition;
            return this;
        }

        @Override
        public PredictAppDefinition build() {
            return new PredictAppDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
