/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictQAppResponse extends QAppsResponse implements
        ToCopyableBuilder<PredictQAppResponse.Builder, PredictQAppResponse> {
    private static final SdkField<PredictAppDefinition> APP_FIELD = SdkField
            .<PredictAppDefinition> builder(MarshallingType.SDK_POJO).memberName("app").getter(getter(PredictQAppResponse::app))
            .setter(setter(Builder::app)).constructor(PredictAppDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()).build();

    private static final SdkField<String> PROBLEM_STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("problemStatement").getter(getter(PredictQAppResponse::problemStatement))
            .setter(setter(Builder::problemStatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("problemStatement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_FIELD,
            PROBLEM_STATEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PredictAppDefinition app;

    private final String problemStatement;

    private PredictQAppResponse(BuilderImpl builder) {
        super(builder);
        this.app = builder.app;
        this.problemStatement = builder.problemStatement;
    }

    /**
     * <p>
     * The generated Q App definition.
     * </p>
     * 
     * @return The generated Q App definition.
     */
    public final PredictAppDefinition app() {
        return app;
    }

    /**
     * <p>
     * The problem statement extracted from the input conversation, if provided.
     * </p>
     * 
     * @return The problem statement extracted from the input conversation, if provided.
     */
    public final String problemStatement() {
        return problemStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(app());
        hashCode = 31 * hashCode + Objects.hashCode(problemStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictQAppResponse)) {
            return false;
        }
        PredictQAppResponse other = (PredictQAppResponse) obj;
        return Objects.equals(app(), other.app()) && Objects.equals(problemStatement(), other.problemStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictQAppResponse").add("App", app()).add("ProblemStatement", problemStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "app":
            return Optional.ofNullable(clazz.cast(app()));
        case "problemStatement":
            return Optional.ofNullable(clazz.cast(problemStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("app", APP_FIELD);
        map.put("problemStatement", PROBLEM_STATEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictQAppResponse, T> g) {
        return obj -> g.apply((PredictQAppResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PredictQAppResponse> {
        /**
         * <p>
         * The generated Q App definition.
         * </p>
         * 
         * @param app
         *        The generated Q App definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder app(PredictAppDefinition app);

        /**
         * <p>
         * The generated Q App definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictAppDefinition.Builder} avoiding
         * the need to create one manually via {@link PredictAppDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictAppDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #app(PredictAppDefinition)}.
         * 
         * @param app
         *        a consumer that will call methods on {@link PredictAppDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #app(PredictAppDefinition)
         */
        default Builder app(Consumer<PredictAppDefinition.Builder> app) {
            return app(PredictAppDefinition.builder().applyMutation(app).build());
        }

        /**
         * <p>
         * The problem statement extracted from the input conversation, if provided.
         * </p>
         * 
         * @param problemStatement
         *        The problem statement extracted from the input conversation, if provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problemStatement(String problemStatement);
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private PredictAppDefinition app;

        private String problemStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictQAppResponse model) {
            super(model);
            app(model.app);
            problemStatement(model.problemStatement);
        }

        public final PredictAppDefinition.Builder getApp() {
            return app != null ? app.toBuilder() : null;
        }

        public final void setApp(PredictAppDefinition.BuilderImpl app) {
            this.app = app != null ? app.build() : null;
        }

        @Override
        public final Builder app(PredictAppDefinition app) {
            this.app = app;
            return this;
        }

        public final String getProblemStatement() {
            return problemStatement;
        }

        public final void setProblemStatement(String problemStatement) {
            this.problemStatement = problemStatement;
        }

        @Override
        public final Builder problemStatement(String problemStatement) {
            this.problemStatement = problemStatement;
            return this;
        }

        @Override
        public PredictQAppResponse build() {
            return new PredictQAppResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
