/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The principal for which the permission applies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrincipalOutput implements SdkPojo, Serializable, ToCopyableBuilder<PrincipalOutput.Builder, PrincipalOutput> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(PrincipalOutput::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> USER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userType").getter(getter(PrincipalOutput::userTypeAsString)).setter(setter(Builder::userType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userType").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(PrincipalOutput::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            USER_TYPE_FIELD, EMAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userId;

    private final String userType;

    private final String email;

    private PrincipalOutput(BuilderImpl builder) {
        this.userId = builder.userId;
        this.userType = builder.userType;
        this.email = builder.email;
    }

    /**
     * <p>
     * The unique identifier of the user.
     * </p>
     * 
     * @return The unique identifier of the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The type of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link PrincipalOutputUserTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #userTypeAsString}.
     * </p>
     * 
     * @return The type of the user.
     * @see PrincipalOutputUserTypeEnum
     */
    public final PrincipalOutputUserTypeEnum userType() {
        return PrincipalOutputUserTypeEnum.fromValue(userType);
    }

    /**
     * <p>
     * The type of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link PrincipalOutputUserTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #userTypeAsString}.
     * </p>
     * 
     * @return The type of the user.
     * @see PrincipalOutputUserTypeEnum
     */
    public final String userTypeAsString() {
        return userType;
    }

    /**
     * <p>
     * The email address associated with the user.
     * </p>
     * 
     * @return The email address associated with the user.
     */
    public final String email() {
        return email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalOutput)) {
            return false;
        }
        PrincipalOutput other = (PrincipalOutput) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(userTypeAsString(), other.userTypeAsString())
                && Objects.equals(email(), other.email());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrincipalOutput").add("UserId", userId()).add("UserType", userTypeAsString())
                .add("Email", email()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "userType":
            return Optional.ofNullable(clazz.cast(userTypeAsString()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userId", USER_ID_FIELD);
        map.put("userType", USER_TYPE_FIELD);
        map.put("email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrincipalOutput, T> g) {
        return obj -> g.apply((PrincipalOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrincipalOutput> {
        /**
         * <p>
         * The unique identifier of the user.
         * </p>
         * 
         * @param userId
         *        The unique identifier of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The type of the user.
         * </p>
         * 
         * @param userType
         *        The type of the user.
         * @see PrincipalOutputUserTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalOutputUserTypeEnum
         */
        Builder userType(String userType);

        /**
         * <p>
         * The type of the user.
         * </p>
         * 
         * @param userType
         *        The type of the user.
         * @see PrincipalOutputUserTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalOutputUserTypeEnum
         */
        Builder userType(PrincipalOutputUserTypeEnum userType);

        /**
         * <p>
         * The email address associated with the user.
         * </p>
         * 
         * @param email
         *        The email address associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);
    }

    static final class BuilderImpl implements Builder {
        private String userId;

        private String userType;

        private String email;

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalOutput model) {
            userId(model.userId);
            userType(model.userType);
            email(model.email);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserType() {
            return userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(PrincipalOutputUserTypeEnum userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        @Override
        public PrincipalOutput build() {
            return new PrincipalOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
