/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input shape for defining a text input card in an Amazon Q App.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextInputCardInput implements SdkPojo, Serializable,
        ToCopyableBuilder<TextInputCardInput.Builder, TextInputCardInput> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(TextInputCardInput::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(TextInputCardInput::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(TextInputCardInput::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> PLACEHOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("placeholder").getter(getter(TextInputCardInput::placeholder)).setter(setter(Builder::placeholder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placeholder").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(TextInputCardInput::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ID_FIELD,
            TYPE_FIELD, PLACEHOLDER_FIELD, DEFAULT_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String id;

    private final String type;

    private final String placeholder;

    private final String defaultValue;

    private TextInputCardInput(BuilderImpl builder) {
        this.title = builder.title;
        this.id = builder.id;
        this.type = builder.type;
        this.placeholder = builder.placeholder;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The title or label of the text input card.
     * </p>
     * 
     * @return The title or label of the text input card.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The unique identifier of the text input card.
     * </p>
     * 
     * @return The unique identifier of the text input card.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final CardType type() {
        return CardType.fromValue(type);
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The placeholder text to display in the text input field.
     * </p>
     * 
     * @return The placeholder text to display in the text input field.
     */
    public final String placeholder() {
        return placeholder;
    }

    /**
     * <p>
     * The default value to pre-populate in the text input field.
     * </p>
     * 
     * @return The default value to pre-populate in the text input field.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(placeholder());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextInputCardInput)) {
            return false;
        }
        TextInputCardInput other = (TextInputCardInput) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(id(), other.id())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(placeholder(), other.placeholder())
                && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextInputCardInput").add("Title", title()).add("Id", id()).add("Type", typeAsString())
                .add("Placeholder", placeholder()).add("DefaultValue", defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "placeholder":
            return Optional.ofNullable(clazz.cast(placeholder()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("id", ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("placeholder", PLACEHOLDER_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextInputCardInput, T> g) {
        return obj -> g.apply((TextInputCardInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextInputCardInput> {
        /**
         * <p>
         * The title or label of the text input card.
         * </p>
         * 
         * @param title
         *        The title or label of the text input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The unique identifier of the text input card.
         * </p>
         * 
         * @param id
         *        The unique identifier of the text input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(CardType type);

        /**
         * <p>
         * The placeholder text to display in the text input field.
         * </p>
         * 
         * @param placeholder
         *        The placeholder text to display in the text input field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeholder(String placeholder);

        /**
         * <p>
         * The default value to pre-populate in the text input field.
         * </p>
         * 
         * @param defaultValue
         *        The default value to pre-populate in the text input field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String id;

        private String type;

        private String placeholder;

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TextInputCardInput model) {
            title(model.title);
            id(model.id);
            type(model.type);
            placeholder(model.placeholder);
            defaultValue(model.defaultValue);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPlaceholder() {
            return placeholder;
        }

        public final void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }

        @Override
        public final Builder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public TextInputCardInput build() {
            return new TextInputCardInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
