/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLibraryItemMetadataRequest extends QAppsRequest implements
        ToCopyableBuilder<UpdateLibraryItemMetadataRequest.Builder, UpdateLibraryItemMetadataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(UpdateLibraryItemMetadataRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()).build();

    private static final SdkField<String> LIBRARY_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("libraryItemId").getter(getter(UpdateLibraryItemMetadataRequest::libraryItemId))
            .setter(setter(Builder::libraryItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryItemId").build()).build();

    private static final SdkField<Boolean> IS_VERIFIED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isVerified").getter(getter(UpdateLibraryItemMetadataRequest::isVerified))
            .setter(setter(Builder::isVerified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isVerified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            LIBRARY_ITEM_ID_FIELD, IS_VERIFIED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String libraryItemId;

    private final Boolean isVerified;

    private UpdateLibraryItemMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.libraryItemId = builder.libraryItemId;
        this.isVerified = builder.isVerified;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application environment instance.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application environment instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier of the updated library item.
     * </p>
     * 
     * @return The unique identifier of the updated library item.
     */
    public final String libraryItemId() {
        return libraryItemId;
    }

    /**
     * <p>
     * The verification status of the library item
     * </p>
     * 
     * @return The verification status of the library item
     */
    public final Boolean isVerified() {
        return isVerified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(libraryItemId());
        hashCode = 31 * hashCode + Objects.hashCode(isVerified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLibraryItemMetadataRequest)) {
            return false;
        }
        UpdateLibraryItemMetadataRequest other = (UpdateLibraryItemMetadataRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(libraryItemId(), other.libraryItemId())
                && Objects.equals(isVerified(), other.isVerified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLibraryItemMetadataRequest").add("InstanceId", instanceId())
                .add("LibraryItemId", libraryItemId()).add("IsVerified", isVerified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "libraryItemId":
            return Optional.ofNullable(clazz.cast(libraryItemId()));
        case "isVerified":
            return Optional.ofNullable(clazz.cast(isVerified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instance-id", INSTANCE_ID_FIELD);
        map.put("libraryItemId", LIBRARY_ITEM_ID_FIELD);
        map.put("isVerified", IS_VERIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLibraryItemMetadataRequest, T> g) {
        return obj -> g.apply((UpdateLibraryItemMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLibraryItemMetadataRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Q Business application environment instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier of the Amazon Q Business application environment instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier of the updated library item.
         * </p>
         * 
         * @param libraryItemId
         *        The unique identifier of the updated library item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder libraryItemId(String libraryItemId);

        /**
         * <p>
         * The verification status of the library item
         * </p>
         * 
         * @param isVerified
         *        The verification status of the library item
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isVerified(Boolean isVerified);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QAppsRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String libraryItemId;

        private Boolean isVerified;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLibraryItemMetadataRequest model) {
            super(model);
            instanceId(model.instanceId);
            libraryItemId(model.libraryItemId);
            isVerified(model.isVerified);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getLibraryItemId() {
            return libraryItemId;
        }

        public final void setLibraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
        }

        @Override
        public final Builder libraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
            return this;
        }

        public final Boolean getIsVerified() {
            return isVerified;
        }

        public final void setIsVerified(Boolean isVerified) {
            this.isVerified = isVerified;
        }

        @Override
        public final Builder isVerified(Boolean isVerified) {
            this.isVerified = isVerified;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLibraryItemMetadataRequest build() {
            return new UpdateLibraryItemMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
