/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQAppPermissionsRequest extends QAppsRequest implements
        ToCopyableBuilder<UpdateQAppPermissionsRequest.Builder, UpdateQAppPermissionsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(UpdateQAppPermissionsRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(UpdateQAppPermissionsRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<List<PermissionInput>> GRANT_PERMISSIONS_FIELD = SdkField
            .<List<PermissionInput>> builder(MarshallingType.LIST)
            .memberName("grantPermissions")
            .getter(getter(UpdateQAppPermissionsRequest::grantPermissions))
            .setter(setter(Builder::grantPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PermissionInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(PermissionInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PermissionInput>> REVOKE_PERMISSIONS_FIELD = SdkField
            .<List<PermissionInput>> builder(MarshallingType.LIST)
            .memberName("revokePermissions")
            .getter(getter(UpdateQAppPermissionsRequest::revokePermissions))
            .setter(setter(Builder::revokePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokePermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PermissionInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(PermissionInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            APP_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String appId;

    private final List<PermissionInput> grantPermissions;

    private final List<PermissionInput> revokePermissions;

    private UpdateQAppPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.appId = builder.appId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application environment instance.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application environment instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q App for which permissions are being updated.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q App for which permissions are being updated.
     */
    public final String appId() {
        return appId;
    }

    /**
     * For responses, this returns true if the service returned a value for the GrantPermissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGrantPermissions() {
        return grantPermissions != null && !(grantPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of permissions to grant for the Amazon Q App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrantPermissions} method.
     * </p>
     * 
     * @return The list of permissions to grant for the Amazon Q App.
     */
    public final List<PermissionInput> grantPermissions() {
        return grantPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RevokePermissions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRevokePermissions() {
        return revokePermissions != null && !(revokePermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of permissions to revoke for the Amazon Q App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRevokePermissions} method.
     * </p>
     * 
     * @return The list of permissions to revoke for the Amazon Q App.
     */
    public final List<PermissionInput> revokePermissions() {
        return revokePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(hasGrantPermissions() ? grantPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRevokePermissions() ? revokePermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQAppPermissionsRequest)) {
            return false;
        }
        UpdateQAppPermissionsRequest other = (UpdateQAppPermissionsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(appId(), other.appId())
                && hasGrantPermissions() == other.hasGrantPermissions()
                && Objects.equals(grantPermissions(), other.grantPermissions())
                && hasRevokePermissions() == other.hasRevokePermissions()
                && Objects.equals(revokePermissions(), other.revokePermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQAppPermissionsRequest").add("InstanceId", instanceId()).add("AppId", appId())
                .add("GrantPermissions", hasGrantPermissions() ? grantPermissions() : null)
                .add("RevokePermissions", hasRevokePermissions() ? revokePermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "grantPermissions":
            return Optional.ofNullable(clazz.cast(grantPermissions()));
        case "revokePermissions":
            return Optional.ofNullable(clazz.cast(revokePermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instance-id", INSTANCE_ID_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("grantPermissions", GRANT_PERMISSIONS_FIELD);
        map.put("revokePermissions", REVOKE_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQAppPermissionsRequest, T> g) {
        return obj -> g.apply((UpdateQAppPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QAppsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQAppPermissionsRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Q Business application environment instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier of the Amazon Q Business application environment instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier of the Amazon Q App for which permissions are being updated.
         * </p>
         * 
         * @param appId
         *        The unique identifier of the Amazon Q App for which permissions are being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The list of permissions to grant for the Amazon Q App.
         * </p>
         * 
         * @param grantPermissions
         *        The list of permissions to grant for the Amazon Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(Collection<PermissionInput> grantPermissions);

        /**
         * <p>
         * The list of permissions to grant for the Amazon Q App.
         * </p>
         * 
         * @param grantPermissions
         *        The list of permissions to grant for the Amazon Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(PermissionInput... grantPermissions);

        /**
         * <p>
         * The list of permissions to grant for the Amazon Q App.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.PermissionInput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qapps.model.PermissionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qapps.model.PermissionInput.Builder#build()} is called immediately and
         * its result is passed to {@link #grantPermissions(List<PermissionInput>)}.
         * 
         * @param grantPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qapps.model.PermissionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantPermissions(java.util.Collection<PermissionInput>)
         */
        Builder grantPermissions(Consumer<PermissionInput.Builder>... grantPermissions);

        /**
         * <p>
         * The list of permissions to revoke for the Amazon Q App.
         * </p>
         * 
         * @param revokePermissions
         *        The list of permissions to revoke for the Amazon Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(Collection<PermissionInput> revokePermissions);

        /**
         * <p>
         * The list of permissions to revoke for the Amazon Q App.
         * </p>
         * 
         * @param revokePermissions
         *        The list of permissions to revoke for the Amazon Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(PermissionInput... revokePermissions);

        /**
         * <p>
         * The list of permissions to revoke for the Amazon Q App.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.PermissionInput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qapps.model.PermissionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qapps.model.PermissionInput.Builder#build()} is called immediately and
         * its result is passed to {@link #revokePermissions(List<PermissionInput>)}.
         * 
         * @param revokePermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qapps.model.PermissionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revokePermissions(java.util.Collection<PermissionInput>)
         */
        Builder revokePermissions(Consumer<PermissionInput.Builder>... revokePermissions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QAppsRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String appId;

        private List<PermissionInput> grantPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<PermissionInput> revokePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQAppPermissionsRequest model) {
            super(model);
            instanceId(model.instanceId);
            appId(model.appId);
            grantPermissions(model.grantPermissions);
            revokePermissions(model.revokePermissions);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final List<PermissionInput.Builder> getGrantPermissions() {
            List<PermissionInput.Builder> result = UpdateQAppPermissionsInputGrantPermissionsListCopier
                    .copyToBuilder(this.grantPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantPermissions(Collection<PermissionInput.BuilderImpl> grantPermissions) {
            this.grantPermissions = UpdateQAppPermissionsInputGrantPermissionsListCopier.copyFromBuilder(grantPermissions);
        }

        @Override
        public final Builder grantPermissions(Collection<PermissionInput> grantPermissions) {
            this.grantPermissions = UpdateQAppPermissionsInputGrantPermissionsListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(PermissionInput... grantPermissions) {
            grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Consumer<PermissionInput.Builder>... grantPermissions) {
            grantPermissions(Stream.of(grantPermissions).map(c -> PermissionInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PermissionInput.Builder> getRevokePermissions() {
            List<PermissionInput.Builder> result = UpdateQAppPermissionsInputRevokePermissionsListCopier
                    .copyToBuilder(this.revokePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevokePermissions(Collection<PermissionInput.BuilderImpl> revokePermissions) {
            this.revokePermissions = UpdateQAppPermissionsInputRevokePermissionsListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        public final Builder revokePermissions(Collection<PermissionInput> revokePermissions) {
            this.revokePermissions = UpdateQAppPermissionsInputRevokePermissionsListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(PermissionInput... revokePermissions) {
            revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Consumer<PermissionInput.Builder>... revokePermissions) {
            revokePermissions(Stream.of(revokePermissions).map(c -> PermissionInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQAppPermissionsRequest build() {
            return new UpdateQAppPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
