/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentScope {
    APPLICATION("APPLICATION"),
    SESSION("SESSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentScope> VALUE_MAP;
    private final String value;

    private DocumentScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentScope> knownValues() {
        EnumSet<DocumentScope> knownValues = EnumSet.allOf(DocumentScope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentScope.class, DocumentScope::toString);
    }
}

