/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePresignedUrlRequest extends QAppsRequest implements
        ToCopyableBuilder<CreatePresignedUrlRequest.Builder, CreatePresignedUrlRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(CreatePresignedUrlRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()).build();

    private static final SdkField<String> CARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cardId")
            .getter(getter(CreatePresignedUrlRequest::cardId)).setter(setter(Builder::cardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardId").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(CreatePresignedUrlRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> FILE_CONTENTS_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileContentsSha256").getter(getter(CreatePresignedUrlRequest::fileContentsSha256))
            .setter(setter(Builder::fileContentsSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileContentsSha256").build())
            .build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileName").getter(getter(CreatePresignedUrlRequest::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(CreatePresignedUrlRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(CreatePresignedUrlRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CARD_ID_FIELD, APP_ID_FIELD, FILE_CONTENTS_SHA256_FIELD, FILE_NAME_FIELD, SCOPE_FIELD, SESSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String cardId;

    private final String appId;

    private final String fileContentsSha256;

    private final String fileName;

    private final String scope;

    private final String sessionId;

    private CreatePresignedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.cardId = builder.cardId;
        this.appId = builder.appId;
        this.fileContentsSha256 = builder.fileContentsSha256;
        this.fileName = builder.fileName;
        this.scope = builder.scope;
        this.sessionId = builder.sessionId;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application environment instance.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application environment instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier of the card the file is associated with.
     * </p>
     * 
     * @return The unique identifier of the card the file is associated with.
     */
    public final String cardId() {
        return cardId;
    }

    /**
     * <p>
     * The unique identifier of the Q App the file is associated with.
     * </p>
     * 
     * @return The unique identifier of the Q App the file is associated with.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The Base64-encoded SHA-256 digest of the contents of the file to be uploaded.
     * </p>
     * 
     * @return The Base64-encoded SHA-256 digest of the contents of the file to be uploaded.
     */
    public final String fileContentsSha256() {
        return fileContentsSha256;
    }

    /**
     * <p>
     * The name of the file to be uploaded.
     * </p>
     * 
     * @return The name of the file to be uploaded.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * Whether the file is associated with a Q App definition or a specific Q App session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link DocumentScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Whether the file is associated with a Q App definition or a specific Q App session.
     * @see DocumentScope
     */
    public final DocumentScope scope() {
        return DocumentScope.fromValue(scope);
    }

    /**
     * <p>
     * Whether the file is associated with a Q App definition or a specific Q App session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link DocumentScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Whether the file is associated with a Q App definition or a specific Q App session.
     * @see DocumentScope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The unique identifier of the Q App session the file is associated with, if applicable.
     * </p>
     * 
     * @return The unique identifier of the Q App session the file is associated with, if applicable.
     */
    public final String sessionId() {
        return sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(cardId());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(fileContentsSha256());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedUrlRequest)) {
            return false;
        }
        CreatePresignedUrlRequest other = (CreatePresignedUrlRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(cardId(), other.cardId())
                && Objects.equals(appId(), other.appId()) && Objects.equals(fileContentsSha256(), other.fileContentsSha256())
                && Objects.equals(fileName(), other.fileName()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(sessionId(), other.sessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePresignedUrlRequest").add("InstanceId", instanceId()).add("CardId", cardId())
                .add("AppId", appId()).add("FileContentsSha256", fileContentsSha256()).add("FileName", fileName())
                .add("Scope", scopeAsString()).add("SessionId", sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "cardId":
            return Optional.ofNullable(clazz.cast(cardId()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "fileContentsSha256":
            return Optional.ofNullable(clazz.cast(fileContentsSha256()));
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instance-id", INSTANCE_ID_FIELD);
        map.put("cardId", CARD_ID_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("fileContentsSha256", FILE_CONTENTS_SHA256_FIELD);
        map.put("fileName", FILE_NAME_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedUrlRequest, T> g) {
        return obj -> g.apply((CreatePresignedUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QAppsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePresignedUrlRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Q Business application environment instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier of the Amazon Q Business application environment instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier of the card the file is associated with.
         * </p>
         * 
         * @param cardId
         *        The unique identifier of the card the file is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardId(String cardId);

        /**
         * <p>
         * The unique identifier of the Q App the file is associated with.
         * </p>
         * 
         * @param appId
         *        The unique identifier of the Q App the file is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The Base64-encoded SHA-256 digest of the contents of the file to be uploaded.
         * </p>
         * 
         * @param fileContentsSha256
         *        The Base64-encoded SHA-256 digest of the contents of the file to be uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileContentsSha256(String fileContentsSha256);

        /**
         * <p>
         * The name of the file to be uploaded.
         * </p>
         * 
         * @param fileName
         *        The name of the file to be uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * Whether the file is associated with a Q App definition or a specific Q App session.
         * </p>
         * 
         * @param scope
         *        Whether the file is associated with a Q App definition or a specific Q App session.
         * @see DocumentScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Whether the file is associated with a Q App definition or a specific Q App session.
         * </p>
         * 
         * @param scope
         *        Whether the file is associated with a Q App definition or a specific Q App session.
         * @see DocumentScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentScope
         */
        Builder scope(DocumentScope scope);

        /**
         * <p>
         * The unique identifier of the Q App session the file is associated with, if applicable.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the Q App session the file is associated with, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QAppsRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String cardId;

        private String appId;

        private String fileContentsSha256;

        private String fileName;

        private String scope;

        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedUrlRequest model) {
            super(model);
            instanceId(model.instanceId);
            cardId(model.cardId);
            appId(model.appId);
            fileContentsSha256(model.fileContentsSha256);
            fileName(model.fileName);
            scope(model.scope);
            sessionId(model.sessionId);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getCardId() {
            return cardId;
        }

        public final void setCardId(String cardId) {
            this.cardId = cardId;
        }

        @Override
        public final Builder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getFileContentsSha256() {
            return fileContentsSha256;
        }

        public final void setFileContentsSha256(String fileContentsSha256) {
            this.fileContentsSha256 = fileContentsSha256;
        }

        @Override
        public final Builder fileContentsSha256(String fileContentsSha256) {
            this.fileContentsSha256 = fileContentsSha256;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(DocumentScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresignedUrlRequest build() {
            return new CreatePresignedUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
