/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a file upload card. It can optionally receive a <code>filename</code> and <code>fileId</code> to set a
 * default file. If not received, the user must provide the file when the Q App runs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileUploadCardInput implements SdkPojo, Serializable,
        ToCopyableBuilder<FileUploadCardInput.Builder, FileUploadCardInput> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(FileUploadCardInput::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FileUploadCardInput::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FileUploadCardInput::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> FILENAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filename").getter(getter(FileUploadCardInput::filename)).setter(setter(Builder::filename))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filename").build()).build();

    private static final SdkField<String> FILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fileId")
            .getter(getter(FileUploadCardInput::fileId)).setter(setter(Builder::fileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileId").build()).build();

    private static final SdkField<Boolean> ALLOW_OVERRIDE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowOverride").getter(getter(FileUploadCardInput::allowOverride))
            .setter(setter(Builder::allowOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowOverride").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ID_FIELD,
            TYPE_FIELD, FILENAME_FIELD, FILE_ID_FIELD, ALLOW_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String id;

    private final String type;

    private final String filename;

    private final String fileId;

    private final Boolean allowOverride;

    private FileUploadCardInput(BuilderImpl builder) {
        this.title = builder.title;
        this.id = builder.id;
        this.type = builder.type;
        this.filename = builder.filename;
        this.fileId = builder.fileId;
        this.allowOverride = builder.allowOverride;
    }

    /**
     * <p>
     * The title or label of the file upload card.
     * </p>
     * 
     * @return The title or label of the file upload card.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The unique identifier of the file upload card.
     * </p>
     * 
     * @return The unique identifier of the file upload card.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final CardType type() {
        return CardType.fromValue(type);
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The default filename to use for the file upload card.
     * </p>
     * 
     * @return The default filename to use for the file upload card.
     */
    public final String filename() {
        return filename;
    }

    /**
     * <p>
     * The identifier of a pre-uploaded file associated with the card.
     * </p>
     * 
     * @return The identifier of a pre-uploaded file associated with the card.
     */
    public final String fileId() {
        return fileId;
    }

    /**
     * <p>
     * A flag indicating if the user can override the default file for the upload card.
     * </p>
     * 
     * @return A flag indicating if the user can override the default file for the upload card.
     */
    public final Boolean allowOverride() {
        return allowOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filename());
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        hashCode = 31 * hashCode + Objects.hashCode(allowOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileUploadCardInput)) {
            return false;
        }
        FileUploadCardInput other = (FileUploadCardInput) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(id(), other.id())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(filename(), other.filename())
                && Objects.equals(fileId(), other.fileId()) && Objects.equals(allowOverride(), other.allowOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileUploadCardInput").add("Title", title()).add("Id", id()).add("Type", typeAsString())
                .add("Filename", filename()).add("FileId", fileId()).add("AllowOverride", allowOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "filename":
            return Optional.ofNullable(clazz.cast(filename()));
        case "fileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        case "allowOverride":
            return Optional.ofNullable(clazz.cast(allowOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("id", ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("filename", FILENAME_FIELD);
        map.put("fileId", FILE_ID_FIELD);
        map.put("allowOverride", ALLOW_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileUploadCardInput, T> g) {
        return obj -> g.apply((FileUploadCardInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileUploadCardInput> {
        /**
         * <p>
         * The title or label of the file upload card.
         * </p>
         * 
         * @param title
         *        The title or label of the file upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The unique identifier of the file upload card.
         * </p>
         * 
         * @param id
         *        The unique identifier of the file upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(CardType type);

        /**
         * <p>
         * The default filename to use for the file upload card.
         * </p>
         * 
         * @param filename
         *        The default filename to use for the file upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filename(String filename);

        /**
         * <p>
         * The identifier of a pre-uploaded file associated with the card.
         * </p>
         * 
         * @param fileId
         *        The identifier of a pre-uploaded file associated with the card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(String fileId);

        /**
         * <p>
         * A flag indicating if the user can override the default file for the upload card.
         * </p>
         * 
         * @param allowOverride
         *        A flag indicating if the user can override the default file for the upload card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOverride(Boolean allowOverride);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String id;

        private String type;

        private String filename;

        private String fileId;

        private Boolean allowOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(FileUploadCardInput model) {
            title(model.title);
            id(model.id);
            type(model.type);
            filename(model.filename);
            fileId(model.fileId);
            allowOverride(model.allowOverride);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFilename() {
            return filename;
        }

        public final void setFilename(String filename) {
            this.filename = filename;
        }

        @Override
        public final Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public final String getFileId() {
            return fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final Boolean getAllowOverride() {
            return allowOverride;
        }

        public final void setAllowOverride(Boolean allowOverride) {
            this.allowOverride = allowOverride;
        }

        @Override
        public final Builder allowOverride(Boolean allowOverride) {
            this.allowOverride = allowOverride;
            return this;
        }

        @Override
        public FileUploadCardInput build() {
            return new FileUploadCardInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
