/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CardModelListCopier {
    static List<Card> copy(Collection<? extends Card> cardModelListParam) {
        List<Card> list;
        if (cardModelListParam == null || cardModelListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Card> modifiableList = new ArrayList<>(cardModelListParam.size());
            cardModelListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Card> copyFromBuilder(Collection<? extends Card.Builder> cardModelListParam) {
        List<Card> list;
        if (cardModelListParam == null || cardModelListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Card> modifiableList = new ArrayList<>(cardModelListParam.size());
            cardModelListParam.forEach(entry -> {
                Card member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Card.Builder> copyToBuilder(Collection<? extends Card> cardModelListParam) {
        List<Card.Builder> list;
        if (cardModelListParam == null || cardModelListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Card.Builder> modifiableList = new ArrayList<>(cardModelListParam.size());
            cardModelListParam.forEach(entry -> {
                Card.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
