/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeQAppPermissionsResponse extends QAppsResponse implements
        ToCopyableBuilder<DescribeQAppPermissionsResponse.Builder, DescribeQAppPermissionsResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(DescribeQAppPermissionsResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(DescribeQAppPermissionsResponse::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<List<PermissionOutput>> PERMISSIONS_FIELD = SdkField
            .<List<PermissionOutput>> builder(MarshallingType.LIST)
            .memberName("permissions")
            .getter(getter(DescribeQAppPermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PermissionOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(PermissionOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            APP_ID_FIELD, PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String appId;

    private final List<PermissionOutput> permissions;

    private DescribeQAppPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.appId = builder.appId;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q App for which permissions are returned.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q App for which permissions are returned.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q App for which permissions are returned.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q App for which permissions are returned.
     */
    public final String appId() {
        return appId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of permissions granted for the Amazon Q App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The list of permissions granted for the Amazon Q App.
     */
    public final List<PermissionOutput> permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQAppPermissionsResponse)) {
            return false;
        }
        DescribeQAppPermissionsResponse other = (DescribeQAppPermissionsResponse) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(appId(), other.appId())
                && hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeQAppPermissionsResponse").add("ResourceArn", resourceArn()).add("AppId", appId())
                .add("Permissions", hasPermissions() ? permissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeQAppPermissionsResponse, T> g) {
        return obj -> g.apply((DescribeQAppPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeQAppPermissionsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q App for which permissions are returned.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the Amazon Q App for which permissions are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The unique identifier of the Amazon Q App for which permissions are returned.
         * </p>
         * 
         * @param appId
         *        The unique identifier of the Amazon Q App for which permissions are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The list of permissions granted for the Amazon Q App.
         * </p>
         * 
         * @param permissions
         *        The list of permissions granted for the Amazon Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<PermissionOutput> permissions);

        /**
         * <p>
         * The list of permissions granted for the Amazon Q App.
         * </p>
         * 
         * @param permissions
         *        The list of permissions granted for the Amazon Q App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(PermissionOutput... permissions);

        /**
         * <p>
         * The list of permissions granted for the Amazon Q App.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qapps.model.PermissionOutput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qapps.model.PermissionOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qapps.model.PermissionOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(List<PermissionOutput>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qapps.model.PermissionOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(java.util.Collection<PermissionOutput>)
         */
        Builder permissions(Consumer<PermissionOutput.Builder>... permissions);
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private String resourceArn;

        private String appId;

        private List<PermissionOutput> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQAppPermissionsResponse model) {
            super(model);
            resourceArn(model.resourceArn);
            appId(model.appId);
            permissions(model.permissions);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final List<PermissionOutput.Builder> getPermissions() {
            List<PermissionOutput.Builder> result = PermissionsOutputListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<PermissionOutput.BuilderImpl> permissions) {
            this.permissions = PermissionsOutputListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<PermissionOutput> permissions) {
            this.permissions = PermissionsOutputListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(PermissionOutput... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<PermissionOutput.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> PermissionOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeQAppPermissionsResponse build() {
            return new DescribeQAppPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
