/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePresignedUrlResponse extends QAppsResponse implements
        ToCopyableBuilder<CreatePresignedUrlResponse.Builder, CreatePresignedUrlResponse> {
    private static final SdkField<String> FILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fileId")
            .getter(getter(CreatePresignedUrlResponse::fileId)).setter(setter(Builder::fileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileId").build()).build();

    private static final SdkField<String> PRESIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("presignedUrl").getter(getter(CreatePresignedUrlResponse::presignedUrl))
            .setter(setter(Builder::presignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrl").build()).build();

    private static final SdkField<Map<String, String>> PRESIGNED_URL_FIELDS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("presignedUrlFields")
            .getter(getter(CreatePresignedUrlResponse::presignedUrlFields))
            .setter(setter(Builder::presignedUrlFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlFields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> PRESIGNED_URL_EXPIRATION_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("presignedUrlExpiration")
            .getter(getter(CreatePresignedUrlResponse::presignedUrlExpiration))
            .setter(setter(Builder::presignedUrlExpiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlExpiration").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_ID_FIELD,
            PRESIGNED_URL_FIELD, PRESIGNED_URL_FIELDS_FIELD, PRESIGNED_URL_EXPIRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileId;

    private final String presignedUrl;

    private final Map<String, String> presignedUrlFields;

    private final Instant presignedUrlExpiration;

    private CreatePresignedUrlResponse(BuilderImpl builder) {
        super(builder);
        this.fileId = builder.fileId;
        this.presignedUrl = builder.presignedUrl;
        this.presignedUrlFields = builder.presignedUrlFields;
        this.presignedUrlExpiration = builder.presignedUrlExpiration;
    }

    /**
     * <p>
     * The unique identifier assigned to the file to be uploaded.
     * </p>
     * 
     * @return The unique identifier assigned to the file to be uploaded.
     */
    public final String fileId() {
        return fileId;
    }

    /**
     * <p>
     * The URL for a presigned S3 POST operation used to upload a file.
     * </p>
     * 
     * @return The URL for a presigned S3 POST operation used to upload a file.
     */
    public final String presignedUrl() {
        return presignedUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the PresignedUrlFields property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPresignedUrlFields() {
        return presignedUrlFields != null && !(presignedUrlFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The form fields to include in the presigned S3 POST operation used to upload a file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPresignedUrlFields} method.
     * </p>
     * 
     * @return The form fields to include in the presigned S3 POST operation used to upload a file.
     */
    public final Map<String, String> presignedUrlFields() {
        return presignedUrlFields;
    }

    /**
     * <p>
     * The date and time that the presigned URL will expire in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the presigned URL will expire in ISO 8601 format.
     */
    public final Instant presignedUrlExpiration() {
        return presignedUrlExpiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        hashCode = 31 * hashCode + Objects.hashCode(presignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasPresignedUrlFields() ? presignedUrlFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(presignedUrlExpiration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedUrlResponse)) {
            return false;
        }
        CreatePresignedUrlResponse other = (CreatePresignedUrlResponse) obj;
        return Objects.equals(fileId(), other.fileId()) && Objects.equals(presignedUrl(), other.presignedUrl())
                && hasPresignedUrlFields() == other.hasPresignedUrlFields()
                && Objects.equals(presignedUrlFields(), other.presignedUrlFields())
                && Objects.equals(presignedUrlExpiration(), other.presignedUrlExpiration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePresignedUrlResponse").add("FileId", fileId()).add("PresignedUrl", presignedUrl())
                .add("PresignedUrlFields", hasPresignedUrlFields() ? presignedUrlFields() : null)
                .add("PresignedUrlExpiration", presignedUrlExpiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        case "presignedUrl":
            return Optional.ofNullable(clazz.cast(presignedUrl()));
        case "presignedUrlFields":
            return Optional.ofNullable(clazz.cast(presignedUrlFields()));
        case "presignedUrlExpiration":
            return Optional.ofNullable(clazz.cast(presignedUrlExpiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileId", FILE_ID_FIELD);
        map.put("presignedUrl", PRESIGNED_URL_FIELD);
        map.put("presignedUrlFields", PRESIGNED_URL_FIELDS_FIELD);
        map.put("presignedUrlExpiration", PRESIGNED_URL_EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedUrlResponse, T> g) {
        return obj -> g.apply((CreatePresignedUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePresignedUrlResponse> {
        /**
         * <p>
         * The unique identifier assigned to the file to be uploaded.
         * </p>
         * 
         * @param fileId
         *        The unique identifier assigned to the file to be uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(String fileId);

        /**
         * <p>
         * The URL for a presigned S3 POST operation used to upload a file.
         * </p>
         * 
         * @param presignedUrl
         *        The URL for a presigned S3 POST operation used to upload a file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedUrl(String presignedUrl);

        /**
         * <p>
         * The form fields to include in the presigned S3 POST operation used to upload a file.
         * </p>
         * 
         * @param presignedUrlFields
         *        The form fields to include in the presigned S3 POST operation used to upload a file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedUrlFields(Map<String, String> presignedUrlFields);

        /**
         * <p>
         * The date and time that the presigned URL will expire in ISO 8601 format.
         * </p>
         * 
         * @param presignedUrlExpiration
         *        The date and time that the presigned URL will expire in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedUrlExpiration(Instant presignedUrlExpiration);
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private String fileId;

        private String presignedUrl;

        private Map<String, String> presignedUrlFields = DefaultSdkAutoConstructMap.getInstance();

        private Instant presignedUrlExpiration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedUrlResponse model) {
            super(model);
            fileId(model.fileId);
            presignedUrl(model.presignedUrl);
            presignedUrlFields(model.presignedUrlFields);
            presignedUrlExpiration(model.presignedUrlExpiration);
        }

        public final String getFileId() {
            return fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final String getPresignedUrl() {
            return presignedUrl;
        }

        public final void setPresignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
        }

        @Override
        public final Builder presignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
            return this;
        }

        public final Map<String, String> getPresignedUrlFields() {
            if (presignedUrlFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return presignedUrlFields;
        }

        public final void setPresignedUrlFields(Map<String, String> presignedUrlFields) {
            this.presignedUrlFields = PresignedUrlFieldsCopier.copy(presignedUrlFields);
        }

        @Override
        public final Builder presignedUrlFields(Map<String, String> presignedUrlFields) {
            this.presignedUrlFields = PresignedUrlFieldsCopier.copy(presignedUrlFields);
            return this;
        }

        public final Instant getPresignedUrlExpiration() {
            return presignedUrlExpiration;
        }

        public final void setPresignedUrlExpiration(Instant presignedUrlExpiration) {
            this.presignedUrlExpiration = presignedUrlExpiration;
        }

        @Override
        public final Builder presignedUrlExpiration(Instant presignedUrlExpiration) {
            this.presignedUrlExpiration = presignedUrlExpiration;
            return this;
        }

        @Override
        public CreatePresignedUrlResponse build() {
            return new CreatePresignedUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
