/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.qbusiness.internal.QBusinessServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.qbusiness.model.AccessDeniedException;
import software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentRequest;
import software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentResponse;
import software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentRequest;
import software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentResponse;
import software.amazon.awssdk.services.qbusiness.model.ChatSyncRequest;
import software.amazon.awssdk.services.qbusiness.model.ChatSyncResponse;
import software.amazon.awssdk.services.qbusiness.model.ConflictException;
import software.amazon.awssdk.services.qbusiness.model.CreateApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.CreatePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.CreatePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteConversationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteConversationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.DeletePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.DeletePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.GetApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.GetDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.GetGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.GetGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.GetIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.GetIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.GetPluginRequest;
import software.amazon.awssdk.services.qbusiness.model.GetPluginResponse;
import software.amazon.awssdk.services.qbusiness.model.GetRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.GetRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.GetUserRequest;
import software.amazon.awssdk.services.qbusiness.model.GetUserResponse;
import software.amazon.awssdk.services.qbusiness.model.GetWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.GetWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.InternalServerException;
import software.amazon.awssdk.services.qbusiness.model.LicenseNotFoundException;
import software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse;
import software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse;
import software.amazon.awssdk.services.qbusiness.model.PutFeedbackRequest;
import software.amazon.awssdk.services.qbusiness.model.PutFeedbackResponse;
import software.amazon.awssdk.services.qbusiness.model.PutGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.PutGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.QBusinessException;
import software.amazon.awssdk.services.qbusiness.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qbusiness.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobRequest;
import software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobResponse;
import software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobRequest;
import software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobResponse;
import software.amazon.awssdk.services.qbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.ThrottlingException;
import software.amazon.awssdk.services.qbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdatePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdatePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateUserRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateUserResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.ValidationException;
import software.amazon.awssdk.services.qbusiness.transform.BatchDeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.BatchPutDocumentRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ChatSyncRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreatePluginRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateRetrieverRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateWebExperienceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteChatControlsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteConversationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteIndexRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeletePluginRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteRetrieverRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteWebExperienceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetApplicationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetChatControlsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetIndexRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetPluginRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetRetrieverRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetWebExperienceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListConversationsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListDataSourceSyncJobsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListDocumentsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListIndicesRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListMessagesRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListPluginsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListRetrieversRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListWebExperiencesRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.PutFeedbackRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.PutGroupRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.StartDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.StopDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateChatControlsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateIndexRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdatePluginRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateRetrieverRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateWebExperienceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link QBusinessAsyncClient}.
 *
 * @see QBusinessAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultQBusinessAsyncClient implements QBusinessAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultQBusinessAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQBusinessAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Asynchronously deletes one or more documents added using the <code>BatchPutDocument</code> API from an Amazon Q
     * index.
     * </p>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     *
     * @param batchDeleteDocumentRequest
     * @return A Java Future containing the result of the BatchDeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteDocumentResponse> batchDeleteDocument(
            BatchDeleteDocumentRequest batchDeleteDocumentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteDocumentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteDocumentRequest, BatchDeleteDocumentResponse>()
                            .withOperationName("BatchDeleteDocument").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteDocumentRequest));
            CompletableFuture<BatchDeleteDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more documents to an Amazon Q index.
     * </p>
     * <p>
     * You use this API to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ingest your structured and unstructured documents and documents stored in an Amazon S3 bucket into an Amazon Q
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * add custom attributes to documents in an Amazon Q index.
     * </p>
     * </li>
     * <li>
     * <p>
     * attach an access control list to the documents added to an Amazon Q index.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     *
     * @param batchPutDocumentRequest
     * @return A Java Future containing the result of the BatchPutDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchPutDocument" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchPutDocumentResponse> batchPutDocument(BatchPutDocumentRequest batchPutDocumentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchPutDocumentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchPutDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchPutDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchPutDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchPutDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchPutDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchPutDocumentRequest, BatchPutDocumentResponse>()
                            .withOperationName("BatchPutDocument").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchPutDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchPutDocumentRequest));
            CompletableFuture<BatchPutDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts or continues a non-streaming Amazon Q conversation.
     * </p>
     *
     * @param chatSyncRequest
     * @return A Java Future containing the result of the ChatSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ChatSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ChatSync" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ChatSyncResponse> chatSync(ChatSyncRequest chatSyncRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(chatSyncRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, chatSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChatSync");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ChatSyncResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ChatSyncResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ChatSyncResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ChatSyncRequest, ChatSyncResponse>().withOperationName("ChatSync")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ChatSyncRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(chatSyncRequest));
            CompletableFuture<ChatSyncResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Q application.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                            .withOperationName("CreateApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createApplicationRequest));
            CompletableFuture<CreateApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a data source connector for an Amazon Q application.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataSourceRequest, CreateDataSourceResponse>()
                            .withOperationName("CreateDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDataSourceRequest));
            CompletableFuture<CreateDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Q index.
     * </p>
     * <p>
     * To determine if index creation has completed, check the <code>Status</code> field returned from a call to
     * <code>DescribeIndex</code>. The <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready
     * to use.
     * </p>
     * <p>
     * Once the index is active, you can index your documents using the <a
     * href="https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_BatchPutDocument.html">
     * <code>BatchPutDocument</code> </a> API or the <a
     * href="https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_CreateDataSource.html">
     * <code>CreateDataSource</code> </a> API.
     * </p>
     *
     * @param createIndexRequest
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIndexRequest, CreateIndexResponse>()
                            .withOperationName("CreateIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIndexRequest));
            CompletableFuture<CreateIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Q plugin.
     * </p>
     *
     * @param createPluginRequest
     * @return A Java Future containing the result of the CreatePlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePluginResponse> createPlugin(CreatePluginRequest createPluginRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPluginRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePlugin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePluginResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreatePluginResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePluginResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePluginRequest, CreatePluginResponse>()
                            .withOperationName("CreatePlugin").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePluginRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPluginRequest));
            CompletableFuture<CreatePluginResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a retriever to your Amazon Q application.
     * </p>
     *
     * @param createRetrieverRequest
     * @return A Java Future containing the result of the CreateRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRetrieverResponse> createRetriever(CreateRetrieverRequest createRetrieverRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRetrieverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRetrieverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRetriever");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRetrieverResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRetrieverResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRetrieverResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRetrieverRequest, CreateRetrieverResponse>()
                            .withOperationName("CreateRetriever").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRetrieverRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRetrieverRequest));
            CompletableFuture<CreateRetrieverResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a universally unique identifier (UUID) mapped to a list of local user ids within an application.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserRequest));
            CompletableFuture<CreateUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Q web experience.
     * </p>
     *
     * @param createWebExperienceRequest
     * @return A Java Future containing the result of the CreateWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWebExperienceResponse> createWebExperience(
            CreateWebExperienceRequest createWebExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWebExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWebExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWebExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWebExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWebExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWebExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWebExperienceRequest, CreateWebExperienceResponse>()
                            .withOperationName("CreateWebExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWebExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWebExperienceRequest));
            CompletableFuture<CreateWebExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                            .withOperationName("DeleteApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteApplicationRequest));
            CompletableFuture<DeleteApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes chat controls configured for an existing Amazon Q application.
     * </p>
     *
     * @param deleteChatControlsConfigurationRequest
     * @return A Java Future containing the result of the DeleteChatControlsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteChatControlsConfigurationResponse> deleteChatControlsConfiguration(
            DeleteChatControlsConfigurationRequest deleteChatControlsConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChatControlsConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteChatControlsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChatControlsConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteChatControlsConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteChatControlsConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteChatControlsConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteChatControlsConfigurationRequest, DeleteChatControlsConfigurationResponse>()
                            .withOperationName("DeleteChatControlsConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteChatControlsConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteChatControlsConfigurationRequest));
            CompletableFuture<DeleteChatControlsConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q web experience conversation.
     * </p>
     *
     * @param deleteConversationRequest
     * @return A Java Future containing the result of the DeleteConversation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteConversation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteConversation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConversationResponse> deleteConversation(DeleteConversationRequest deleteConversationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConversationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConversationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConversation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConversationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConversationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConversationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConversationRequest, DeleteConversationResponse>()
                            .withOperationName("DeleteConversation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConversationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConversationRequest));
            CompletableFuture<DeleteConversationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q data source connector. While the data source is being deleted, the <code>Status</code> field
     * returned by a call to the <code>DescribeDataSource</code> API is set to <code>DELETING</code>.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                            .withOperationName("DeleteDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDataSourceRequest));
            CompletableFuture<DeleteDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group. For example, after deleting the group "Summer Interns", all interns who belonged to that
     * group no longer see intern-only documents in their chat results.
     * </p>
     * <p>
     * If you want to delete, update, or replace users or sub groups of a group, you need to use the
     * <code>PutGroup</code> operation. For example, if a user in the group "Engineering" leaves the engineering team
     * and another user takes their place, you provide an updated list of users or sub groups that belong to the
     * "Engineering" group when calling <code>PutGroup</code>.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGroupRequest));
            CompletableFuture<DeleteGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q index.
     * </p>
     *
     * @param deleteIndexRequest
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIndexResponse> deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIndexRequest, DeleteIndexResponse>()
                            .withOperationName("DeleteIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIndexRequest));
            CompletableFuture<DeleteIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q plugin.
     * </p>
     *
     * @param deletePluginRequest
     * @return A Java Future containing the result of the DeletePlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeletePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeletePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePluginResponse> deletePlugin(DeletePluginRequest deletePluginRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePluginRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePlugin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePluginResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeletePluginResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePluginResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePluginRequest, DeletePluginResponse>()
                            .withOperationName("DeletePlugin").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePluginRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePluginRequest));
            CompletableFuture<DeletePluginResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the retriever used by an Amazon Q application.
     * </p>
     *
     * @param deleteRetrieverRequest
     * @return A Java Future containing the result of the DeleteRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRetrieverResponse> deleteRetriever(DeleteRetrieverRequest deleteRetrieverRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRetrieverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRetrieverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRetriever");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRetrieverResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRetrieverResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRetrieverResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRetrieverRequest, DeleteRetrieverResponse>()
                            .withOperationName("DeleteRetriever").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRetrieverRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRetrieverRequest));
            CompletableFuture<DeleteRetrieverResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user by email id.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserRequest));
            CompletableFuture<DeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q web experience.
     * </p>
     *
     * @param deleteWebExperienceRequest
     * @return A Java Future containing the result of the DeleteWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWebExperienceResponse> deleteWebExperience(
            DeleteWebExperienceRequest deleteWebExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWebExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWebExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWebExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWebExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWebExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWebExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWebExperienceRequest, DeleteWebExperienceResponse>()
                            .withOperationName("DeleteWebExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWebExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWebExperienceRequest));
            CompletableFuture<DeleteWebExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q application.
     * </p>
     *
     * @param getApplicationRequest
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApplicationRequest, GetApplicationResponse>()
                            .withOperationName("GetApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApplicationRequest));
            CompletableFuture<GetApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an chat controls configured for an existing Amazon Q application.
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     * @return A Java Future containing the result of the GetChatControlsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetChatControlsConfigurationResponse> getChatControlsConfiguration(
            GetChatControlsConfigurationRequest getChatControlsConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getChatControlsConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChatControlsConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChatControlsConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetChatControlsConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetChatControlsConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetChatControlsConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetChatControlsConfigurationRequest, GetChatControlsConfigurationResponse>()
                            .withOperationName("GetChatControlsConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetChatControlsConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getChatControlsConfigurationRequest));
            CompletableFuture<GetChatControlsConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q data source connector.
     * </p>
     *
     * @param getDataSourceRequest
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDataSourceRequest, GetDataSourceResponse>()
                            .withOperationName("GetDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDataSourceRequest));
            CompletableFuture<GetDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a group by group name.
     * </p>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>().withOperationName("GetGroup")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGroupRequest));
            CompletableFuture<GetGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q index.
     * </p>
     *
     * @param getIndexRequest
     * @return A Java Future containing the result of the GetIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetIndexResponse> getIndex(GetIndexRequest getIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIndexRequest, GetIndexResponse>().withOperationName("GetIndex")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIndexRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getIndexRequest));
            CompletableFuture<GetIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q plugin.
     * </p>
     *
     * @param getPluginRequest
     * @return A Java Future containing the result of the GetPlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPlugin" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPluginResponse> getPlugin(GetPluginRequest getPluginRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPluginRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPlugin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPluginResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetPluginResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPluginResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPluginRequest, GetPluginResponse>().withOperationName("GetPlugin")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPluginRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPluginRequest));
            CompletableFuture<GetPluginResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an existing retriever used by an Amazon Q application.
     * </p>
     *
     * @param getRetrieverRequest
     * @return A Java Future containing the result of the GetRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRetrieverResponse> getRetriever(GetRetrieverRequest getRetrieverRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRetrieverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRetrieverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRetriever");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRetrieverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRetrieverResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRetrieverResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRetrieverRequest, GetRetrieverResponse>()
                            .withOperationName("GetRetriever").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRetrieverRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRetrieverRequest));
            CompletableFuture<GetRetrieverResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the universally unique identifier (UUID) associated with a local user in a data source.
     * </p>
     *
     * @param getUserRequest
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserRequest, GetUserResponse>().withOperationName("GetUser")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserRequest));
            CompletableFuture<GetUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q web experience.
     * </p>
     *
     * @param getWebExperienceRequest
     * @return A Java Future containing the result of the GetWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWebExperienceResponse> getWebExperience(GetWebExperienceRequest getWebExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWebExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWebExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWebExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWebExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWebExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWebExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWebExperienceRequest, GetWebExperienceResponse>()
                            .withOperationName("GetWebExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWebExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWebExperienceRequest));
            CompletableFuture<GetWebExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists Amazon Q applications.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListApplicationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListApplicationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListApplicationsRequest, ListApplicationsResponse>()
                            .withOperationName("ListApplications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListApplicationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listApplicationsRequest));
            CompletableFuture<ListApplicationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists one or more Amazon Q conversations.
     * </p>
     *
     * @param listConversationsRequest
     * @return A Java Future containing the result of the ListConversations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConversationsResponse> listConversations(ListConversationsRequest listConversationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConversationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConversationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConversations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConversationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConversationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConversationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConversationsRequest, ListConversationsResponse>()
                            .withOperationName("ListConversations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListConversationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listConversationsRequest));
            CompletableFuture<ListConversationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get information about an Amazon Q data source connector synchronization.
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return A Java Future containing the result of the ListDataSourceSyncJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDataSourceSyncJobsResponse> listDataSourceSyncJobs(
            ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataSourceSyncJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourceSyncJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSourceSyncJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDataSourceSyncJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDataSourceSyncJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDataSourceSyncJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDataSourceSyncJobsRequest, ListDataSourceSyncJobsResponse>()
                            .withOperationName("ListDataSourceSyncJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDataSourceSyncJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDataSourceSyncJobsRequest));
            CompletableFuture<ListDataSourceSyncJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Amazon Q data source connectors that you have created.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataSourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDataSourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDataSourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDataSourcesRequest, ListDataSourcesResponse>()
                            .withOperationName("ListDataSources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDataSourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDataSourcesRequest));
            CompletableFuture<ListDataSourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A list of documents attached to an index.
     * </p>
     *
     * @param listDocumentsRequest
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDocumentsResponse> listDocuments(ListDocumentsRequest listDocumentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDocumentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocuments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDocumentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDocumentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDocumentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDocumentsRequest, ListDocumentsResponse>()
                            .withOperationName("ListDocuments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDocumentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDocumentsRequest));
            CompletableFuture<ListDocumentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupsRequest));
            CompletableFuture<ListGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Amazon Q indices you have created.
     * </p>
     *
     * @param listIndicesRequest
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListIndicesResponse> listIndices(ListIndicesRequest listIndicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIndicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIndicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIndices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIndicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListIndicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIndicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIndicesRequest, ListIndicesResponse>()
                            .withOperationName("ListIndices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIndicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIndicesRequest));
            CompletableFuture<ListIndicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of messages associated with an Amazon Q web experience.
     * </p>
     *
     * @param listMessagesRequest
     * @return A Java Future containing the result of the ListMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMessagesResponse> listMessages(ListMessagesRequest listMessagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMessagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListMessagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMessagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMessagesRequest, ListMessagesResponse>()
                            .withOperationName("ListMessages").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMessagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMessagesRequest));
            CompletableFuture<ListMessagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists configured Amazon Q plugins.
     * </p>
     *
     * @param listPluginsRequest
     * @return A Java Future containing the result of the ListPlugins operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListPluginsResponse> listPlugins(ListPluginsRequest listPluginsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPluginsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPluginsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPlugins");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPluginsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListPluginsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPluginsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPluginsRequest, ListPluginsResponse>()
                            .withOperationName("ListPlugins").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPluginsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPluginsRequest));
            CompletableFuture<ListPluginsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the retriever used by an Amazon Q application.
     * </p>
     *
     * @param listRetrieversRequest
     * @return A Java Future containing the result of the ListRetrievers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRetrieversResponse> listRetrievers(ListRetrieversRequest listRetrieversRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRetrieversRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRetrieversRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRetrievers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRetrieversResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRetrieversResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRetrieversResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRetrieversRequest, ListRetrieversResponse>()
                            .withOperationName("ListRetrievers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRetrieversRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRetrieversRequest));
            CompletableFuture<ListRetrieversResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Amazon Q applications and data sources can have tags
     * associated with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists one or more Amazon Q Web Experiences.
     * </p>
     *
     * @param listWebExperiencesRequest
     * @return A Java Future containing the result of the ListWebExperiences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWebExperiencesResponse> listWebExperiences(ListWebExperiencesRequest listWebExperiencesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWebExperiencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWebExperiencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWebExperiences");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWebExperiencesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWebExperiencesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWebExperiencesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWebExperiencesRequest, ListWebExperiencesResponse>()
                            .withOperationName("ListWebExperiences").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWebExperiencesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWebExperiencesRequest));
            CompletableFuture<ListWebExperiencesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables your end user to to provide feedback on their Amazon Q generated chat responses.
     * </p>
     *
     * @param putFeedbackRequest
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutFeedbackResponse> putFeedback(PutFeedbackRequest putFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutFeedbackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutFeedbackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutFeedbackRequest, PutFeedbackResponse>()
                            .withOperationName("PutFeedback").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutFeedbackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putFeedbackRequest));
            CompletableFuture<PutFeedbackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create, or updates, a mapping of users—who have access to a document—to groups.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their Amazon Q chat results.
     * </p>
     *
     * @param putGroupRequest
     * @return A Java Future containing the result of the PutGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.PutGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutGroupResponse> putGroup(PutGroupRequest putGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutGroupRequest, PutGroupResponse>().withOperationName("PutGroup")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(putGroupRequest));
            CompletableFuture<PutGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a data source connector synchronization job. If a synchronization job is already in progress, Amazon Q
     * returns a <code>ConflictException</code>.
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     * @return A Java Future containing the result of the StartDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StartDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartDataSourceSyncJobResponse> startDataSourceSyncJob(
            StartDataSourceSyncJobRequest startDataSourceSyncJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDataSourceSyncJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDataSourceSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDataSourceSyncJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartDataSourceSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartDataSourceSyncJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartDataSourceSyncJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDataSourceSyncJobRequest, StartDataSourceSyncJobResponse>()
                            .withOperationName("StartDataSourceSyncJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartDataSourceSyncJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startDataSourceSyncJobRequest));
            CompletableFuture<StartDataSourceSyncJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an Amazon Q data source connector synchronization job already in progress.
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     * @return A Java Future containing the result of the StopDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StopDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopDataSourceSyncJobResponse> stopDataSourceSyncJob(
            StopDataSourceSyncJobRequest stopDataSourceSyncJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopDataSourceSyncJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDataSourceSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDataSourceSyncJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopDataSourceSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopDataSourceSyncJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopDataSourceSyncJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDataSourceSyncJobRequest, StopDataSourceSyncJobResponse>()
                            .withOperationName("StopDataSourceSyncJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopDataSourceSyncJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopDataSourceSyncJobRequest));
            CompletableFuture<StopDataSourceSyncJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified tag to the specified Amazon Q application or data source resource. If the tag already exists,
     * the existing value is replaced with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from an Amazon Q application or a data source.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Q application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApplicationRequest, UpdateApplicationResponse>()
                            .withOperationName("UpdateApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateApplicationRequest));
            CompletableFuture<UpdateApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an set of chat controls configured for an existing Amazon Q application.
     * </p>
     *
     * @param updateChatControlsConfigurationRequest
     * @return A Java Future containing the result of the UpdateChatControlsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateChatControlsConfigurationResponse> updateChatControlsConfiguration(
            UpdateChatControlsConfigurationRequest updateChatControlsConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChatControlsConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateChatControlsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChatControlsConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateChatControlsConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateChatControlsConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateChatControlsConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateChatControlsConfigurationRequest, UpdateChatControlsConfigurationResponse>()
                            .withOperationName("UpdateChatControlsConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateChatControlsConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateChatControlsConfigurationRequest));
            CompletableFuture<UpdateChatControlsConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Q data source connector.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDataSourceRequest, UpdateDataSourceResponse>()
                            .withOperationName("UpdateDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDataSourceRequest));
            CompletableFuture<UpdateDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Q index.
     * </p>
     *
     * @param updateIndexRequest
     * @return A Java Future containing the result of the UpdateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIndexResponse> updateIndex(UpdateIndexRequest updateIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIndexRequest, UpdateIndexResponse>()
                            .withOperationName("UpdateIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIndexRequest));
            CompletableFuture<UpdateIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Q plugin.
     * </p>
     *
     * @param updatePluginRequest
     * @return A Java Future containing the result of the UpdatePlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePluginResponse> updatePlugin(UpdatePluginRequest updatePluginRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePluginRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePlugin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePluginResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdatePluginResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePluginResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePluginRequest, UpdatePluginResponse>()
                            .withOperationName("UpdatePlugin").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePluginRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePluginRequest));
            CompletableFuture<UpdatePluginResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the retriever used for your Amazon Q application.
     * </p>
     *
     * @param updateRetrieverRequest
     * @return A Java Future containing the result of the UpdateRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRetrieverResponse> updateRetriever(UpdateRetrieverRequest updateRetrieverRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRetrieverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRetrieverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRetriever");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRetrieverResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRetrieverResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRetrieverResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRetrieverRequest, UpdateRetrieverResponse>()
                            .withOperationName("UpdateRetriever").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRetrieverRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRetrieverRequest));
            CompletableFuture<UpdateRetrieverResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a information associated with a user id.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserRequest, UpdateUserResponse>().withOperationName("UpdateUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserRequest));
            CompletableFuture<UpdateUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Q web experience.
     * </p>
     *
     * @param updateWebExperienceRequest
     * @return A Java Future containing the result of the UpdateWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Make sure you have provided the
     *         correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q service.
     *         Wait some minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     *         help.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistences with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q service. Provide the
     *         correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWebExperienceResponse> updateWebExperience(
            UpdateWebExperienceRequest updateWebExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWebExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWebExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWebExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWebExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWebExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateWebExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWebExperienceRequest, UpdateWebExperienceResponse>()
                            .withOperationName("UpdateWebExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWebExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWebExperienceRequest));
            CompletableFuture<UpdateWebExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final QBusinessServiceClientConfiguration serviceClientConfiguration() {
        return new QBusinessServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(QBusinessException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LicenseNotFoundException")
                                .exceptionBuilderSupplier(LicenseNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        QBusinessServiceClientConfigurationBuilder serviceConfigBuilder = new QBusinessServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
