/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.qbusiness.model.AccessDeniedException;
import software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentRequest;
import software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentResponse;
import software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentRequest;
import software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentResponse;
import software.amazon.awssdk.services.qbusiness.model.ChatSyncRequest;
import software.amazon.awssdk.services.qbusiness.model.ChatSyncResponse;
import software.amazon.awssdk.services.qbusiness.model.ConflictException;
import software.amazon.awssdk.services.qbusiness.model.CreateApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.CreatePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.CreatePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteConversationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteConversationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.DeletePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.DeletePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.GetApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.GetDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.GetGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.GetGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.GetIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.GetIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.GetPluginRequest;
import software.amazon.awssdk.services.qbusiness.model.GetPluginResponse;
import software.amazon.awssdk.services.qbusiness.model.GetRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.GetRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.GetUserRequest;
import software.amazon.awssdk.services.qbusiness.model.GetUserResponse;
import software.amazon.awssdk.services.qbusiness.model.GetWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.GetWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.InternalServerException;
import software.amazon.awssdk.services.qbusiness.model.LicenseNotFoundException;
import software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse;
import software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse;
import software.amazon.awssdk.services.qbusiness.model.PutFeedbackRequest;
import software.amazon.awssdk.services.qbusiness.model.PutFeedbackResponse;
import software.amazon.awssdk.services.qbusiness.model.PutGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.PutGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.QBusinessException;
import software.amazon.awssdk.services.qbusiness.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qbusiness.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobRequest;
import software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobResponse;
import software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobRequest;
import software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobResponse;
import software.amazon.awssdk.services.qbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.ThrottlingException;
import software.amazon.awssdk.services.qbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdatePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdatePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateUserRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateUserResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.ValidationException;
import software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListConversationsIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListGroupsIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListIndicesIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListMessagesIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListPluginsIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversIterable;
import software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesIterable;

/**
 * Service client for accessing QBusiness. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface QBusinessClient extends AwsClient {
    String SERVICE_NAME = "qbusiness";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "qbusiness";

    /**
     * <p>
     * Asynchronously deletes one or more documents added using the <code>BatchPutDocument</code> API from an Amazon Q
     * index.
     * </p>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     *
     * @param batchDeleteDocumentRequest
     * @return Result of the BatchDeleteDocument operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteDocumentResponse batchDeleteDocument(BatchDeleteDocumentRequest batchDeleteDocumentRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Asynchronously deletes one or more documents added using the <code>BatchPutDocument</code> API from an Amazon Q
     * index.
     * </p>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDocumentRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteDocumentRequest#builder()}
     * </p>
     *
     * @param batchDeleteDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteDocument operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteDocumentResponse batchDeleteDocument(
            Consumer<BatchDeleteDocumentRequest.Builder> batchDeleteDocumentRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        return batchDeleteDocument(BatchDeleteDocumentRequest.builder().applyMutation(batchDeleteDocumentRequest).build());
    }

    /**
     * <p>
     * Adds one or more documents to an Amazon Q index.
     * </p>
     * <p>
     * You use this API to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ingest your structured and unstructured documents and documents stored in an Amazon S3 bucket into an Amazon Q
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * add custom attributes to documents in an Amazon Q index.
     * </p>
     * </li>
     * <li>
     * <p>
     * attach an access control list to the documents added to an Amazon Q index.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     *
     * @param batchPutDocumentRequest
     * @return Result of the BatchPutDocument operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchPutDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchPutDocumentResponse batchPutDocument(BatchPutDocumentRequest batchPutDocumentRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more documents to an Amazon Q index.
     * </p>
     * <p>
     * You use this API to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ingest your structured and unstructured documents and documents stored in an Amazon S3 bucket into an Amazon Q
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * add custom attributes to documents in an Amazon Q index.
     * </p>
     * </li>
     * <li>
     * <p>
     * attach an access control list to the documents added to an Amazon Q index.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutDocumentRequest#builder()}
     * </p>
     *
     * @param batchPutDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentRequest.Builder} to create a
     *        request.
     * @return Result of the BatchPutDocument operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchPutDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchPutDocumentResponse batchPutDocument(Consumer<BatchPutDocumentRequest.Builder> batchPutDocumentRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return batchPutDocument(BatchPutDocumentRequest.builder().applyMutation(batchPutDocumentRequest).build());
    }

    /**
     * <p>
     * Starts or continues a non-streaming Amazon Q conversation.
     * </p>
     *
     * @param chatSyncRequest
     * @return Result of the ChatSync operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ChatSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ChatSync" target="_top">AWS API
     *      Documentation</a>
     */
    default ChatSyncResponse chatSync(ChatSyncRequest chatSyncRequest) throws ResourceNotFoundException, InternalServerException,
            LicenseNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts or continues a non-streaming Amazon Q conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChatSyncRequest.Builder} avoiding the need to
     * create one manually via {@link ChatSyncRequest#builder()}
     * </p>
     *
     * @param chatSyncRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ChatSyncRequest.Builder} to create a request.
     * @return Result of the ChatSync operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ChatSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ChatSync" target="_top">AWS API
     *      Documentation</a>
     */
    default ChatSyncResponse chatSync(Consumer<ChatSyncRequest.Builder> chatSyncRequest) throws ResourceNotFoundException,
            InternalServerException, LicenseNotFoundException, ConflictException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return chatSync(ChatSyncRequest.builder().applyMutation(chatSyncRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q application.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a data source connector for an Amazon Q application.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data source connector for an Amazon Q application.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateDataSourceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q index.
     * </p>
     * <p>
     * To determine if index creation has completed, check the <code>Status</code> field returned from a call to
     * <code>DescribeIndex</code>. The <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready
     * to use.
     * </p>
     * <p>
     * Once the index is active, you can index your documents using the <a
     * href="https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_BatchPutDocument.html">
     * <code>BatchPutDocument</code> </a> API or the <a
     * href="https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_CreateDataSource.html">
     * <code>CreateDataSource</code> </a> API.
     * </p>
     *
     * @param createIndexRequest
     * @return Result of the CreateIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q index.
     * </p>
     * <p>
     * To determine if index creation has completed, check the <code>Status</code> field returned from a call to
     * <code>DescribeIndex</code>. The <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready
     * to use.
     * </p>
     * <p>
     * Once the index is active, you can index your documents using the <a
     * href="https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_BatchPutDocument.html">
     * <code>BatchPutDocument</code> </a> API or the <a
     * href="https://docs.aws.amazon.com/enterpriseq/latest/APIReference/API_CreateDataSource.html">
     * <code>CreateDataSource</code> </a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateIndexRequest.Builder} to create a request.
     * @return Result of the CreateIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIndexResponse createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q plugin.
     * </p>
     *
     * @param createPluginRequest
     * @return Result of the CreatePlugin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePluginResponse createPlugin(CreatePluginRequest createPluginRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePluginRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePluginRequest#builder()}
     * </p>
     *
     * @param createPluginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreatePluginRequest.Builder} to create a request.
     * @return Result of the CreatePlugin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePluginResponse createPlugin(Consumer<CreatePluginRequest.Builder> createPluginRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return createPlugin(CreatePluginRequest.builder().applyMutation(createPluginRequest).build());
    }

    /**
     * <p>
     * Adds a retriever to your Amazon Q application.
     * </p>
     *
     * @param createRetrieverRequest
     * @return Result of the CreateRetriever operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRetrieverResponse createRetriever(CreateRetrieverRequest createRetrieverRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a retriever to your Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRetrieverRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRetrieverRequest#builder()}
     * </p>
     *
     * @param createRetrieverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateRetrieverRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRetriever operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRetrieverResponse createRetriever(Consumer<CreateRetrieverRequest.Builder> createRetrieverRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return createRetriever(CreateRetrieverRequest.builder().applyMutation(createRetrieverRequest).build());
    }

    /**
     * <p>
     * Creates a universally unique identifier (UUID) mapped to a list of local user ids within an application.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a universally unique identifier (UUID) mapped to a list of local user ids within an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q web experience.
     * </p>
     *
     * @param createWebExperienceRequest
     * @return Result of the CreateWebExperience operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWebExperienceResponse createWebExperience(CreateWebExperienceRequest createWebExperienceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWebExperienceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWebExperienceRequest#builder()}
     * </p>
     *
     * @param createWebExperienceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWebExperience operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWebExperienceResponse createWebExperience(
            Consumer<CreateWebExperienceRequest.Builder> createWebExperienceRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        return createWebExperience(CreateWebExperienceRequest.builder().applyMutation(createWebExperienceRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes chat controls configured for an existing Amazon Q application.
     * </p>
     *
     * @param deleteChatControlsConfigurationRequest
     * @return Result of the DeleteChatControlsConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChatControlsConfigurationResponse deleteChatControlsConfiguration(
            DeleteChatControlsConfigurationRequest deleteChatControlsConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes chat controls configured for an existing Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChatControlsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteChatControlsConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteChatControlsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteChatControlsConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChatControlsConfigurationResponse deleteChatControlsConfiguration(
            Consumer<DeleteChatControlsConfigurationRequest.Builder> deleteChatControlsConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return deleteChatControlsConfiguration(DeleteChatControlsConfigurationRequest.builder()
                .applyMutation(deleteChatControlsConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q web experience conversation.
     * </p>
     *
     * @param deleteConversationRequest
     * @return Result of the DeleteConversation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteConversation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteConversation" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConversationResponse deleteConversation(DeleteConversationRequest deleteConversationRequest)
            throws ResourceNotFoundException, InternalServerException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q web experience conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConversationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConversationRequest#builder()}
     * </p>
     *
     * @param deleteConversationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteConversationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConversation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteConversation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteConversation" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConversationResponse deleteConversation(Consumer<DeleteConversationRequest.Builder> deleteConversationRequest)
            throws ResourceNotFoundException, InternalServerException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return deleteConversation(DeleteConversationRequest.builder().applyMutation(deleteConversationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q data source connector. While the data source is being deleted, the <code>Status</code> field
     * returned by a call to the <code>DescribeDataSource</code> API is set to <code>DELETING</code>.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q data source connector. While the data source is being deleted, the <code>Status</code> field
     * returned by a call to the <code>DescribeDataSource</code> API is set to <code>DELETING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group. For example, after deleting the group "Summer Interns", all interns who belonged to that
     * group no longer see intern-only documents in their chat results.
     * </p>
     * <p>
     * If you want to delete, update, or replace users or sub groups of a group, you need to use the
     * <code>PutGroup</code> operation. For example, if a user in the group "Engineering" leaves the engineering team
     * and another user takes their place, you provide an updated list of users or sub groups that belong to the
     * "Engineering" group when calling <code>PutGroup</code>.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group. For example, after deleting the group "Summer Interns", all interns who belonged to that
     * group no longer see intern-only documents in their chat results.
     * </p>
     * <p>
     * If you want to delete, update, or replace users or sub groups of a group, you need to use the
     * <code>PutGroup</code> operation. For example, if a user in the group "Engineering" leaves the engineering team
     * and another user takes their place, you provide an updated list of users or sub groups that belong to the
     * "Engineering" group when calling <code>PutGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteGroupRequest.Builder} to create a request.
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q index.
     * </p>
     *
     * @param deleteIndexRequest
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIndexRequest#builder()}
     * </p>
     *
     * @param deleteIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteIndexRequest.Builder} to create a request.
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return deleteIndex(DeleteIndexRequest.builder().applyMutation(deleteIndexRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q plugin.
     * </p>
     *
     * @param deletePluginRequest
     * @return Result of the DeletePlugin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeletePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeletePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePluginResponse deletePlugin(DeletePluginRequest deletePluginRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePluginRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePluginRequest#builder()}
     * </p>
     *
     * @param deletePluginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeletePluginRequest.Builder} to create a request.
     * @return Result of the DeletePlugin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeletePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeletePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePluginResponse deletePlugin(Consumer<DeletePluginRequest.Builder> deletePluginRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return deletePlugin(DeletePluginRequest.builder().applyMutation(deletePluginRequest).build());
    }

    /**
     * <p>
     * Deletes the retriever used by an Amazon Q application.
     * </p>
     *
     * @param deleteRetrieverRequest
     * @return Result of the DeleteRetriever operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRetrieverResponse deleteRetriever(DeleteRetrieverRequest deleteRetrieverRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the retriever used by an Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRetrieverRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRetrieverRequest#builder()}
     * </p>
     *
     * @param deleteRetrieverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRetriever operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRetrieverResponse deleteRetriever(Consumer<DeleteRetrieverRequest.Builder> deleteRetrieverRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return deleteRetriever(DeleteRetrieverRequest.builder().applyMutation(deleteRetrieverRequest).build());
    }

    /**
     * <p>
     * Deletes a user by email id.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user by email id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q web experience.
     * </p>
     *
     * @param deleteWebExperienceRequest
     * @return Result of the DeleteWebExperience operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteWebExperienceResponse deleteWebExperience(DeleteWebExperienceRequest deleteWebExperienceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWebExperienceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWebExperienceRequest#builder()}
     * </p>
     *
     * @param deleteWebExperienceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWebExperience operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteWebExperienceResponse deleteWebExperience(
            Consumer<DeleteWebExperienceRequest.Builder> deleteWebExperienceRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        return deleteWebExperience(DeleteWebExperienceRequest.builder().applyMutation(deleteWebExperienceRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q application.
     * </p>
     *
     * @param getApplicationRequest
     * @return Result of the GetApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetApplicationRequest.Builder} to create a request.
     * @return Result of the GetApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApplicationResponse getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Gets information about an chat controls configured for an existing Amazon Q application.
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     * @return Result of the GetChatControlsConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChatControlsConfigurationResponse getChatControlsConfiguration(
            GetChatControlsConfigurationRequest getChatControlsConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an chat controls configured for an existing Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChatControlsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetChatControlsConfigurationRequest#builder()}
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetChatControlsConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChatControlsConfigurationResponse getChatControlsConfiguration(
            Consumer<GetChatControlsConfigurationRequest.Builder> getChatControlsConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return getChatControlsConfiguration(GetChatControlsConfigurationRequest.builder()
                .applyMutation(getChatControlsConfigurationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getChatControlsConfiguration(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationIterable responses = client.getChatControlsConfigurationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationIterable responses = client
     *             .getChatControlsConfigurationPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationIterable responses = client.getChatControlsConfigurationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChatControlsConfiguration(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest)}
     * operation.</b>
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChatControlsConfigurationIterable getChatControlsConfigurationPaginator(
            GetChatControlsConfigurationRequest getChatControlsConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return new GetChatControlsConfigurationIterable(this, getChatControlsConfigurationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getChatControlsConfiguration(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationIterable responses = client.getChatControlsConfigurationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationIterable responses = client
     *             .getChatControlsConfigurationPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationIterable responses = client.getChatControlsConfigurationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChatControlsConfiguration(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChatControlsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetChatControlsConfigurationRequest#builder()}
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChatControlsConfigurationIterable getChatControlsConfigurationPaginator(
            Consumer<GetChatControlsConfigurationRequest.Builder> getChatControlsConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return getChatControlsConfigurationPaginator(GetChatControlsConfigurationRequest.builder()
                .applyMutation(getChatControlsConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q data source connector.
     * </p>
     *
     * @param getDataSourceRequest
     * @return Result of the GetDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q data source connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetDataSourceRequest.Builder} to create a request.
     * @return Result of the GetDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSourceResponse getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * Describes a group by group name.
     * </p>
     *
     * @param getGroupRequest
     * @return Result of the GetGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a group by group name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetGroupRequest.Builder} to create a request.
     * @return Result of the GetGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q index.
     * </p>
     *
     * @param getIndexRequest
     * @return Result of the GetIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIndexResponse getIndex(GetIndexRequest getIndexRequest) throws ResourceNotFoundException, InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIndexRequest.Builder} avoiding the need to
     * create one manually via {@link GetIndexRequest#builder()}
     * </p>
     *
     * @param getIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetIndexRequest.Builder} to create a request.
     * @return Result of the GetIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIndexResponse getIndex(Consumer<GetIndexRequest.Builder> getIndexRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return getIndex(GetIndexRequest.builder().applyMutation(getIndexRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q plugin.
     * </p>
     *
     * @param getPluginRequest
     * @return Result of the GetPlugin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPluginResponse getPlugin(GetPluginRequest getPluginRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPluginRequest.Builder} avoiding the need to
     * create one manually via {@link GetPluginRequest#builder()}
     * </p>
     *
     * @param getPluginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetPluginRequest.Builder} to create a request.
     * @return Result of the GetPlugin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPluginResponse getPlugin(Consumer<GetPluginRequest.Builder> getPluginRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return getPlugin(GetPluginRequest.builder().applyMutation(getPluginRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing retriever used by an Amazon Q application.
     * </p>
     *
     * @param getRetrieverRequest
     * @return Result of the GetRetriever operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRetrieverResponse getRetriever(GetRetrieverRequest getRetrieverRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing retriever used by an Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRetrieverRequest.Builder} avoiding the need to
     * create one manually via {@link GetRetrieverRequest#builder()}
     * </p>
     *
     * @param getRetrieverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetRetrieverRequest.Builder} to create a request.
     * @return Result of the GetRetriever operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRetrieverResponse getRetriever(Consumer<GetRetrieverRequest.Builder> getRetrieverRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return getRetriever(GetRetrieverRequest.builder().applyMutation(getRetrieverRequest).build());
    }

    /**
     * <p>
     * Describes the universally unique identifier (UUID) associated with a local user in a data source.
     * </p>
     *
     * @param getUserRequest
     * @return Result of the GetUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserResponse getUser(GetUserRequest getUserRequest) throws ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the universally unique identifier (UUID) associated with a local user in a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserRequest.Builder} avoiding the need to create
     * one manually via {@link GetUserRequest#builder()}
     * </p>
     *
     * @param getUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetUserRequest.Builder} to create a request.
     * @return Result of the GetUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserResponse getUser(Consumer<GetUserRequest.Builder> getUserRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        return getUser(GetUserRequest.builder().applyMutation(getUserRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q web experience.
     * </p>
     *
     * @param getWebExperienceRequest
     * @return Result of the GetWebExperience operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWebExperienceResponse getWebExperience(GetWebExperienceRequest getWebExperienceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWebExperienceRequest.Builder} avoiding the need
     * to create one manually via {@link GetWebExperienceRequest#builder()}
     * </p>
     *
     * @param getWebExperienceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetWebExperienceRequest.Builder} to create a
     *        request.
     * @return Result of the GetWebExperience operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWebExperienceResponse getWebExperience(Consumer<GetWebExperienceRequest.Builder> getWebExperienceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return getWebExperience(GetWebExperienceRequest.builder().applyMutation(getWebExperienceRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Q applications.
     * </p>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Q applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListApplications operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest)} operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return new ListApplicationsIterable(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists one or more Amazon Q conversations.
     * </p>
     *
     * @param listConversationsRequest
     * @return Result of the ListConversations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConversationsResponse listConversations(ListConversationsRequest listConversationsRequest)
            throws ResourceNotFoundException, InternalServerException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more Amazon Q conversations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConversationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConversationsRequest#builder()}
     * </p>
     *
     * @param listConversationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListConversations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConversationsResponse listConversations(Consumer<ListConversationsRequest.Builder> listConversationsRequest)
            throws ResourceNotFoundException, InternalServerException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listConversations(ListConversationsRequest.builder().applyMutation(listConversationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConversations(software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListConversationsIterable responses = client.listConversationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListConversationsIterable responses = client
     *             .listConversationsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListConversationsIterable responses = client.listConversationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConversations(software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConversationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConversationsIterable listConversationsPaginator(ListConversationsRequest listConversationsRequest)
            throws ResourceNotFoundException, InternalServerException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return new ListConversationsIterable(this, listConversationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConversations(software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListConversationsIterable responses = client.listConversationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListConversationsIterable responses = client
     *             .listConversationsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListConversationsIterable responses = client.listConversationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConversations(software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConversationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConversationsRequest#builder()}
     * </p>
     *
     * @param listConversationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConversationsIterable listConversationsPaginator(
            Consumer<ListConversationsRequest.Builder> listConversationsRequest) throws ResourceNotFoundException,
            InternalServerException, LicenseNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        return listConversationsPaginator(ListConversationsRequest.builder().applyMutation(listConversationsRequest).build());
    }

    /**
     * <p>
     * Get information about an Amazon Q data source connector synchronization.
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return Result of the ListDataSourceSyncJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceSyncJobsResponse listDataSourceSyncJobs(ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about an Amazon Q data source connector synchronization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceSyncJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceSyncJobsRequest#builder()}
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDataSourceSyncJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceSyncJobsResponse listDataSourceSyncJobs(
            Consumer<ListDataSourceSyncJobsRequest.Builder> listDataSourceSyncJobsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return listDataSourceSyncJobs(ListDataSourceSyncJobsRequest.builder().applyMutation(listDataSourceSyncJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsIterable responses = client.listDataSourceSyncJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsIterable responses = client
     *             .listDataSourceSyncJobsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsIterable responses = client.listDataSourceSyncJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceSyncJobsIterable listDataSourceSyncJobsPaginator(
            ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return new ListDataSourceSyncJobsIterable(this, listDataSourceSyncJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsIterable responses = client.listDataSourceSyncJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsIterable responses = client
     *             .listDataSourceSyncJobsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsIterable responses = client.listDataSourceSyncJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceSyncJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceSyncJobsRequest#builder()}
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceSyncJobsIterable listDataSourceSyncJobsPaginator(
            Consumer<ListDataSourceSyncJobsRequest.Builder> listDataSourceSyncJobsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return listDataSourceSyncJobsPaginator(ListDataSourceSyncJobsRequest.builder()
                .applyMutation(listDataSourceSyncJobsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Q data source connectors that you have created.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return Result of the ListDataSources operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Q data source connectors that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDataSources operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return new ListDataSourcesIterable(this, listDataSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * A list of documents attached to an index.
     * </p>
     *
     * @param listDocumentsRequest
     * @return Result of the ListDocuments operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsResponse listDocuments(ListDocumentsRequest listDocumentsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of documents attached to an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDocumentsRequest#builder()}
     * </p>
     *
     * @param listDocumentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest.Builder} to create a request.
     * @return Result of the ListDocuments operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsResponse listDocuments(Consumer<ListDocumentsRequest.Builder> listDocumentsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listDocuments(ListDocumentsRequest.builder().applyMutation(listDocumentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest)} operation.</b>
     * </p>
     *
     * @param listDocumentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsIterable listDocumentsPaginator(ListDocumentsRequest listDocumentsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return new ListDocumentsIterable(this, listDocumentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDocumentsRequest#builder()}
     * </p>
     *
     * @param listDocumentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsIterable listDocumentsPaginator(Consumer<ListDocumentsRequest.Builder> listDocumentsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listDocumentsPaginator(ListDocumentsRequest.builder().applyMutation(listDocumentsRequest).build());
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest.Builder} to create a request.
     * @return Result of the ListGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsIterable listGroupsPaginator(ListGroupsRequest listGroupsRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        return new ListGroupsIterable(this, listGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsIterable listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Q indices you have created.
     * </p>
     *
     * @param listIndicesRequest
     * @return Result of the ListIndices operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesResponse listIndices(ListIndicesRequest listIndicesRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Q indices you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest.Builder} to create a request.
     * @return Result of the ListIndices operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesResponse listIndices(Consumer<ListIndicesRequest.Builder> listIndicesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listIndices(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest)} operation.</b>
     * </p>
     *
     * @param listIndicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesIterable listIndicesPaginator(ListIndicesRequest listIndicesRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return new ListIndicesIterable(this, listIndicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesIterable listIndicesPaginator(Consumer<ListIndicesRequest.Builder> listIndicesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listIndicesPaginator(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * Gets a list of messages associated with an Amazon Q web experience.
     * </p>
     *
     * @param listMessagesRequest
     * @return Result of the ListMessages operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMessagesResponse listMessages(ListMessagesRequest listMessagesRequest) throws ResourceNotFoundException,
            InternalServerException, LicenseNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of messages associated with an Amazon Q web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMessagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMessagesRequest#builder()}
     * </p>
     *
     * @param listMessagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest.Builder} to create a request.
     * @return Result of the ListMessages operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMessagesResponse listMessages(Consumer<ListMessagesRequest.Builder> listMessagesRequest)
            throws ResourceNotFoundException, InternalServerException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listMessages(ListMessagesRequest.builder().applyMutation(listMessagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMessages(software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListMessagesIterable responses = client.listMessagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListMessagesIterable responses = client.listMessagesPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListMessagesIterable responses = client.listMessagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMessages(software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest)} operation.</b>
     * </p>
     *
     * @param listMessagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMessagesIterable listMessagesPaginator(ListMessagesRequest listMessagesRequest) throws ResourceNotFoundException,
            InternalServerException, LicenseNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        return new ListMessagesIterable(this, listMessagesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMessages(software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListMessagesIterable responses = client.listMessagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListMessagesIterable responses = client.listMessagesPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListMessagesIterable responses = client.listMessagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMessages(software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMessagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMessagesRequest#builder()}
     * </p>
     *
     * @param listMessagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMessagesIterable listMessagesPaginator(Consumer<ListMessagesRequest.Builder> listMessagesRequest)
            throws ResourceNotFoundException, InternalServerException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listMessagesPaginator(ListMessagesRequest.builder().applyMutation(listMessagesRequest).build());
    }

    /**
     * <p>
     * Lists configured Amazon Q plugins.
     * </p>
     *
     * @param listPluginsRequest
     * @return Result of the ListPlugins operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPluginsResponse listPlugins(ListPluginsRequest listPluginsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists configured Amazon Q plugins.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPluginsRequest#builder()}
     * </p>
     *
     * @param listPluginsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest.Builder} to create a request.
     * @return Result of the ListPlugins operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPluginsResponse listPlugins(Consumer<ListPluginsRequest.Builder> listPluginsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listPlugins(ListPluginsRequest.builder().applyMutation(listPluginsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPlugins(software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlugins(software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest)} operation.</b>
     * </p>
     *
     * @param listPluginsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPluginsIterable listPluginsPaginator(ListPluginsRequest listPluginsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return new ListPluginsIterable(this, listPluginsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPlugins(software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlugins(software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPluginsRequest#builder()}
     * </p>
     *
     * @param listPluginsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPluginsIterable listPluginsPaginator(Consumer<ListPluginsRequest.Builder> listPluginsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listPluginsPaginator(ListPluginsRequest.builder().applyMutation(listPluginsRequest).build());
    }

    /**
     * <p>
     * Lists the retriever used by an Amazon Q application.
     * </p>
     *
     * @param listRetrieversRequest
     * @return Result of the ListRetrievers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRetrieversResponse listRetrievers(ListRetrieversRequest listRetrieversRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the retriever used by an Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRetrieversRequest.Builder} avoiding the need to
     * create one manually via {@link ListRetrieversRequest#builder()}
     * </p>
     *
     * @param listRetrieversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest.Builder} to create a request.
     * @return Result of the ListRetrievers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRetrieversResponse listRetrievers(Consumer<ListRetrieversRequest.Builder> listRetrieversRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listRetrievers(ListRetrieversRequest.builder().applyMutation(listRetrieversRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRetrievers(software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversIterable responses = client.listRetrieversPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversIterable responses = client
     *             .listRetrieversPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversIterable responses = client.listRetrieversPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRetrievers(software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest)} operation.</b>
     * </p>
     *
     * @param listRetrieversRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRetrieversIterable listRetrieversPaginator(ListRetrieversRequest listRetrieversRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return new ListRetrieversIterable(this, listRetrieversRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRetrievers(software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversIterable responses = client.listRetrieversPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversIterable responses = client
     *             .listRetrieversPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversIterable responses = client.listRetrieversPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRetrievers(software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRetrieversRequest.Builder} avoiding the need to
     * create one manually via {@link ListRetrieversRequest#builder()}
     * </p>
     *
     * @param listRetrieversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRetrieversIterable listRetrieversPaginator(Consumer<ListRetrieversRequest.Builder> listRetrieversRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listRetrieversPaginator(ListRetrieversRequest.builder().applyMutation(listRetrieversRequest).build());
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Amazon Q applications and data sources can have tags
     * associated with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Amazon Q applications and data sources can have tags
     * associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists one or more Amazon Q Web Experiences.
     * </p>
     *
     * @param listWebExperiencesRequest
     * @return Result of the ListWebExperiences operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWebExperiencesResponse listWebExperiences(ListWebExperiencesRequest listWebExperiencesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more Amazon Q Web Experiences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebExperiencesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWebExperiencesRequest#builder()}
     * </p>
     *
     * @param listWebExperiencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest.Builder} to create a
     *        request.
     * @return Result of the ListWebExperiences operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWebExperiencesResponse listWebExperiences(Consumer<ListWebExperiencesRequest.Builder> listWebExperiencesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return listWebExperiences(ListWebExperiencesRequest.builder().applyMutation(listWebExperiencesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebExperiences(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesIterable responses = client.listWebExperiencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesIterable responses = client
     *             .listWebExperiencesPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesIterable responses = client.listWebExperiencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebExperiences(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWebExperiencesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWebExperiencesIterable listWebExperiencesPaginator(ListWebExperiencesRequest listWebExperiencesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return new ListWebExperiencesIterable(this, listWebExperiencesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebExperiences(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesIterable responses = client.listWebExperiencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesIterable responses = client
     *             .listWebExperiencesPaginator(request);
     *     for (software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesIterable responses = client.listWebExperiencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebExperiences(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebExperiencesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWebExperiencesRequest#builder()}
     * </p>
     *
     * @param listWebExperiencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWebExperiencesIterable listWebExperiencesPaginator(
            Consumer<ListWebExperiencesRequest.Builder> listWebExperiencesRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return listWebExperiencesPaginator(ListWebExperiencesRequest.builder().applyMutation(listWebExperiencesRequest).build());
    }

    /**
     * <p>
     * Enables your end user to to provide feedback on their Amazon Q generated chat responses.
     * </p>
     *
     * @param putFeedbackRequest
     * @return Result of the PutFeedback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables your end user to to provide feedback on their Amazon Q generated chat responses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link PutFeedbackRequest#builder()}
     * </p>
     *
     * @param putFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.PutFeedbackRequest.Builder} to create a request.
     * @return Result of the PutFeedback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default PutFeedbackResponse putFeedback(Consumer<PutFeedbackRequest.Builder> putFeedbackRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return putFeedback(PutFeedbackRequest.builder().applyMutation(putFeedbackRequest).build());
    }

    /**
     * <p>
     * Create, or updates, a mapping of users—who have access to a document—to groups.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their Amazon Q chat results.
     * </p>
     *
     * @param putGroupRequest
     * @return Result of the PutGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.PutGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default PutGroupResponse putGroup(PutGroupRequest putGroupRequest) throws ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create, or updates, a mapping of users—who have access to a document—to groups.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their Amazon Q chat results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutGroupRequest.Builder} avoiding the need to
     * create one manually via {@link PutGroupRequest#builder()}
     * </p>
     *
     * @param putGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.PutGroupRequest.Builder} to create a request.
     * @return Result of the PutGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.PutGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default PutGroupResponse putGroup(Consumer<PutGroupRequest.Builder> putGroupRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        return putGroup(PutGroupRequest.builder().applyMutation(putGroupRequest).build());
    }

    /**
     * <p>
     * Starts a data source connector synchronization job. If a synchronization job is already in progress, Amazon Q
     * returns a <code>ConflictException</code>.
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     * @return Result of the StartDataSourceSyncJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StartDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDataSourceSyncJobResponse startDataSourceSyncJob(StartDataSourceSyncJobRequest startDataSourceSyncJobRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a data source connector synchronization job. If a synchronization job is already in progress, Amazon Q
     * returns a <code>ConflictException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataSourceSyncJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataSourceSyncJobRequest#builder()}
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartDataSourceSyncJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StartDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDataSourceSyncJobResponse startDataSourceSyncJob(
            Consumer<StartDataSourceSyncJobRequest.Builder> startDataSourceSyncJobRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        return startDataSourceSyncJob(StartDataSourceSyncJobRequest.builder().applyMutation(startDataSourceSyncJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an Amazon Q data source connector synchronization job already in progress.
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     * @return Result of the StopDataSourceSyncJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StopDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopDataSourceSyncJobResponse stopDataSourceSyncJob(StopDataSourceSyncJobRequest stopDataSourceSyncJobRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an Amazon Q data source connector synchronization job already in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDataSourceSyncJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopDataSourceSyncJobRequest#builder()}
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopDataSourceSyncJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StopDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopDataSourceSyncJobResponse stopDataSourceSyncJob(
            Consumer<StopDataSourceSyncJobRequest.Builder> stopDataSourceSyncJobRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        return stopDataSourceSyncJob(StopDataSourceSyncJobRequest.builder().applyMutation(stopDataSourceSyncJobRequest).build());
    }

    /**
     * <p>
     * Adds the specified tag to the specified Amazon Q application or data source resource. If the tag already exists,
     * the existing value is replaced with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tag to the specified Amazon Q application or data source resource. If the tag already exists,
     * the existing value is replaced with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from an Amazon Q application or a data source.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from an Amazon Q application or a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Q application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates an set of chat controls configured for an existing Amazon Q application.
     * </p>
     *
     * @param updateChatControlsConfigurationRequest
     * @return Result of the UpdateChatControlsConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChatControlsConfigurationResponse updateChatControlsConfiguration(
            UpdateChatControlsConfigurationRequest updateChatControlsConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an set of chat controls configured for an existing Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChatControlsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateChatControlsConfigurationRequest#builder()}
     * </p>
     *
     * @param updateChatControlsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateChatControlsConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChatControlsConfigurationResponse updateChatControlsConfiguration(
            Consumer<UpdateChatControlsConfigurationRequest.Builder> updateChatControlsConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return updateChatControlsConfiguration(UpdateChatControlsConfigurationRequest.builder()
                .applyMutation(updateChatControlsConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Q data source connector.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Q data source connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDataSourceResponse updateDataSource(Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Q index.
     * </p>
     *
     * @param updateIndexRequest
     * @return Result of the UpdateIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateIndexResponse updateIndex(UpdateIndexRequest updateIndexRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Q index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIndexRequest#builder()}
     * </p>
     *
     * @param updateIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateIndexRequest.Builder} to create a request.
     * @return Result of the UpdateIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateIndexResponse updateIndex(Consumer<UpdateIndexRequest.Builder> updateIndexRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return updateIndex(UpdateIndexRequest.builder().applyMutation(updateIndexRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Q plugin.
     * </p>
     *
     * @param updatePluginRequest
     * @return Result of the UpdatePlugin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePluginResponse updatePlugin(UpdatePluginRequest updatePluginRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Q plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePluginRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePluginRequest#builder()}
     * </p>
     *
     * @param updatePluginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdatePluginRequest.Builder} to create a request.
     * @return Result of the UpdatePlugin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePluginResponse updatePlugin(Consumer<UpdatePluginRequest.Builder> updatePluginRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return updatePlugin(UpdatePluginRequest.builder().applyMutation(updatePluginRequest).build());
    }

    /**
     * <p>
     * Updates the retriever used for your Amazon Q application.
     * </p>
     *
     * @param updateRetrieverRequest
     * @return Result of the UpdateRetriever operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRetrieverResponse updateRetriever(UpdateRetrieverRequest updateRetrieverRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the retriever used for your Amazon Q application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRetrieverRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRetrieverRequest#builder()}
     * </p>
     *
     * @param updateRetrieverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRetriever operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRetrieverResponse updateRetriever(Consumer<UpdateRetrieverRequest.Builder> updateRetrieverRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        return updateRetriever(UpdateRetrieverRequest.builder().applyMutation(updateRetrieverRequest).build());
    }

    /**
     * <p>
     * Updates a information associated with a user id.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a information associated with a user id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateUserRequest.Builder} to create a request.
     * @return Result of the UpdateUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Q web experience.
     * </p>
     *
     * @param updateWebExperienceRequest
     * @return Result of the UpdateWebExperience operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateWebExperienceResponse updateWebExperience(UpdateWebExperienceRequest updateWebExperienceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Q web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWebExperienceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWebExperienceRequest#builder()}
     * </p>
     *
     * @param updateWebExperienceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWebExperience operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you want to use doesn’t exist. Make sure you have provided the correct resource and try
     *         again.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q service. Wait some minutes and try
     *         again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistences with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q service. Provide the correct input and try
     *         again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateWebExperienceResponse updateWebExperience(
            Consumer<UpdateWebExperienceRequest.Builder> updateWebExperienceRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        return updateWebExperience(UpdateWebExperienceRequest.builder().applyMutation(updateWebExperienceRequest).build());
    }

    /**
     * Create a {@link QBusinessClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QBusinessClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QBusinessClient}.
     */
    static QBusinessClientBuilder builder() {
        return new DefaultQBusinessClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default QBusinessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
