/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of principals. Each principal can be either a <code>USER</code> or a <code>GROUP</code> and can be designated
 * document access permissions of either <code>ALLOW</code> or <code>DENY</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessControl implements SdkPojo, Serializable, ToCopyableBuilder<AccessControl.Builder, AccessControl> {
    private static final SdkField<String> MEMBER_RELATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberRelation").getter(getter(AccessControl::memberRelationAsString))
            .setter(setter(Builder::memberRelation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberRelation").build()).build();

    private static final SdkField<List<Principal>> PRINCIPALS_FIELD = SdkField
            .<List<Principal>> builder(MarshallingType.LIST)
            .memberName("principals")
            .getter(getter(AccessControl::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Principal> builder(MarshallingType.SDK_POJO)
                                            .constructor(Principal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_RELATION_FIELD,
            PRINCIPALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String memberRelation;

    private final List<Principal> principals;

    private AccessControl(BuilderImpl builder) {
        this.memberRelation = builder.memberRelation;
        this.principals = builder.principals;
    }

    /**
     * <p>
     * Describes the member relation within a principal list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberRelation}
     * will return {@link MemberRelation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberRelationAsString}.
     * </p>
     * 
     * @return Describes the member relation within a principal list.
     * @see MemberRelation
     */
    public final MemberRelation memberRelation() {
        return MemberRelation.fromValue(memberRelation);
    }

    /**
     * <p>
     * Describes the member relation within a principal list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberRelation}
     * will return {@link MemberRelation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberRelationAsString}.
     * </p>
     * 
     * @return Describes the member relation within a principal list.
     * @see MemberRelation
     */
    public final String memberRelationAsString() {
        return memberRelation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of principals, where a principal can be either a <code>USER</code> or a <code>GROUP</code>. Each
     * principal can be have the following type of document access: <code>ALLOW</code> or <code>DENY</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipals} method.
     * </p>
     * 
     * @return Contains a list of principals, where a principal can be either a <code>USER</code> or a
     *         <code>GROUP</code>. Each principal can be have the following type of document access: <code>ALLOW</code>
     *         or <code>DENY</code>.
     */
    public final List<Principal> principals() {
        return principals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memberRelationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipals() ? principals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControl)) {
            return false;
        }
        AccessControl other = (AccessControl) obj;
        return Objects.equals(memberRelationAsString(), other.memberRelationAsString())
                && hasPrincipals() == other.hasPrincipals() && Objects.equals(principals(), other.principals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessControl").add("MemberRelation", memberRelationAsString())
                .add("Principals", hasPrincipals() ? principals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memberRelation":
            return Optional.ofNullable(clazz.cast(memberRelationAsString()));
        case "principals":
            return Optional.ofNullable(clazz.cast(principals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessControl, T> g) {
        return obj -> g.apply((AccessControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessControl> {
        /**
         * <p>
         * Describes the member relation within a principal list.
         * </p>
         * 
         * @param memberRelation
         *        Describes the member relation within a principal list.
         * @see MemberRelation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberRelation
         */
        Builder memberRelation(String memberRelation);

        /**
         * <p>
         * Describes the member relation within a principal list.
         * </p>
         * 
         * @param memberRelation
         *        Describes the member relation within a principal list.
         * @see MemberRelation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberRelation
         */
        Builder memberRelation(MemberRelation memberRelation);

        /**
         * <p>
         * Contains a list of principals, where a principal can be either a <code>USER</code> or a <code>GROUP</code>.
         * Each principal can be have the following type of document access: <code>ALLOW</code> or <code>DENY</code>.
         * </p>
         * 
         * @param principals
         *        Contains a list of principals, where a principal can be either a <code>USER</code> or a
         *        <code>GROUP</code>. Each principal can be have the following type of document access:
         *        <code>ALLOW</code> or <code>DENY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<Principal> principals);

        /**
         * <p>
         * Contains a list of principals, where a principal can be either a <code>USER</code> or a <code>GROUP</code>.
         * Each principal can be have the following type of document access: <code>ALLOW</code> or <code>DENY</code>.
         * </p>
         * 
         * @param principals
         *        Contains a list of principals, where a principal can be either a <code>USER</code> or a
         *        <code>GROUP</code>. Each principal can be have the following type of document access:
         *        <code>ALLOW</code> or <code>DENY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Principal... principals);

        /**
         * <p>
         * Contains a list of principals, where a principal can be either a <code>USER</code> or a <code>GROUP</code>.
         * Each principal can be have the following type of document access: <code>ALLOW</code> or <code>DENY</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Principal.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.Principal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Principal.Builder#build()} is called immediately and
         * its result is passed to {@link #principals(List<Principal>)}.
         * 
         * @param principals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Principal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principals(java.util.Collection<Principal>)
         */
        Builder principals(Consumer<Principal.Builder>... principals);
    }

    static final class BuilderImpl implements Builder {
        private String memberRelation;

        private List<Principal> principals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControl model) {
            memberRelation(model.memberRelation);
            principals(model.principals);
        }

        public final String getMemberRelation() {
            return memberRelation;
        }

        public final void setMemberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
        }

        @Override
        public final Builder memberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
            return this;
        }

        @Override
        public final Builder memberRelation(MemberRelation memberRelation) {
            this.memberRelation(memberRelation == null ? null : memberRelation.toString());
            return this;
        }

        public final List<Principal.Builder> getPrincipals() {
            List<Principal.Builder> result = PrincipalsCopier.copyToBuilder(this.principals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipals(Collection<Principal.BuilderImpl> principals) {
            this.principals = PrincipalsCopier.copyFromBuilder(principals);
        }

        @Override
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Principal... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<Principal.Builder>... principals) {
            principals(Stream.of(principals).map(c -> Principal.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AccessControl build() {
            return new AccessControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
