/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWebExperienceResponse extends QBusinessResponse implements
        ToCopyableBuilder<CreateWebExperienceResponse.Builder, CreateWebExperienceResponse> {
    private static final SdkField<String> WEB_EXPERIENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webExperienceArn").getter(getter(CreateWebExperienceResponse::webExperienceArn))
            .setter(setter(Builder::webExperienceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperienceArn").build()).build();

    private static final SdkField<String> WEB_EXPERIENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webExperienceId").getter(getter(CreateWebExperienceResponse::webExperienceId))
            .setter(setter(Builder::webExperienceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperienceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_EXPERIENCE_ARN_FIELD,
            WEB_EXPERIENCE_ID_FIELD));

    private final String webExperienceArn;

    private final String webExperienceId;

    private CreateWebExperienceResponse(BuilderImpl builder) {
        super(builder);
        this.webExperienceArn = builder.webExperienceArn;
        this.webExperienceId = builder.webExperienceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Q web experience.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Q web experience.
     */
    public final String webExperienceArn() {
        return webExperienceArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q web experience.
     * </p>
     * 
     * @return The identifier of the Amazon Q web experience.
     */
    public final String webExperienceId() {
        return webExperienceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webExperienceArn());
        hashCode = 31 * hashCode + Objects.hashCode(webExperienceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebExperienceResponse)) {
            return false;
        }
        CreateWebExperienceResponse other = (CreateWebExperienceResponse) obj;
        return Objects.equals(webExperienceArn(), other.webExperienceArn())
                && Objects.equals(webExperienceId(), other.webExperienceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWebExperienceResponse").add("WebExperienceArn", webExperienceArn())
                .add("WebExperienceId", webExperienceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "webExperienceArn":
            return Optional.ofNullable(clazz.cast(webExperienceArn()));
        case "webExperienceId":
            return Optional.ofNullable(clazz.cast(webExperienceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWebExperienceResponse, T> g) {
        return obj -> g.apply((CreateWebExperienceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateWebExperienceResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon Q web experience.
         * </p>
         * 
         * @param webExperienceArn
         *        The Amazon Resource Name (ARN) of an Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperienceArn(String webExperienceArn);

        /**
         * <p>
         * The identifier of the Amazon Q web experience.
         * </p>
         * 
         * @param webExperienceId
         *        The identifier of the Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperienceId(String webExperienceId);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String webExperienceArn;

        private String webExperienceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebExperienceResponse model) {
            super(model);
            webExperienceArn(model.webExperienceArn);
            webExperienceId(model.webExperienceId);
        }

        public final String getWebExperienceArn() {
            return webExperienceArn;
        }

        public final void setWebExperienceArn(String webExperienceArn) {
            this.webExperienceArn = webExperienceArn;
        }

        @Override
        public final Builder webExperienceArn(String webExperienceArn) {
            this.webExperienceArn = webExperienceArn;
            return this;
        }

        public final String getWebExperienceId() {
            return webExperienceId;
        }

        public final void setWebExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
        }

        @Override
        public final Builder webExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
            return this;
        }

        @Override
        public CreateWebExperienceResponse build() {
            return new CreateWebExperienceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
