/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Amazon Q data source connector synchronization job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceSyncJob implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceSyncJob.Builder, DataSourceSyncJob> {
    private static final SdkField<String> DATA_SOURCE_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceErrorCode").getter(getter(DataSourceSyncJob::dataSourceErrorCode))
            .setter(setter(Builder::dataSourceErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceErrorCode").build())
            .build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(DataSourceSyncJob::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(DataSourceSyncJob::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(DataSourceSyncJob::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<DataSourceSyncJobMetrics> METRICS_FIELD = SdkField
            .<DataSourceSyncJobMetrics> builder(MarshallingType.SDK_POJO).memberName("metrics")
            .getter(getter(DataSourceSyncJob::metrics)).setter(setter(Builder::metrics))
            .constructor(DataSourceSyncJobMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(DataSourceSyncJob::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataSourceSyncJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ERROR_CODE_FIELD,
            END_TIME_FIELD, ERROR_FIELD, EXECUTION_ID_FIELD, METRICS_FIELD, START_TIME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSourceErrorCode;

    private final Instant endTime;

    private final ErrorDetail error;

    private final String executionId;

    private final DataSourceSyncJobMetrics metrics;

    private final Instant startTime;

    private final String status;

    private DataSourceSyncJob(BuilderImpl builder) {
        this.dataSourceErrorCode = builder.dataSourceErrorCode;
        this.endTime = builder.endTime;
        this.error = builder.error;
        this.executionId = builder.executionId;
        this.metrics = builder.metrics;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * If the reason that the synchronization failed is due to an error with the underlying data source, this field
     * contains a code that identifies the error.
     * </p>
     * 
     * @return If the reason that the synchronization failed is due to an error with the underlying data source, this
     *         field contains a code that identifies the error.
     */
    public final String dataSourceErrorCode() {
        return dataSourceErrorCode;
    }

    /**
     * <p>
     * The Unix timestamp when the synchronization job completed.
     * </p>
     * 
     * @return The Unix timestamp when the synchronization job completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field indicates the
     * reason the synchronization failed.
     * </p>
     * 
     * @return If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field
     *         indicates the reason the synchronization failed.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * <p>
     * The identifier of a data source synchronization job.
     * </p>
     * 
     * @return The identifier of a data source synchronization job.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * Maps a batch delete document request to a specific data source sync job. This is optional and should only be
     * supplied when documents are deleted by a data source connector.
     * </p>
     * 
     * @return Maps a batch delete document request to a specific data source sync job. This is optional and should only
     *         be supplied when documents are deleted by a data source connector.
     */
    public final DataSourceSyncJobMetrics metrics() {
        return metrics;
    }

    /**
     * <p>
     * The Unix time stamp when the data source synchronization job started.
     * </p>
     * 
     * @return The Unix time stamp when the data source synchronization job started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of the synchronization job. When the <code>Status</code> field is set to <code>SUCCEEDED</code>, the
     * synchronization job is done. If the status code is <code>FAILED</code>, the <code>ErrorCode</code> and
     * <code>ErrorMessage</code> fields give you the reason for the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceSyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the synchronization job. When the <code>Status</code> field is set to
     *         <code>SUCCEEDED</code>, the synchronization job is done. If the status code is <code>FAILED</code>, the
     *         <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
     * @see DataSourceSyncJobStatus
     */
    public final DataSourceSyncJobStatus status() {
        return DataSourceSyncJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the synchronization job. When the <code>Status</code> field is set to <code>SUCCEEDED</code>, the
     * synchronization job is done. If the status code is <code>FAILED</code>, the <code>ErrorCode</code> and
     * <code>ErrorMessage</code> fields give you the reason for the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceSyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the synchronization job. When the <code>Status</code> field is set to
     *         <code>SUCCEEDED</code>, the synchronization job is done. If the status code is <code>FAILED</code>, the
     *         <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
     * @see DataSourceSyncJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSyncJob)) {
            return false;
        }
        DataSourceSyncJob other = (DataSourceSyncJob) obj;
        return Objects.equals(dataSourceErrorCode(), other.dataSourceErrorCode()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(error(), other.error()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(metrics(), other.metrics()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceSyncJob").add("DataSourceErrorCode", dataSourceErrorCode()).add("EndTime", endTime())
                .add("Error", error()).add("ExecutionId", executionId()).add("Metrics", metrics()).add("StartTime", startTime())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceErrorCode":
            return Optional.ofNullable(clazz.cast(dataSourceErrorCode()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSyncJob, T> g) {
        return obj -> g.apply((DataSourceSyncJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceSyncJob> {
        /**
         * <p>
         * If the reason that the synchronization failed is due to an error with the underlying data source, this field
         * contains a code that identifies the error.
         * </p>
         * 
         * @param dataSourceErrorCode
         *        If the reason that the synchronization failed is due to an error with the underlying data source, this
         *        field contains a code that identifies the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceErrorCode(String dataSourceErrorCode);

        /**
         * <p>
         * The Unix timestamp when the synchronization job completed.
         * </p>
         * 
         * @param endTime
         *        The Unix timestamp when the synchronization job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field indicates
         * the reason the synchronization failed.
         * </p>
         * 
         * @param error
         *        If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field
         *        indicates the reason the synchronization failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field indicates
         * the reason the synchronization failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The identifier of a data source synchronization job.
         * </p>
         * 
         * @param executionId
         *        The identifier of a data source synchronization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * Maps a batch delete document request to a specific data source sync job. This is optional and should only be
         * supplied when documents are deleted by a data source connector.
         * </p>
         * 
         * @param metrics
         *        Maps a batch delete document request to a specific data source sync job. This is optional and should
         *        only be supplied when documents are deleted by a data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(DataSourceSyncJobMetrics metrics);

        /**
         * <p>
         * Maps a batch delete document request to a specific data source sync job. This is optional and should only be
         * supplied when documents are deleted by a data source connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceSyncJobMetrics.Builder}
         * avoiding the need to create one manually via {@link DataSourceSyncJobMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceSyncJobMetrics.Builder#build()} is called immediately
         * and its result is passed to {@link #metrics(DataSourceSyncJobMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link DataSourceSyncJobMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(DataSourceSyncJobMetrics)
         */
        default Builder metrics(Consumer<DataSourceSyncJobMetrics.Builder> metrics) {
            return metrics(DataSourceSyncJobMetrics.builder().applyMutation(metrics).build());
        }

        /**
         * <p>
         * The Unix time stamp when the data source synchronization job started.
         * </p>
         * 
         * @param startTime
         *        The Unix time stamp when the data source synchronization job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of the synchronization job. When the <code>Status</code> field is set to <code>SUCCEEDED</code>,
         * the synchronization job is done. If the status code is <code>FAILED</code>, the <code>ErrorCode</code> and
         * <code>ErrorMessage</code> fields give you the reason for the failure.
         * </p>
         * 
         * @param status
         *        The status of the synchronization job. When the <code>Status</code> field is set to
         *        <code>SUCCEEDED</code>, the synchronization job is done. If the status code is <code>FAILED</code>,
         *        the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
         * @see DataSourceSyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceSyncJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the synchronization job. When the <code>Status</code> field is set to <code>SUCCEEDED</code>,
         * the synchronization job is done. If the status code is <code>FAILED</code>, the <code>ErrorCode</code> and
         * <code>ErrorMessage</code> fields give you the reason for the failure.
         * </p>
         * 
         * @param status
         *        The status of the synchronization job. When the <code>Status</code> field is set to
         *        <code>SUCCEEDED</code>, the synchronization job is done. If the status code is <code>FAILED</code>,
         *        the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
         * @see DataSourceSyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceSyncJobStatus
         */
        Builder status(DataSourceSyncJobStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceErrorCode;

        private Instant endTime;

        private ErrorDetail error;

        private String executionId;

        private DataSourceSyncJobMetrics metrics;

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSyncJob model) {
            dataSourceErrorCode(model.dataSourceErrorCode);
            endTime(model.endTime);
            error(model.error);
            executionId(model.executionId);
            metrics(model.metrics);
            startTime(model.startTime);
            status(model.status);
        }

        public final String getDataSourceErrorCode() {
            return dataSourceErrorCode;
        }

        public final void setDataSourceErrorCode(String dataSourceErrorCode) {
            this.dataSourceErrorCode = dataSourceErrorCode;
        }

        @Override
        public final Builder dataSourceErrorCode(String dataSourceErrorCode) {
            this.dataSourceErrorCode = dataSourceErrorCode;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final DataSourceSyncJobMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(DataSourceSyncJobMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(DataSourceSyncJobMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceSyncJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DataSourceSyncJob build() {
            return new DataSourceSyncJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
