/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon Q plugin and its configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Plugin implements SdkPojo, Serializable, ToCopyableBuilder<Plugin.Builder, Plugin> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Plugin::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(Plugin::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginId").getter(getter(Plugin::pluginId)).setter(setter(Builder::pluginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()).build();

    private static final SdkField<String> SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverUrl").getter(getter(Plugin::serverUrl)).setter(setter(Builder::serverUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(Plugin::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Plugin::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Plugin::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DISPLAY_NAME_FIELD, PLUGIN_ID_FIELD, SERVER_URL_FIELD, STATE_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String displayName;

    private final String pluginId;

    private final String serverUrl;

    private final String state;

    private final String type;

    private final Instant updatedAt;

    private Plugin(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.displayName = builder.displayName;
        this.pluginId = builder.pluginId;
        this.serverUrl = builder.serverUrl;
        this.state = builder.state;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The timestamp for when the plugin was created.
     * </p>
     * 
     * @return The timestamp for when the plugin was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The name of the plugin.
     * </p>
     * 
     * @return The name of the plugin.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The identifier of the plugin.
     * </p>
     * 
     * @return The identifier of the plugin.
     */
    public final String pluginId() {
        return pluginId;
    }

    /**
     * <p>
     * The plugin server URL used for configuration.
     * </p>
     * 
     * @return The plugin server URL used for configuration.
     */
    public final String serverUrl() {
        return serverUrl;
    }

    /**
     * <p>
     * The current status of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current status of the plugin.
     * @see PluginState
     */
    public final PluginState state() {
        return PluginState.fromValue(state);
    }

    /**
     * <p>
     * The current status of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current status of the plugin.
     * @see PluginState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The type of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the plugin.
     * @see PluginType
     */
    public final PluginType type() {
        return PluginType.fromValue(type);
    }

    /**
     * <p>
     * The type of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the plugin.
     * @see PluginType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The timestamp for when the plugin was last updated.
     * </p>
     * 
     * @return The timestamp for when the plugin was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Plugin)) {
            return false;
        }
        Plugin other = (Plugin) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(pluginId(), other.pluginId()) && Objects.equals(serverUrl(), other.serverUrl())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Plugin").add("CreatedAt", createdAt()).add("DisplayName", displayName())
                .add("PluginId", pluginId()).add("ServerUrl", serverUrl()).add("State", stateAsString())
                .add("Type", typeAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "pluginId":
            return Optional.ofNullable(clazz.cast(pluginId()));
        case "serverUrl":
            return Optional.ofNullable(clazz.cast(serverUrl()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Plugin, T> g) {
        return obj -> g.apply((Plugin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Plugin> {
        /**
         * <p>
         * The timestamp for when the plugin was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp for when the plugin was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The name of the plugin.
         * </p>
         * 
         * @param displayName
         *        The name of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The identifier of the plugin.
         * </p>
         * 
         * @param pluginId
         *        The identifier of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginId(String pluginId);

        /**
         * <p>
         * The plugin server URL used for configuration.
         * </p>
         * 
         * @param serverUrl
         *        The plugin server URL used for configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverUrl(String serverUrl);

        /**
         * <p>
         * The current status of the plugin.
         * </p>
         * 
         * @param state
         *        The current status of the plugin.
         * @see PluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginState
         */
        Builder state(String state);

        /**
         * <p>
         * The current status of the plugin.
         * </p>
         * 
         * @param state
         *        The current status of the plugin.
         * @see PluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginState
         */
        Builder state(PluginState state);

        /**
         * <p>
         * The type of the plugin.
         * </p>
         * 
         * @param type
         *        The type of the plugin.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the plugin.
         * </p>
         * 
         * @param type
         *        The type of the plugin.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder type(PluginType type);

        /**
         * <p>
         * The timestamp for when the plugin was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp for when the plugin was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String displayName;

        private String pluginId;

        private String serverUrl;

        private String state;

        private String type;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Plugin model) {
            createdAt(model.createdAt);
            displayName(model.displayName);
            pluginId(model.pluginId);
            serverUrl(model.serverUrl);
            state(model.state);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getPluginId() {
            return pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getServerUrl() {
            return serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PluginState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PluginType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Plugin build() {
            return new Plugin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
