/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a text extract in a chat response that can be attributed to a source document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextSegment implements SdkPojo, Serializable, ToCopyableBuilder<TextSegment.Builder, TextSegment> {
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("beginOffset").getter(getter(TextSegment::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endOffset").getter(getter(TextSegment::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endOffset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_FIELD,
            END_OFFSET_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer beginOffset;

    private final Integer endOffset;

    private TextSegment(BuilderImpl builder) {
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
    }

    /**
     * <p>
     * The zero-based location in the response string where the source attribution starts.
     * </p>
     * 
     * @return The zero-based location in the response string where the source attribution starts.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The zero-based location in the response string where the source attribution ends.
     * </p>
     * 
     * @return The zero-based location in the response string where the source attribution ends.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextSegment)) {
            return false;
        }
        TextSegment other = (TextSegment) obj;
        return Objects.equals(beginOffset(), other.beginOffset()) && Objects.equals(endOffset(), other.endOffset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextSegment").add("BeginOffset", beginOffset()).add("EndOffset", endOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "beginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "endOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextSegment, T> g) {
        return obj -> g.apply((TextSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextSegment> {
        /**
         * <p>
         * The zero-based location in the response string where the source attribution starts.
         * </p>
         * 
         * @param beginOffset
         *        The zero-based location in the response string where the source attribution starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The zero-based location in the response string where the source attribution ends.
         * </p>
         * 
         * @param endOffset
         *        The zero-based location in the response string where the source attribution ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);
    }

    static final class BuilderImpl implements Builder {
        private Integer beginOffset;

        private Integer endOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(TextSegment model) {
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        @Override
        public TextSegment build() {
            return new TextSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
