/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSourceRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateDataSourceRequest.Builder, UpdateDataSourceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateDataSourceRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<Document> CONFIGURATION_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("configuration").getter(getter(UpdateDataSourceRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(UpdateDataSourceRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateDataSourceRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<DocumentEnrichmentConfiguration> DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField
            .<DocumentEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("documentEnrichmentConfiguration")
            .getter(getter(UpdateDataSourceRequest::documentEnrichmentConfiguration))
            .setter(setter(Builder::documentEnrichmentConfiguration))
            .constructor(DocumentEnrichmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentEnrichmentConfiguration")
                    .build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(UpdateDataSourceRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateDataSourceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SYNC_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncSchedule").getter(getter(UpdateDataSourceRequest::syncSchedule))
            .setter(setter(Builder::syncSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSchedule").build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(UpdateDataSourceRequest::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_ID_FIELD, CONFIGURATION_FIELD, DATA_SOURCE_ID_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD,
                    DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD, INDEX_ID_FIELD, ROLE_ARN_FIELD, SYNC_SCHEDULE_FIELD,
                    VPC_CONFIGURATION_FIELD));

    private final String applicationId;

    private final Document configuration;

    private final String dataSourceId;

    private final String description;

    private final String displayName;

    private final DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

    private final String indexId;

    private final String roleArn;

    private final String syncSchedule;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configuration = builder.configuration;
        this.dataSourceId = builder.dataSourceId;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
        this.indexId = builder.indexId;
        this.roleArn = builder.roleArn;
        this.syncSchedule = builder.syncSchedule;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application the data source is attached to.
     * </p>
     * 
     * @return The identifier of the Amazon Q application the data source is attached to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the Configuration property for this object.
     * 
     * @return The value of the Configuration property for this object.
     */
    public final Document configuration() {
        return configuration;
    }

    /**
     * <p>
     * The identifier of the data source connector.
     * </p>
     * 
     * @return The identifier of the data source connector.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The description of the data source connector.
     * </p>
     * 
     * @return The description of the data source connector.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A name of the data source connector.
     * </p>
     * 
     * @return A name of the data source connector.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * Returns the value of the DocumentEnrichmentConfiguration property for this object.
     * 
     * @return The value of the DocumentEnrichmentConfiguration property for this object.
     */
    public final DocumentEnrichmentConfiguration documentEnrichmentConfiguration() {
        return documentEnrichmentConfiguration;
    }

    /**
     * <p>
     * The identifier of the index attached to the data source connector.
     * </p>
     * 
     * @return The identifier of the index attached to the data source connector.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required
     *         resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The chosen update frequency for your data source.
     * </p>
     * 
     * @return The chosen update frequency for your data source.
     */
    public final String syncSchedule() {
        return syncSchedule;
    }

    /**
     * Returns the value of the VpcConfiguration property for this object.
     * 
     * @return The value of the VpcConfiguration property for this object.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(documentEnrichmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(syncSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(documentEnrichmentConfiguration(), other.documentEnrichmentConfiguration())
                && Objects.equals(indexId(), other.indexId()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(syncSchedule(), other.syncSchedule())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataSourceRequest").add("ApplicationId", applicationId())
                .add("Configuration", configuration()).add("DataSourceId", dataSourceId()).add("Description", description())
                .add("DisplayName", displayName()).add("DocumentEnrichmentConfiguration", documentEnrichmentConfiguration())
                .add("IndexId", indexId()).add("RoleArn", roleArn()).add("SyncSchedule", syncSchedule())
                .add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "documentEnrichmentConfiguration":
            return Optional.ofNullable(clazz.cast(documentEnrichmentConfiguration()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "syncSchedule":
            return Optional.ofNullable(clazz.cast(syncSchedule()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataSourceRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q application the data source is attached to.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application the data source is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the Configuration property for this object.
         *
         * @param configuration
         *        The new value for the Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Document configuration);

        /**
         * <p>
         * The identifier of the data source connector.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The description of the data source connector.
         * </p>
         * 
         * @param description
         *        The description of the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name of the data source connector.
         * </p>
         * 
         * @param displayName
         *        A name of the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * Sets the value of the DocumentEnrichmentConfiguration property for this object.
         *
         * @param documentEnrichmentConfiguration
         *        The new value for the DocumentEnrichmentConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration);

        /**
         * Sets the value of the DocumentEnrichmentConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentEnrichmentConfiguration.Builder}
         * avoiding the need to create one manually via {@link DocumentEnrichmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentEnrichmentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)}.
         * 
         * @param documentEnrichmentConfiguration
         *        a consumer that will call methods on {@link DocumentEnrichmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)
         */
        default Builder documentEnrichmentConfiguration(
                Consumer<DocumentEnrichmentConfiguration.Builder> documentEnrichmentConfiguration) {
            return documentEnrichmentConfiguration(DocumentEnrichmentConfiguration.builder()
                    .applyMutation(documentEnrichmentConfiguration).build());
        }

        /**
         * <p>
         * The identifier of the index attached to the data source connector.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index attached to the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required
         * resources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The chosen update frequency for your data source.
         * </p>
         * 
         * @param syncSchedule
         *        The chosen update frequency for your data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSchedule(String syncSchedule);

        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * @param vpcConfiguration
         *        The new value for the VpcConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private Document configuration;

        private String dataSourceId;

        private String description;

        private String displayName;

        private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

        private String indexId;

        private String roleArn;

        private String syncSchedule;

        private DataSourceVpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            applicationId(model.applicationId);
            configuration(model.configuration);
            dataSourceId(model.dataSourceId);
            description(model.description);
            displayName(model.displayName);
            documentEnrichmentConfiguration(model.documentEnrichmentConfiguration);
            indexId(model.indexId);
            roleArn(model.roleArn);
            syncSchedule(model.syncSchedule);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Document getConfiguration() {
            return configuration;
        }

        public final void setConfiguration(Document configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(Document configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final DocumentEnrichmentConfiguration.Builder getDocumentEnrichmentConfiguration() {
            return documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setDocumentEnrichmentConfiguration(
                DocumentEnrichmentConfiguration.BuilderImpl documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSyncSchedule() {
            return syncSchedule;
        }

        public final void setSyncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
        }

        @Override
        public final Builder syncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
