/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeStringListValueCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentAttributeValue> {
    private static final SdkField<Instant> DATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("dateValue").getter(DocumentAttributeValue.getter(DocumentAttributeValue::dateValue)).setter(DocumentAttributeValue.setter(Builder::dateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateValue").build()}).build();
    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("longValue").getter(DocumentAttributeValue.getter(DocumentAttributeValue::longValue)).setter(DocumentAttributeValue.setter(Builder::longValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValue").build()}).build();
    private static final SdkField<List<String>> STRING_LIST_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stringListValue").getter(DocumentAttributeValue.getter(DocumentAttributeValue::stringListValue)).setter(DocumentAttributeValue.setter(Builder::stringListValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringListValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(DocumentAttributeValue.getter(DocumentAttributeValue::stringValue)).setter(DocumentAttributeValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_VALUE_FIELD, LONG_VALUE_FIELD, STRING_LIST_VALUE_FIELD, STRING_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant dateValue;
    private final Long longValue;
    private final List<String> stringListValue;
    private final String stringValue;
    private final Type type;

    private DocumentAttributeValue(BuilderImpl builder) {
        this.dateValue = builder.dateValue;
        this.longValue = builder.longValue;
        this.stringListValue = builder.stringListValue;
        this.stringValue = builder.stringValue;
        this.type = builder.type;
    }

    public final Instant dateValue() {
        return this.dateValue;
    }

    public final Long longValue() {
        return this.longValue;
    }

    public final boolean hasStringListValue() {
        return this.stringListValue != null && !(this.stringListValue instanceof SdkAutoConstructList);
    }

    public final List<String> stringListValue() {
        return this.stringListValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dateValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.longValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringListValue() ? this.stringListValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeValue)) {
            return false;
        }
        DocumentAttributeValue other = (DocumentAttributeValue)obj;
        return Objects.equals(this.dateValue(), other.dateValue()) && Objects.equals(this.longValue(), other.longValue()) && this.hasStringListValue() == other.hasStringListValue() && Objects.equals(this.stringListValue(), other.stringListValue()) && Objects.equals(this.stringValue(), other.stringValue());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentAttributeValue").add("DateValue", (Object)this.dateValue()).add("LongValue", (Object)this.longValue()).add("StringListValue", this.hasStringListValue() ? this.stringListValue() : null).add("StringValue", (Object)this.stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dateValue": {
                return Optional.ofNullable(clazz.cast(this.dateValue()));
            }
            case "longValue": {
                return Optional.ofNullable(clazz.cast(this.longValue()));
            }
            case "stringListValue": {
                return Optional.ofNullable(clazz.cast(this.stringListValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
        }
        return Optional.empty();
    }

    public static DocumentAttributeValue fromDateValue(Instant dateValue) {
        return (DocumentAttributeValue)DocumentAttributeValue.builder().dateValue(dateValue).build();
    }

    public static DocumentAttributeValue fromLongValue(Long longValue) {
        return (DocumentAttributeValue)DocumentAttributeValue.builder().longValue(longValue).build();
    }

    public static DocumentAttributeValue fromStringListValue(List<String> stringListValue) {
        return (DocumentAttributeValue)DocumentAttributeValue.builder().stringListValue(stringListValue).build();
    }

    public static DocumentAttributeValue fromStringValue(String stringValue) {
        return (DocumentAttributeValue)DocumentAttributeValue.builder().stringValue(stringValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeValue, T> g) {
        return obj -> g.apply((DocumentAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DATE_VALUE,
        LONG_VALUE,
        STRING_LIST_VALUE,
        STRING_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Instant dateValue;
        private Long longValue;
        private List<String> stringListValue = DefaultSdkAutoConstructList.getInstance();
        private String stringValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeValue model) {
            this.dateValue(model.dateValue);
            this.longValue(model.longValue);
            this.stringListValue(model.stringListValue);
            this.stringValue(model.stringValue);
        }

        public final Instant getDateValue() {
            return this.dateValue;
        }

        public final void setDateValue(Instant dateValue) {
            Instant oldValue = this.dateValue;
            this.dateValue = dateValue;
            this.handleUnionValueChange(Type.DATE_VALUE, oldValue, this.dateValue);
        }

        @Override
        public final Builder dateValue(Instant dateValue) {
            Instant oldValue = this.dateValue;
            this.dateValue = dateValue;
            this.handleUnionValueChange(Type.DATE_VALUE, oldValue, this.dateValue);
            return this;
        }

        public final Long getLongValue() {
            return this.longValue;
        }

        public final void setLongValue(Long longValue) {
            Long oldValue = this.longValue;
            this.longValue = longValue;
            this.handleUnionValueChange(Type.LONG_VALUE, oldValue, this.longValue);
        }

        @Override
        public final Builder longValue(Long longValue) {
            Long oldValue = this.longValue;
            this.longValue = longValue;
            this.handleUnionValueChange(Type.LONG_VALUE, oldValue, this.longValue);
            return this;
        }

        public final Collection<String> getStringListValue() {
            if (this.stringListValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringListValue;
        }

        public final void setStringListValue(Collection<String> stringListValue) {
            List<String> oldValue = this.stringListValue;
            this.stringListValue = DocumentAttributeStringListValueCopier.copy(stringListValue);
            this.handleUnionValueChange(Type.STRING_LIST_VALUE, oldValue, this.stringListValue);
        }

        @Override
        public final Builder stringListValue(Collection<String> stringListValue) {
            List<String> oldValue = this.stringListValue;
            this.stringListValue = DocumentAttributeStringListValueCopier.copy(stringListValue);
            this.handleUnionValueChange(Type.STRING_LIST_VALUE, oldValue, this.stringListValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringListValue(String ... stringListValue) {
            this.stringListValue(Arrays.asList(stringListValue));
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public DocumentAttributeValue build() {
            return new DocumentAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentAttributeValue> {
        public Builder dateValue(Instant var1);

        public Builder longValue(Long var1);

        public Builder stringListValue(Collection<String> var1);

        public Builder stringListValue(String ... var1);

        public Builder stringValue(String var1);
    }
}

