/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.AccessConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ContentType;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttribute;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributesCopier;
import software.amazon.awssdk.services.qbusiness.model.DocumentContent;
import software.amazon.awssdk.services.qbusiness.model.DocumentEnrichmentConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Document
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Document> {
    private static final SdkField<AccessConfiguration> ACCESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessConfiguration").getter(Document.getter(Document::accessConfiguration)).setter(Document.setter(Builder::accessConfiguration)).constructor(AccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessConfiguration").build()}).build();
    private static final SdkField<List<DocumentAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(Document.getter(Document::attributes)).setter(Document.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DocumentContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(Document.getter(Document::content)).setter(Document.setter(Builder::content)).constructor(DocumentContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(Document.getter(Document::contentTypeAsString)).setter(Document.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<DocumentEnrichmentConfiguration> DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentEnrichmentConfiguration").getter(Document.getter(Document::documentEnrichmentConfiguration)).setter(Document.setter(Builder::documentEnrichmentConfiguration)).constructor(DocumentEnrichmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentEnrichmentConfiguration").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Document.getter(Document::id)).setter(Document.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(Document.getter(Document::title)).setter(Document.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONFIGURATION_FIELD, ATTRIBUTES_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD, ID_FIELD, TITLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccessConfiguration accessConfiguration;
    private final List<DocumentAttribute> attributes;
    private final DocumentContent content;
    private final String contentType;
    private final DocumentEnrichmentConfiguration documentEnrichmentConfiguration;
    private final String id;
    private final String title;

    private Document(BuilderImpl builder) {
        this.accessConfiguration = builder.accessConfiguration;
        this.attributes = builder.attributes;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
        this.id = builder.id;
        this.title = builder.title;
    }

    public final AccessConfiguration accessConfiguration() {
        return this.accessConfiguration;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttribute> attributes() {
        return this.attributes;
    }

    public final DocumentContent content() {
        return this.content;
    }

    public final ContentType contentType() {
        return ContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final DocumentEnrichmentConfiguration documentEnrichmentConfiguration() {
        return this.documentEnrichmentConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentEnrichmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document)obj;
        return Objects.equals(this.accessConfiguration(), other.accessConfiguration()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.documentEnrichmentConfiguration(), other.documentEnrichmentConfiguration()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title());
    }

    public final String toString() {
        return ToString.builder((String)"Document").add("AccessConfiguration", (Object)this.accessConfiguration()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Content", (Object)this.content()).add("ContentType", (Object)this.contentTypeAsString()).add("DocumentEnrichmentConfiguration", (Object)this.documentEnrichmentConfiguration()).add("Id", (Object)this.id()).add("Title", (Object)this.title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.accessConfiguration()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "documentEnrichmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.documentEnrichmentConfiguration()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Document, T> g) {
        return obj -> g.apply((Document)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccessConfiguration accessConfiguration;
        private List<DocumentAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private DocumentContent content;
        private String contentType;
        private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;
        private String id;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(Document model) {
            this.accessConfiguration(model.accessConfiguration);
            this.attributes(model.attributes);
            this.content(model.content);
            this.contentType(model.contentType);
            this.documentEnrichmentConfiguration(model.documentEnrichmentConfiguration);
            this.id(model.id);
            this.title(model.title);
        }

        public final AccessConfiguration.Builder getAccessConfiguration() {
            return this.accessConfiguration != null ? this.accessConfiguration.toBuilder() : null;
        }

        public final void setAccessConfiguration(AccessConfiguration.BuilderImpl accessConfiguration) {
            this.accessConfiguration = accessConfiguration != null ? accessConfiguration.build() : null;
        }

        @Override
        public final Builder accessConfiguration(AccessConfiguration accessConfiguration) {
            this.accessConfiguration = accessConfiguration;
            return this;
        }

        public final List<DocumentAttribute.Builder> getAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<DocumentAttribute.BuilderImpl> attributes) {
            this.attributes = DocumentAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<DocumentAttribute> attributes) {
            this.attributes = DocumentAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(DocumentAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<DocumentAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DocumentContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(DocumentContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(DocumentContent content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final DocumentEnrichmentConfiguration.Builder getDocumentEnrichmentConfiguration() {
            return this.documentEnrichmentConfiguration != null ? this.documentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setDocumentEnrichmentConfiguration(DocumentEnrichmentConfiguration.BuilderImpl documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration.build() : null;
        }

        @Override
        public final Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public Document build() {
            return new Document(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Document> {
        public Builder accessConfiguration(AccessConfiguration var1);

        default public Builder accessConfiguration(Consumer<AccessConfiguration.Builder> accessConfiguration) {
            return this.accessConfiguration((AccessConfiguration)((AccessConfiguration.Builder)AccessConfiguration.builder().applyMutation(accessConfiguration)).build());
        }

        public Builder attributes(Collection<DocumentAttribute> var1);

        public Builder attributes(DocumentAttribute ... var1);

        public Builder attributes(Consumer<DocumentAttribute.Builder> ... var1);

        public Builder content(DocumentContent var1);

        default public Builder content(Consumer<DocumentContent.Builder> content) {
            return this.content((DocumentContent)((DocumentContent.Builder)DocumentContent.builder().applyMutation(content)).build());
        }

        public Builder contentType(String var1);

        public Builder contentType(ContentType var1);

        public Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration var1);

        default public Builder documentEnrichmentConfiguration(Consumer<DocumentEnrichmentConfiguration.Builder> documentEnrichmentConfiguration) {
            return this.documentEnrichmentConfiguration((DocumentEnrichmentConfiguration)((DocumentEnrichmentConfiguration.Builder)DocumentEnrichmentConfiguration.builder().applyMutation(documentEnrichmentConfiguration)).build());
        }

        public Builder id(String var1);

        public Builder title(String var1);
    }
}

