/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Performs an Amazon Q plugin action during a non-streaming chat conversation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionExecution implements SdkPojo, Serializable, ToCopyableBuilder<ActionExecution.Builder, ActionExecution> {
    private static final SdkField<Map<String, ActionExecutionPayloadField>> PAYLOAD_FIELD = SdkField
            .<Map<String, ActionExecutionPayloadField>> builder(MarshallingType.MAP)
            .memberName("payload")
            .getter(getter(ActionExecution::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ActionExecutionPayloadField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionExecutionPayloadField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PAYLOAD_FIELD_NAME_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("payloadFieldNameSeparator").getter(getter(ActionExecution::payloadFieldNameSeparator))
            .setter(setter(Builder::payloadFieldNameSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFieldNameSeparator").build())
            .build();

    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginId").getter(getter(ActionExecution::pluginId)).setter(setter(Builder::pluginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_FIELD,
            PAYLOAD_FIELD_NAME_SEPARATOR_FIELD, PLUGIN_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, ActionExecutionPayloadField> payload;

    private final String payloadFieldNameSeparator;

    private final String pluginId;

    private ActionExecution(BuilderImpl builder) {
        this.payload = builder.payload;
        this.payloadFieldNameSeparator = builder.payloadFieldNameSeparator;
        this.pluginId = builder.pluginId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Payload property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPayload() {
        return payload != null && !(payload instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of field names to the field values in input that an end user provides to Amazon Q requests to perform
     * their plugin action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPayload} method.
     * </p>
     * 
     * @return A mapping of field names to the field values in input that an end user provides to Amazon Q requests to
     *         perform their plugin action.
     */
    public final Map<String, ActionExecutionPayloadField> payload() {
        return payload;
    }

    /**
     * <p>
     * A string used to retain information about the hierarchical contexts within an action execution event payload.
     * </p>
     * 
     * @return A string used to retain information about the hierarchical contexts within an action execution event
     *         payload.
     */
    public final String payloadFieldNameSeparator() {
        return payloadFieldNameSeparator;
    }

    /**
     * <p>
     * The identifier of the plugin the action is attached to.
     * </p>
     * 
     * @return The identifier of the plugin the action is attached to.
     */
    public final String pluginId() {
        return pluginId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPayload() ? payload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(payloadFieldNameSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(pluginId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecution)) {
            return false;
        }
        ActionExecution other = (ActionExecution) obj;
        return hasPayload() == other.hasPayload() && Objects.equals(payload(), other.payload())
                && Objects.equals(payloadFieldNameSeparator(), other.payloadFieldNameSeparator())
                && Objects.equals(pluginId(), other.pluginId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionExecution").add("Payload", hasPayload() ? payload() : null)
                .add("PayloadFieldNameSeparator", payloadFieldNameSeparator()).add("PluginId", pluginId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "payloadFieldNameSeparator":
            return Optional.ofNullable(clazz.cast(payloadFieldNameSeparator()));
        case "pluginId":
            return Optional.ofNullable(clazz.cast(pluginId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecution, T> g) {
        return obj -> g.apply((ActionExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionExecution> {
        /**
         * <p>
         * A mapping of field names to the field values in input that an end user provides to Amazon Q requests to
         * perform their plugin action.
         * </p>
         * 
         * @param payload
         *        A mapping of field names to the field values in input that an end user provides to Amazon Q requests
         *        to perform their plugin action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Map<String, ActionExecutionPayloadField> payload);

        /**
         * <p>
         * A string used to retain information about the hierarchical contexts within an action execution event payload.
         * </p>
         * 
         * @param payloadFieldNameSeparator
         *        A string used to retain information about the hierarchical contexts within an action execution event
         *        payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadFieldNameSeparator(String payloadFieldNameSeparator);

        /**
         * <p>
         * The identifier of the plugin the action is attached to.
         * </p>
         * 
         * @param pluginId
         *        The identifier of the plugin the action is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginId(String pluginId);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, ActionExecutionPayloadField> payload = DefaultSdkAutoConstructMap.getInstance();

        private String payloadFieldNameSeparator;

        private String pluginId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecution model) {
            payload(model.payload);
            payloadFieldNameSeparator(model.payloadFieldNameSeparator);
            pluginId(model.pluginId);
        }

        public final Map<String, ActionExecutionPayloadField.Builder> getPayload() {
            Map<String, ActionExecutionPayloadField.Builder> result = ActionExecutionPayloadCopier.copyToBuilder(this.payload);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPayload(Map<String, ActionExecutionPayloadField.BuilderImpl> payload) {
            this.payload = ActionExecutionPayloadCopier.copyFromBuilder(payload);
        }

        @Override
        public final Builder payload(Map<String, ActionExecutionPayloadField> payload) {
            this.payload = ActionExecutionPayloadCopier.copy(payload);
            return this;
        }

        public final String getPayloadFieldNameSeparator() {
            return payloadFieldNameSeparator;
        }

        public final void setPayloadFieldNameSeparator(String payloadFieldNameSeparator) {
            this.payloadFieldNameSeparator = payloadFieldNameSeparator;
        }

        @Override
        public final Builder payloadFieldNameSeparator(String payloadFieldNameSeparator) {
            this.payloadFieldNameSeparator = payloadFieldNameSeparator;
            return this;
        }

        public final String getPluginId() {
            return pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @Override
        public ActionExecution build() {
            return new ActionExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
