/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the basic authentication credentials used to configure a plugin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BasicAuthConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BasicAuthConfiguration.Builder, BasicAuthConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(BasicAuthConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretArn").getter(getter(BasicAuthConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            SECRET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String secretArn;

    private BasicAuthConfiguration(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.secretArn = builder.secretArn;
    }

    /**
     * <p>
     * The ARN of an IAM role used by Amazon Q to access the basic authentication credentials stored in a Secrets
     * Manager secret.
     * </p>
     * 
     * @return The ARN of an IAM role used by Amazon Q to access the basic authentication credentials stored in a
     *         Secrets Manager secret.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret that stores the basic authentication credentials used for plugin
     * configuration..
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret that stores the basic authentication credentials used for plugin
     *         configuration..
     */
    public final String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicAuthConfiguration)) {
            return false;
        }
        BasicAuthConfiguration other = (BasicAuthConfiguration) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(secretArn(), other.secretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BasicAuthConfiguration").add("RoleArn", roleArn()).add("SecretArn", secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "secretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BasicAuthConfiguration, T> g) {
        return obj -> g.apply((BasicAuthConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BasicAuthConfiguration> {
        /**
         * <p>
         * The ARN of an IAM role used by Amazon Q to access the basic authentication credentials stored in a Secrets
         * Manager secret.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role used by Amazon Q to access the basic authentication credentials stored in a
         *        Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The ARN of the Secrets Manager secret that stores the basic authentication credentials used for plugin
         * configuration..
         * </p>
         * 
         * @param secretArn
         *        The ARN of the Secrets Manager secret that stores the basic authentication credentials used for plugin
         *        configuration..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BasicAuthConfiguration model) {
            roleArn(model.roleArn);
            secretArn(model.secretArn);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        @Override
        public BasicAuthConfiguration build() {
            return new BasicAuthConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
