/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutDocumentRequest extends QBusinessRequest implements
        ToCopyableBuilder<BatchPutDocumentRequest.Builder, BatchPutDocumentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(BatchPutDocumentRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> DATA_SOURCE_SYNC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceSyncId").getter(getter(BatchPutDocumentRequest::dataSourceSyncId))
            .setter(setter(Builder::dataSourceSyncId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceSyncId").build()).build();

    private static final SdkField<List<Document>> DOCUMENTS_FIELD = SdkField
            .<List<Document>> builder(MarshallingType.LIST)
            .memberName("documents")
            .getter(getter(BatchPutDocumentRequest::documents))
            .setter(setter(Builder::documents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.SDK_POJO)
                                            .constructor(Document::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(BatchPutDocumentRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(BatchPutDocumentRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            DATA_SOURCE_SYNC_ID_FIELD, DOCUMENTS_FIELD, INDEX_ID_FIELD, ROLE_ARN_FIELD));

    private final String applicationId;

    private final String dataSourceSyncId;

    private final List<Document> documents;

    private final String indexId;

    private final String roleArn;

    private BatchPutDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.dataSourceSyncId = builder.dataSourceSyncId;
        this.documents = builder.documents;
        this.indexId = builder.indexId;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application.
     * </p>
     * 
     * @return The identifier of the Amazon Q application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the data source sync during which the documents were added.
     * </p>
     * 
     * @return The identifier of the data source sync during which the documents were added.
     */
    public final String dataSourceSyncId() {
        return dataSourceSyncId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Documents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDocuments() {
        return documents != null && !(documents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more documents to add to the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocuments} method.
     * </p>
     * 
     * @return One or more documents to add to the index.
     */
    public final List<Document> documents() {
        return documents;
    }

    /**
     * <p>
     * The identifier of the Amazon Q index to add the documents to.
     * </p>
     * 
     * @return The identifier of the Amazon Q index to add the documents to.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceSyncId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocuments() ? documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDocumentRequest)) {
            return false;
        }
        BatchPutDocumentRequest other = (BatchPutDocumentRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(dataSourceSyncId(), other.dataSourceSyncId()) && hasDocuments() == other.hasDocuments()
                && Objects.equals(documents(), other.documents()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutDocumentRequest").add("ApplicationId", applicationId())
                .add("DataSourceSyncId", dataSourceSyncId()).add("Documents", hasDocuments() ? documents() : null)
                .add("IndexId", indexId()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "dataSourceSyncId":
            return Optional.ofNullable(clazz.cast(dataSourceSyncId()));
        case "documents":
            return Optional.ofNullable(clazz.cast(documents()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutDocumentRequest, T> g) {
        return obj -> g.apply((BatchPutDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchPutDocumentRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the data source sync during which the documents were added.
         * </p>
         * 
         * @param dataSourceSyncId
         *        The identifier of the data source sync during which the documents were added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceSyncId(String dataSourceSyncId);

        /**
         * <p>
         * One or more documents to add to the index.
         * </p>
         * 
         * @param documents
         *        One or more documents to add to the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Collection<Document> documents);

        /**
         * <p>
         * One or more documents to add to the index.
         * </p>
         * 
         * @param documents
         *        One or more documents to add to the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Document... documents);

        /**
         * <p>
         * One or more documents to add to the index.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Document.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.Document#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Document.Builder#build()} is called immediately and
         * its result is passed to {@link #documents(List<Document>)}.
         * 
         * @param documents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Document.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(java.util.Collection<Document>)
         */
        Builder documents(Consumer<Document.Builder>... documents);

        /**
         * <p>
         * The identifier of the Amazon Q index to add the documents to.
         * </p>
         * 
         * @param indexId
         *        The identifier of the Amazon Q index to add the documents to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String dataSourceSyncId;

        private List<Document> documents = DefaultSdkAutoConstructList.getInstance();

        private String indexId;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutDocumentRequest model) {
            super(model);
            applicationId(model.applicationId);
            dataSourceSyncId(model.dataSourceSyncId);
            documents(model.documents);
            indexId(model.indexId);
            roleArn(model.roleArn);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDataSourceSyncId() {
            return dataSourceSyncId;
        }

        public final void setDataSourceSyncId(String dataSourceSyncId) {
            this.dataSourceSyncId = dataSourceSyncId;
        }

        @Override
        public final Builder dataSourceSyncId(String dataSourceSyncId) {
            this.dataSourceSyncId = dataSourceSyncId;
            return this;
        }

        public final List<Document.Builder> getDocuments() {
            List<Document.Builder> result = DocumentsCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<Document.BuilderImpl> documents) {
            this.documents = DocumentsCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<Document> documents) {
            this.documents = DocumentsCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Document... documents) {
            documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<Document.Builder>... documents) {
            documents(Stream.of(documents).map(c -> Document.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutDocumentRequest build() {
            return new BatchPutDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
