/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceRequest extends QBusinessRequest implements
        ToCopyableBuilder<CreateDataSourceRequest.Builder, CreateDataSourceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CreateDataSourceRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDataSourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Document> CONFIGURATION_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("configuration").getter(getter(CreateDataSourceRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateDataSourceRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<DocumentEnrichmentConfiguration> DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField
            .<DocumentEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("documentEnrichmentConfiguration")
            .getter(getter(CreateDataSourceRequest::documentEnrichmentConfiguration))
            .setter(setter(Builder::documentEnrichmentConfiguration))
            .constructor(DocumentEnrichmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentEnrichmentConfiguration")
                    .build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(CreateDataSourceRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateDataSourceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SYNC_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncSchedule").getter(getter(CreateDataSourceRequest::syncSchedule))
            .setter(setter(Builder::syncSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSchedule").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDataSourceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(CreateDataSourceRequest::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD,
            DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD, INDEX_ID_FIELD, ROLE_ARN_FIELD, SYNC_SCHEDULE_FIELD, TAGS_FIELD,
            VPC_CONFIGURATION_FIELD));

    private final String applicationId;

    private final String clientToken;

    private final Document configuration;

    private final String description;

    private final String displayName;

    private final DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

    private final String indexId;

    private final String roleArn;

    private final String syncSchedule;

    private final List<Tag> tags;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
        this.indexId = builder.indexId;
        this.roleArn = builder.roleArn;
        this.syncSchedule = builder.syncSchedule;
        this.tags = builder.tags;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application the data source will be attached to.
     * </p>
     * 
     * @return The identifier of the Amazon Q application the data source will be attached to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A token you provide to identify a request to create a data source connector. Multiple calls to the
     * <code>CreateDataSource</code> API with the same client token will create only one data source connector.
     * </p>
     * 
     * @return A token you provide to identify a request to create a data source connector. Multiple calls to the
     *         <code>CreateDataSource</code> API with the same client token will create only one data source connector.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Configuration information to connect to your data source repository. For configuration templates for your
     * specific data source, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html.html">Supported
     * connectors</a>.
     * </p>
     * 
     * @return Configuration information to connect to your data source repository. For configuration templates for your
     *         specific data source, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html.html">Supported
     *         connectors</a>.
     */
    public final Document configuration() {
        return configuration;
    }

    /**
     * <p>
     * A description for the data source connector.
     * </p>
     * 
     * @return A description for the data source connector.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A name for the data source connector.
     * </p>
     * 
     * @return A name for the data source connector.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * Returns the value of the DocumentEnrichmentConfiguration property for this object.
     * 
     * @return The value of the DocumentEnrichmentConfiguration property for this object.
     */
    public final DocumentEnrichmentConfiguration documentEnrichmentConfiguration() {
        return documentEnrichmentConfiguration;
    }

    /**
     * <p>
     * The identifier of the index that you want to use with the data source connector.
     * </p>
     * 
     * @return The identifier of the index that you want to use with the data source connector.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required
     *         resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Sets the frequency for Amazon Q to check the documents in your data source repository and update your index. If
     * you don't set a schedule, Amazon Q won't periodically update the index.
     * </p>
     * <p>
     * Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is updated on
     * demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to
     * <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
     * </p>
     * 
     * @return Sets the frequency for Amazon Q to check the documents in your data source repository and update your
     *         index. If you don't set a schedule, Amazon Q won't periodically update the index.</p>
     *         <p>
     *         Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is
     *         updated on demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code>
     *         parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code>
     *         exception.
     */
    public final String syncSchedule() {
        return syncSchedule;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help
     * control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white
     * space, and any of the following symbols: _ . : / = + - @.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
     *         help control access to the data source connector. Tag keys and values can consist of Unicode letters,
     *         digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more
     * information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using
     * Amazon VPC with Amazon Q connectors</a>.
     * </p>
     * 
     * @return Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC
     *         with Amazon Q connectors</a>.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(documentEnrichmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(syncSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(documentEnrichmentConfiguration(), other.documentEnrichmentConfiguration())
                && Objects.equals(indexId(), other.indexId()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(syncSchedule(), other.syncSchedule()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSourceRequest").add("ApplicationId", applicationId())
                .add("ClientToken", clientToken()).add("Configuration", configuration()).add("Description", description())
                .add("DisplayName", displayName()).add("DocumentEnrichmentConfiguration", documentEnrichmentConfiguration())
                .add("IndexId", indexId()).add("RoleArn", roleArn()).add("SyncSchedule", syncSchedule())
                .add("Tags", hasTags() ? tags() : null).add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "documentEnrichmentConfiguration":
            return Optional.ofNullable(clazz.cast(documentEnrichmentConfiguration()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "syncSchedule":
            return Optional.ofNullable(clazz.cast(syncSchedule()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSourceRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q application the data source will be attached to.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application the data source will be attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A token you provide to identify a request to create a data source connector. Multiple calls to the
         * <code>CreateDataSource</code> API with the same client token will create only one data source connector.
         * </p>
         * 
         * @param clientToken
         *        A token you provide to identify a request to create a data source connector. Multiple calls to the
         *        <code>CreateDataSource</code> API with the same client token will create only one data source
         *        connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Configuration information to connect to your data source repository. For configuration templates for your
         * specific data source, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html.html">Supported
         * connectors</a>.
         * </p>
         * 
         * @param configuration
         *        Configuration information to connect to your data source repository. For configuration templates for
         *        your specific data source, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html.html">Supported
         *        connectors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Document configuration);

        /**
         * <p>
         * A description for the data source connector.
         * </p>
         * 
         * @param description
         *        A description for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the data source connector.
         * </p>
         * 
         * @param displayName
         *        A name for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * Sets the value of the DocumentEnrichmentConfiguration property for this object.
         *
         * @param documentEnrichmentConfiguration
         *        The new value for the DocumentEnrichmentConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration);

        /**
         * Sets the value of the DocumentEnrichmentConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentEnrichmentConfiguration.Builder}
         * avoiding the need to create one manually via {@link DocumentEnrichmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentEnrichmentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)}.
         * 
         * @param documentEnrichmentConfiguration
         *        a consumer that will call methods on {@link DocumentEnrichmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)
         */
        default Builder documentEnrichmentConfiguration(
                Consumer<DocumentEnrichmentConfiguration.Builder> documentEnrichmentConfiguration) {
            return documentEnrichmentConfiguration(DocumentEnrichmentConfiguration.builder()
                    .applyMutation(documentEnrichmentConfiguration).build());
        }

        /**
         * <p>
         * The identifier of the index that you want to use with the data source connector.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index that you want to use with the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required
         * resources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Sets the frequency for Amazon Q to check the documents in your data source repository and update your index.
         * If you don't set a schedule, Amazon Q won't periodically update the index.
         * </p>
         * <p>
         * Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is updated
         * on demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set
         * to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
         * </p>
         * 
         * @param syncSchedule
         *        Sets the frequency for Amazon Q to check the documents in your data source repository and update your
         *        index. If you don't set a schedule, Amazon Q won't periodically update the index.</p>
         *        <p>
         *        Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is
         *        updated on demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code>
         *        parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code>
         *        exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSchedule(String syncSchedule);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
         * help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the data source connector. You can also use tags
         *        to help control access to the data source connector. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
         * help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the data source connector. You can also use tags
         *        to help control access to the data source connector. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
         * help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qbusiness.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC with
         * Amazon Q connectors</a>.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC
         *        with Amazon Q connectors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC with
         * Amazon Q connectors</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String clientToken;

        private Document configuration;

        private String description;

        private String displayName;

        private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

        private String indexId;

        private String roleArn;

        private String syncSchedule;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private DataSourceVpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            applicationId(model.applicationId);
            clientToken(model.clientToken);
            configuration(model.configuration);
            description(model.description);
            displayName(model.displayName);
            documentEnrichmentConfiguration(model.documentEnrichmentConfiguration);
            indexId(model.indexId);
            roleArn(model.roleArn);
            syncSchedule(model.syncSchedule);
            tags(model.tags);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Document getConfiguration() {
            return configuration;
        }

        public final void setConfiguration(Document configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(Document configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final DocumentEnrichmentConfiguration.Builder getDocumentEnrichmentConfiguration() {
            return documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setDocumentEnrichmentConfiguration(
                DocumentEnrichmentConfiguration.BuilderImpl documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSyncSchedule() {
            return syncSchedule;
        }

        public final void setSyncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
        }

        @Override
        public final Builder syncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
