/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIndexResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetIndexResponse.Builder, GetIndexResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetIndexResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<IndexCapacityConfiguration> CAPACITY_CONFIGURATION_FIELD = SdkField
            .<IndexCapacityConfiguration> builder(MarshallingType.SDK_POJO).memberName("capacityConfiguration")
            .getter(getter(GetIndexResponse::capacityConfiguration)).setter(setter(Builder::capacityConfiguration))
            .constructor(IndexCapacityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetIndexResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetIndexResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetIndexResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<List<DocumentAttributeConfiguration>> DOCUMENT_ATTRIBUTE_CONFIGURATIONS_FIELD = SdkField
            .<List<DocumentAttributeConfiguration>> builder(MarshallingType.LIST)
            .memberName("documentAttributeConfigurations")
            .getter(getter(GetIndexResponse::documentAttributeConfigurations))
            .setter(setter(Builder::documentAttributeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentAttributeConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttributeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttributeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(GetIndexResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexArn").getter(getter(GetIndexResponse::indexArn)).setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(GetIndexResponse::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexId").build()).build();

    private static final SdkField<IndexStatistics> INDEX_STATISTICS_FIELD = SdkField
            .<IndexStatistics> builder(MarshallingType.SDK_POJO).memberName("indexStatistics")
            .getter(getter(GetIndexResponse::indexStatistics)).setter(setter(Builder::indexStatistics))
            .constructor(IndexStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexStatistics").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetIndexResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetIndexResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CAPACITY_CONFIGURATION_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD,
            DOCUMENT_ATTRIBUTE_CONFIGURATIONS_FIELD, ERROR_FIELD, INDEX_ARN_FIELD, INDEX_ID_FIELD, INDEX_STATISTICS_FIELD,
            STATUS_FIELD, UPDATED_AT_FIELD));

    private final String applicationId;

    private final IndexCapacityConfiguration capacityConfiguration;

    private final Instant createdAt;

    private final String description;

    private final String displayName;

    private final List<DocumentAttributeConfiguration> documentAttributeConfigurations;

    private final ErrorDetail error;

    private final String indexArn;

    private final String indexId;

    private final IndexStatistics indexStatistics;

    private final String status;

    private final Instant updatedAt;

    private GetIndexResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.capacityConfiguration = builder.capacityConfiguration;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.documentAttributeConfigurations = builder.documentAttributeConfigurations;
        this.error = builder.error;
        this.indexArn = builder.indexArn;
        this.indexId = builder.indexId;
        this.indexStatistics = builder.indexStatistics;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application associated with the index.
     * </p>
     * 
     * @return The identifier of the Amazon Q application associated with the index.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The storage capacity units chosen for your Amazon Q index.
     * </p>
     * 
     * @return The storage capacity units chosen for your Amazon Q index.
     */
    public final IndexCapacityConfiguration capacityConfiguration() {
        return capacityConfiguration;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q index was created.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q index was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description for the Amazon Q index.
     * </p>
     * 
     * @return The description for the Amazon Q index.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the Amazon Q index.
     * </p>
     * 
     * @return The name of the Amazon Q index.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentAttributeConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDocumentAttributeConfigurations() {
        return documentAttributeConfigurations != null && !(documentAttributeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information for document attributes or metadata. Document metadata are fields associated with your
     * documents. For example, the company department name associated with each document. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes">
     * Understanding document attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentAttributeConfigurations}
     * method.
     * </p>
     * 
     * @return Configuration information for document attributes or metadata. Document metadata are fields associated
     *         with your documents. For example, the company department name associated with each document. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
     *         >Understanding document attributes</a>.
     */
    public final List<DocumentAttributeConfiguration> documentAttributeConfigurations() {
        return documentAttributeConfigurations;
    }

    /**
     * <p>
     * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
     * message that explains why.
     * </p>
     * 
     * @return When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     *         contains a message that explains why.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q index.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q index.
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q index.
     * </p>
     * 
     * @return The identifier of the Amazon Q index.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * Provides information about the number of documents indexed.
     * </p>
     * 
     * @return Provides information about the number of documents indexed.
     */
    public final IndexStatistics indexStatistics() {
        return indexStatistics;
    }

    /**
     * <p>
     * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
     * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message
     * that explains why.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
     *         the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
     *         a message that explains why.
     * @see IndexStatus
     */
    public final IndexStatus status() {
        return IndexStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
     * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message
     * that explains why.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
     *         the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
     *         a message that explains why.
     * @see IndexStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q index was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q index was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDocumentAttributeConfigurations() ? documentAttributeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIndexResponse)) {
            return false;
        }
        GetIndexResponse other = (GetIndexResponse) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(capacityConfiguration(), other.capacityConfiguration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && hasDocumentAttributeConfigurations() == other.hasDocumentAttributeConfigurations()
                && Objects.equals(documentAttributeConfigurations(), other.documentAttributeConfigurations())
                && Objects.equals(error(), other.error()) && Objects.equals(indexArn(), other.indexArn())
                && Objects.equals(indexId(), other.indexId()) && Objects.equals(indexStatistics(), other.indexStatistics())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetIndexResponse")
                .add("ApplicationId", applicationId())
                .add("CapacityConfiguration", capacityConfiguration())
                .add("CreatedAt", createdAt())
                .add("Description", description())
                .add("DisplayName", displayName())
                .add("DocumentAttributeConfigurations",
                        hasDocumentAttributeConfigurations() ? documentAttributeConfigurations() : null).add("Error", error())
                .add("IndexArn", indexArn()).add("IndexId", indexId()).add("IndexStatistics", indexStatistics())
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "capacityConfiguration":
            return Optional.ofNullable(clazz.cast(capacityConfiguration()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "documentAttributeConfigurations":
            return Optional.ofNullable(clazz.cast(documentAttributeConfigurations()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "indexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "indexStatistics":
            return Optional.ofNullable(clazz.cast(indexStatistics()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIndexResponse, T> g) {
        return obj -> g.apply((GetIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIndexResponse> {
        /**
         * <p>
         * The identifier of the Amazon Q application associated with the index.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application associated with the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The storage capacity units chosen for your Amazon Q index.
         * </p>
         * 
         * @param capacityConfiguration
         *        The storage capacity units chosen for your Amazon Q index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityConfiguration(IndexCapacityConfiguration capacityConfiguration);

        /**
         * <p>
         * The storage capacity units chosen for your Amazon Q index.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexCapacityConfiguration.Builder}
         * avoiding the need to create one manually via {@link IndexCapacityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexCapacityConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityConfiguration(IndexCapacityConfiguration)}.
         * 
         * @param capacityConfiguration
         *        a consumer that will call methods on {@link IndexCapacityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityConfiguration(IndexCapacityConfiguration)
         */
        default Builder capacityConfiguration(Consumer<IndexCapacityConfiguration.Builder> capacityConfiguration) {
            return capacityConfiguration(IndexCapacityConfiguration.builder().applyMutation(capacityConfiguration).build());
        }

        /**
         * <p>
         * The Unix timestamp when the Amazon Q index was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the Amazon Q index was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description for the Amazon Q index.
         * </p>
         * 
         * @param description
         *        The description for the Amazon Q index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the Amazon Q index.
         * </p>
         * 
         * @param displayName
         *        The name of the Amazon Q index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Configuration information for document attributes or metadata. Document metadata are fields associated with
         * your documents. For example, the company department name associated with each document. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         * >Understanding document attributes</a>.
         * </p>
         * 
         * @param documentAttributeConfigurations
         *        Configuration information for document attributes or metadata. Document metadata are fields associated
         *        with your documents. For example, the company department name associated with each document. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         *        >Understanding document attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeConfigurations(Collection<DocumentAttributeConfiguration> documentAttributeConfigurations);

        /**
         * <p>
         * Configuration information for document attributes or metadata. Document metadata are fields associated with
         * your documents. For example, the company department name associated with each document. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         * >Understanding document attributes</a>.
         * </p>
         * 
         * @param documentAttributeConfigurations
         *        Configuration information for document attributes or metadata. Document metadata are fields associated
         *        with your documents. For example, the company department name associated with each document. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         *        >Understanding document attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeConfigurations(DocumentAttributeConfiguration... documentAttributeConfigurations);

        /**
         * <p>
         * Configuration information for document attributes or metadata. Document metadata are fields associated with
         * your documents. For example, the company department name associated with each document. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes"
         * >Understanding document attributes</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #documentAttributeConfigurations(List<DocumentAttributeConfiguration>)}.
         * 
         * @param documentAttributeConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributeConfigurations(java.util.Collection<DocumentAttributeConfiguration>)
         */
        Builder documentAttributeConfigurations(
                Consumer<DocumentAttributeConfiguration.Builder>... documentAttributeConfigurations);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a message that explains why.
         * </p>
         * 
         * @param error
         *        When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a message that explains why.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q index.
         * </p>
         * 
         * @param indexArn
         *        The Amazon Resource Name (ARN) of the Amazon Q index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * The identifier of the Amazon Q index.
         * </p>
         * 
         * @param indexId
         *        The identifier of the Amazon Q index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * Provides information about the number of documents indexed.
         * </p>
         * 
         * @param indexStatistics
         *        Provides information about the number of documents indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexStatistics(IndexStatistics indexStatistics);

        /**
         * <p>
         * Provides information about the number of documents indexed.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexStatistics.Builder} avoiding the
         * need to create one manually via {@link IndexStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #indexStatistics(IndexStatistics)}.
         * 
         * @param indexStatistics
         *        a consumer that will call methods on {@link IndexStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexStatistics(IndexStatistics)
         */
        default Builder indexStatistics(Consumer<IndexStatistics.Builder> indexStatistics) {
            return indexStatistics(IndexStatistics.builder().applyMutation(indexStatistics).build());
        }

        /**
         * <p>
         * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
         * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
         * message that explains why.
         * </p>
         * 
         * @param status
         *        The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
         *        the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
         * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
         * message that explains why.
         * </p>
         * 
         * @param status
         *        The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
         *        the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(IndexStatus status);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q index was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the Amazon Q index was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String applicationId;

        private IndexCapacityConfiguration capacityConfiguration;

        private Instant createdAt;

        private String description;

        private String displayName;

        private List<DocumentAttributeConfiguration> documentAttributeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private ErrorDetail error;

        private String indexArn;

        private String indexId;

        private IndexStatistics indexStatistics;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIndexResponse model) {
            super(model);
            applicationId(model.applicationId);
            capacityConfiguration(model.capacityConfiguration);
            createdAt(model.createdAt);
            description(model.description);
            displayName(model.displayName);
            documentAttributeConfigurations(model.documentAttributeConfigurations);
            error(model.error);
            indexArn(model.indexArn);
            indexId(model.indexId);
            indexStatistics(model.indexStatistics);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final IndexCapacityConfiguration.Builder getCapacityConfiguration() {
            return capacityConfiguration != null ? capacityConfiguration.toBuilder() : null;
        }

        public final void setCapacityConfiguration(IndexCapacityConfiguration.BuilderImpl capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration != null ? capacityConfiguration.build() : null;
        }

        @Override
        public final Builder capacityConfiguration(IndexCapacityConfiguration capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<DocumentAttributeConfiguration.Builder> getDocumentAttributeConfigurations() {
            List<DocumentAttributeConfiguration.Builder> result = DocumentAttributeConfigurationsCopier
                    .copyToBuilder(this.documentAttributeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributeConfigurations(
                Collection<DocumentAttributeConfiguration.BuilderImpl> documentAttributeConfigurations) {
            this.documentAttributeConfigurations = DocumentAttributeConfigurationsCopier
                    .copyFromBuilder(documentAttributeConfigurations);
        }

        @Override
        public final Builder documentAttributeConfigurations(
                Collection<DocumentAttributeConfiguration> documentAttributeConfigurations) {
            this.documentAttributeConfigurations = DocumentAttributeConfigurationsCopier.copy(documentAttributeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeConfigurations(DocumentAttributeConfiguration... documentAttributeConfigurations) {
            documentAttributeConfigurations(Arrays.asList(documentAttributeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeConfigurations(
                Consumer<DocumentAttributeConfiguration.Builder>... documentAttributeConfigurations) {
            documentAttributeConfigurations(Stream.of(documentAttributeConfigurations)
                    .map(c -> DocumentAttributeConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final IndexStatistics.Builder getIndexStatistics() {
            return indexStatistics != null ? indexStatistics.toBuilder() : null;
        }

        public final void setIndexStatistics(IndexStatistics.BuilderImpl indexStatistics) {
            this.indexStatistics = indexStatistics != null ? indexStatistics.build() : null;
        }

        @Override
        public final Builder indexStatistics(IndexStatistics indexStatistics) {
            this.indexStatistics = indexStatistics;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IndexStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetIndexResponse build() {
            return new GetIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
