/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWebExperienceResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetWebExperienceResponse.Builder, GetWebExperienceResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetWebExperienceResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<WebExperienceAuthConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<WebExperienceAuthConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("authenticationConfiguration")
            .getter(getter(GetWebExperienceResponse::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(WebExperienceAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration")
                    .build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetWebExperienceResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DEFAULT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultEndpoint").getter(getter(GetWebExperienceResponse::defaultEndpoint))
            .setter(setter(Builder::defaultEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultEndpoint").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(GetWebExperienceResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> SAMPLE_PROMPTS_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("samplePromptsControlMode").getter(getter(GetWebExperienceResponse::samplePromptsControlModeAsString))
            .setter(setter(Builder::samplePromptsControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplePromptsControlMode").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetWebExperienceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SUBTITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subtitle").getter(getter(GetWebExperienceResponse::subtitle)).setter(setter(Builder::subtitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtitle").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(GetWebExperienceResponse::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetWebExperienceResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> WEB_EXPERIENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webExperienceArn").getter(getter(GetWebExperienceResponse::webExperienceArn))
            .setter(setter(Builder::webExperienceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperienceArn").build()).build();

    private static final SdkField<String> WEB_EXPERIENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webExperienceId").getter(getter(GetWebExperienceResponse::webExperienceId))
            .setter(setter(Builder::webExperienceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperienceId").build()).build();

    private static final SdkField<String> WELCOME_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("welcomeMessage").getter(getter(GetWebExperienceResponse::welcomeMessage))
            .setter(setter(Builder::welcomeMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            AUTHENTICATION_CONFIGURATION_FIELD, CREATED_AT_FIELD, DEFAULT_ENDPOINT_FIELD, ERROR_FIELD,
            SAMPLE_PROMPTS_CONTROL_MODE_FIELD, STATUS_FIELD, SUBTITLE_FIELD, TITLE_FIELD, UPDATED_AT_FIELD,
            WEB_EXPERIENCE_ARN_FIELD, WEB_EXPERIENCE_ID_FIELD, WELCOME_MESSAGE_FIELD));

    private final String applicationId;

    private final WebExperienceAuthConfiguration authenticationConfiguration;

    private final Instant createdAt;

    private final String defaultEndpoint;

    private final ErrorDetail error;

    private final String samplePromptsControlMode;

    private final String status;

    private final String subtitle;

    private final String title;

    private final Instant updatedAt;

    private final String webExperienceArn;

    private final String webExperienceId;

    private final String welcomeMessage;

    private GetWebExperienceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.createdAt = builder.createdAt;
        this.defaultEndpoint = builder.defaultEndpoint;
        this.error = builder.error;
        this.samplePromptsControlMode = builder.samplePromptsControlMode;
        this.status = builder.status;
        this.subtitle = builder.subtitle;
        this.title = builder.title;
        this.updatedAt = builder.updatedAt;
        this.webExperienceArn = builder.webExperienceArn;
        this.webExperienceId = builder.webExperienceId;
        this.welcomeMessage = builder.welcomeMessage;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application linked to the web experience.
     * </p>
     * 
     * @return The identifier of the Amazon Q application linked to the web experience.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The authentication configuration information for your Amazon Q web experience.
     * </p>
     * 
     * @return The authentication configuration information for your Amazon Q web experience.
     */
    public final WebExperienceAuthConfiguration authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * <p>
     * The Unix timestamp when the retriever was created.
     * </p>
     * 
     * @return The Unix timestamp when the retriever was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The endpoint of your Amazon Q web experience.
     * </p>
     * 
     * @return The endpoint of your Amazon Q web experience.
     */
    public final String defaultEndpoint() {
        return defaultEndpoint;
    }

    /**
     * <p>
     * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
     * description of the error that caused the data source connector to fail.
     * </p>
     * 
     * @return When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     *         contains a description of the error that caused the data source connector to fail.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * <p>
     * Determines whether sample prompts are enabled in the web experience for an end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samplePromptsControlMode} will return
     * {@link WebExperienceSamplePromptsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #samplePromptsControlModeAsString}.
     * </p>
     * 
     * @return Determines whether sample prompts are enabled in the web experience for an end user.
     * @see WebExperienceSamplePromptsControlMode
     */
    public final WebExperienceSamplePromptsControlMode samplePromptsControlMode() {
        return WebExperienceSamplePromptsControlMode.fromValue(samplePromptsControlMode);
    }

    /**
     * <p>
     * Determines whether sample prompts are enabled in the web experience for an end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samplePromptsControlMode} will return
     * {@link WebExperienceSamplePromptsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #samplePromptsControlModeAsString}.
     * </p>
     * 
     * @return Determines whether sample prompts are enabled in the web experience for an end user.
     * @see WebExperienceSamplePromptsControlMode
     */
    public final String samplePromptsControlModeAsString() {
        return samplePromptsControlMode;
    }

    /**
     * <p>
     * The current status of the Amazon Q web experience. When the <code>Status</code> field value is
     * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the data
     * source connector to fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WebExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Amazon Q web experience. When the <code>Status</code> field value is
     *         <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused
     *         the data source connector to fail.
     * @see WebExperienceStatus
     */
    public final WebExperienceStatus status() {
        return WebExperienceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Amazon Q web experience. When the <code>Status</code> field value is
     * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the data
     * source connector to fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WebExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Amazon Q web experience. When the <code>Status</code> field value is
     *         <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused
     *         the data source connector to fail.
     * @see WebExperienceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The subtitle for your Amazon Q web experience.
     * </p>
     * 
     * @return The subtitle for your Amazon Q web experience.
     */
    public final String subtitle() {
        return subtitle;
    }

    /**
     * <p>
     * The title for your Amazon Q web experience.
     * </p>
     * 
     * @return The title for your Amazon Q web experience.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The Unix timestamp when the data source connector was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the data source connector was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role with the permission to access the Amazon Q web experience and required
     * resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role with the permission to access the Amazon Q web experience and
     *         required resources.
     */
    public final String webExperienceArn() {
        return webExperienceArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q web experience.
     * </p>
     * 
     * @return The identifier of the Amazon Q web experience.
     */
    public final String webExperienceId() {
        return webExperienceId;
    }

    /**
     * <p>
     * The customized welcome message for end users of an Amazon Q web experience.
     * </p>
     * 
     * @return The customized welcome message for end users of an Amazon Q web experience.
     */
    public final String welcomeMessage() {
        return welcomeMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(defaultEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(samplePromptsControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(webExperienceArn());
        hashCode = 31 * hashCode + Objects.hashCode(webExperienceId());
        hashCode = 31 * hashCode + Objects.hashCode(welcomeMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebExperienceResponse)) {
            return false;
        }
        GetWebExperienceResponse other = (GetWebExperienceResponse) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(defaultEndpoint(), other.defaultEndpoint())
                && Objects.equals(error(), other.error())
                && Objects.equals(samplePromptsControlModeAsString(), other.samplePromptsControlModeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(subtitle(), other.subtitle())
                && Objects.equals(title(), other.title()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(webExperienceArn(), other.webExperienceArn())
                && Objects.equals(webExperienceId(), other.webExperienceId())
                && Objects.equals(welcomeMessage(), other.welcomeMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWebExperienceResponse").add("ApplicationId", applicationId())
                .add("AuthenticationConfiguration", authenticationConfiguration()).add("CreatedAt", createdAt())
                .add("DefaultEndpoint", defaultEndpoint()).add("Error", error())
                .add("SamplePromptsControlMode", samplePromptsControlModeAsString()).add("Status", statusAsString())
                .add("Subtitle", subtitle()).add("Title", title()).add("UpdatedAt", updatedAt())
                .add("WebExperienceArn", webExperienceArn()).add("WebExperienceId", webExperienceId())
                .add("WelcomeMessage", welcomeMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "authenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "defaultEndpoint":
            return Optional.ofNullable(clazz.cast(defaultEndpoint()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "samplePromptsControlMode":
            return Optional.ofNullable(clazz.cast(samplePromptsControlModeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "subtitle":
            return Optional.ofNullable(clazz.cast(subtitle()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "webExperienceArn":
            return Optional.ofNullable(clazz.cast(webExperienceArn()));
        case "webExperienceId":
            return Optional.ofNullable(clazz.cast(webExperienceId()));
        case "welcomeMessage":
            return Optional.ofNullable(clazz.cast(welcomeMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWebExperienceResponse, T> g) {
        return obj -> g.apply((GetWebExperienceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWebExperienceResponse> {
        /**
         * <p>
         * The identifier of the Amazon Q application linked to the web experience.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application linked to the web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The authentication configuration information for your Amazon Q web experience.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The authentication configuration information for your Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfiguration(WebExperienceAuthConfiguration authenticationConfiguration);

        /**
         * <p>
         * The authentication configuration information for your Amazon Q web experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebExperienceAuthConfiguration.Builder}
         * avoiding the need to create one manually via {@link WebExperienceAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebExperienceAuthConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationConfiguration(WebExperienceAuthConfiguration)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link WebExperienceAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(WebExperienceAuthConfiguration)
         */
        default Builder authenticationConfiguration(Consumer<WebExperienceAuthConfiguration.Builder> authenticationConfiguration) {
            return authenticationConfiguration(WebExperienceAuthConfiguration.builder()
                    .applyMutation(authenticationConfiguration).build());
        }

        /**
         * <p>
         * The Unix timestamp when the retriever was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the retriever was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The endpoint of your Amazon Q web experience.
         * </p>
         * 
         * @param defaultEndpoint
         *        The endpoint of your Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEndpoint(String defaultEndpoint);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a description of the error that caused the data source connector to fail.
         * </p>
         * 
         * @param error
         *        When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a description of the error that caused the data source connector to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a description of the error that caused the data source connector to fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * Determines whether sample prompts are enabled in the web experience for an end user.
         * </p>
         * 
         * @param samplePromptsControlMode
         *        Determines whether sample prompts are enabled in the web experience for an end user.
         * @see WebExperienceSamplePromptsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceSamplePromptsControlMode
         */
        Builder samplePromptsControlMode(String samplePromptsControlMode);

        /**
         * <p>
         * Determines whether sample prompts are enabled in the web experience for an end user.
         * </p>
         * 
         * @param samplePromptsControlMode
         *        Determines whether sample prompts are enabled in the web experience for an end user.
         * @see WebExperienceSamplePromptsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceSamplePromptsControlMode
         */
        Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode);

        /**
         * <p>
         * The current status of the Amazon Q web experience. When the <code>Status</code> field value is
         * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the
         * data source connector to fail.
         * </p>
         * 
         * @param status
         *        The current status of the Amazon Q web experience. When the <code>Status</code> field value is
         *        <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that
         *        caused the data source connector to fail.
         * @see WebExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Amazon Q web experience. When the <code>Status</code> field value is
         * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the
         * data source connector to fail.
         * </p>
         * 
         * @param status
         *        The current status of the Amazon Q web experience. When the <code>Status</code> field value is
         *        <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that
         *        caused the data source connector to fail.
         * @see WebExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceStatus
         */
        Builder status(WebExperienceStatus status);

        /**
         * <p>
         * The subtitle for your Amazon Q web experience.
         * </p>
         * 
         * @param subtitle
         *        The subtitle for your Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitle(String subtitle);

        /**
         * <p>
         * The title for your Amazon Q web experience.
         * </p>
         * 
         * @param title
         *        The title for your Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The Unix timestamp when the data source connector was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the data source connector was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role with the permission to access the Amazon Q web experience and
         * required resources.
         * </p>
         * 
         * @param webExperienceArn
         *        The Amazon Resource Name (ARN) of the role with the permission to access the Amazon Q web experience
         *        and required resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperienceArn(String webExperienceArn);

        /**
         * <p>
         * The identifier of the Amazon Q web experience.
         * </p>
         * 
         * @param webExperienceId
         *        The identifier of the Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperienceId(String webExperienceId);

        /**
         * <p>
         * The customized welcome message for end users of an Amazon Q web experience.
         * </p>
         * 
         * @param welcomeMessage
         *        The customized welcome message for end users of an Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder welcomeMessage(String welcomeMessage);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String applicationId;

        private WebExperienceAuthConfiguration authenticationConfiguration;

        private Instant createdAt;

        private String defaultEndpoint;

        private ErrorDetail error;

        private String samplePromptsControlMode;

        private String status;

        private String subtitle;

        private String title;

        private Instant updatedAt;

        private String webExperienceArn;

        private String webExperienceId;

        private String welcomeMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebExperienceResponse model) {
            super(model);
            applicationId(model.applicationId);
            authenticationConfiguration(model.authenticationConfiguration);
            createdAt(model.createdAt);
            defaultEndpoint(model.defaultEndpoint);
            error(model.error);
            samplePromptsControlMode(model.samplePromptsControlMode);
            status(model.status);
            subtitle(model.subtitle);
            title(model.title);
            updatedAt(model.updatedAt);
            webExperienceArn(model.webExperienceArn);
            webExperienceId(model.webExperienceId);
            welcomeMessage(model.welcomeMessage);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final WebExperienceAuthConfiguration.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(WebExperienceAuthConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(WebExperienceAuthConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDefaultEndpoint() {
            return defaultEndpoint;
        }

        public final void setDefaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = defaultEndpoint;
        }

        @Override
        public final Builder defaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = defaultEndpoint;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final String getSamplePromptsControlMode() {
            return samplePromptsControlMode;
        }

        public final void setSamplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
        }

        @Override
        public final Builder samplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
            return this;
        }

        @Override
        public final Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode) {
            this.samplePromptsControlMode(samplePromptsControlMode == null ? null : samplePromptsControlMode.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WebExperienceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSubtitle() {
            return subtitle;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        @Override
        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getWebExperienceArn() {
            return webExperienceArn;
        }

        public final void setWebExperienceArn(String webExperienceArn) {
            this.webExperienceArn = webExperienceArn;
        }

        @Override
        public final Builder webExperienceArn(String webExperienceArn) {
            this.webExperienceArn = webExperienceArn;
            return this;
        }

        public final String getWebExperienceId() {
            return webExperienceId;
        }

        public final void setWebExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
        }

        @Override
        public final Builder webExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
            return this;
        }

        public final String getWelcomeMessage() {
            return welcomeMessage;
        }

        public final void setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
        }

        @Override
        public final Builder welcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        @Override
        public GetWebExperienceResponse build() {
            return new GetWebExperienceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
