/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for an Amazon Q index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NativeIndexConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NativeIndexConfiguration.Builder, NativeIndexConfiguration> {
    private static final SdkField<Map<String, DocumentAttributeBoostingConfiguration>> BOOSTING_OVERRIDE_FIELD = SdkField
            .<Map<String, DocumentAttributeBoostingConfiguration>> builder(MarshallingType.MAP)
            .memberName("boostingOverride")
            .getter(getter(NativeIndexConfiguration::boostingOverride))
            .setter(setter(Builder::boostingOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingOverride").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DocumentAttributeBoostingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttributeBoostingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(NativeIndexConfiguration::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOSTING_OVERRIDE_FIELD,
            INDEX_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, DocumentAttributeBoostingConfiguration> boostingOverride;

    private final String indexId;

    private NativeIndexConfiguration(BuilderImpl builder) {
        this.boostingOverride = builder.boostingOverride;
        this.indexId = builder.indexId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BoostingOverride property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBoostingOverride() {
        return boostingOverride != null && !(boostingOverride instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Overrides the default boosts applied by Amazon Q to supported document attribute data types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBoostingOverride} method.
     * </p>
     * 
     * @return Overrides the default boosts applied by Amazon Q to supported document attribute data types.
     */
    public final Map<String, DocumentAttributeBoostingConfiguration> boostingOverride() {
        return boostingOverride;
    }

    /**
     * <p>
     * The identifier for the Amazon Q index.
     * </p>
     * 
     * @return The identifier for the Amazon Q index.
     */
    public final String indexId() {
        return indexId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBoostingOverride() ? boostingOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NativeIndexConfiguration)) {
            return false;
        }
        NativeIndexConfiguration other = (NativeIndexConfiguration) obj;
        return hasBoostingOverride() == other.hasBoostingOverride()
                && Objects.equals(boostingOverride(), other.boostingOverride()) && Objects.equals(indexId(), other.indexId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NativeIndexConfiguration")
                .add("BoostingOverride", hasBoostingOverride() ? boostingOverride() : null).add("IndexId", indexId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "boostingOverride":
            return Optional.ofNullable(clazz.cast(boostingOverride()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NativeIndexConfiguration, T> g) {
        return obj -> g.apply((NativeIndexConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NativeIndexConfiguration> {
        /**
         * <p>
         * Overrides the default boosts applied by Amazon Q to supported document attribute data types.
         * </p>
         * 
         * @param boostingOverride
         *        Overrides the default boosts applied by Amazon Q to supported document attribute data types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boostingOverride(Map<String, DocumentAttributeBoostingConfiguration> boostingOverride);

        /**
         * <p>
         * The identifier for the Amazon Q index.
         * </p>
         * 
         * @param indexId
         *        The identifier for the Amazon Q index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, DocumentAttributeBoostingConfiguration> boostingOverride = DefaultSdkAutoConstructMap.getInstance();

        private String indexId;

        private BuilderImpl() {
        }

        private BuilderImpl(NativeIndexConfiguration model) {
            boostingOverride(model.boostingOverride);
            indexId(model.indexId);
        }

        public final Map<String, DocumentAttributeBoostingConfiguration.Builder> getBoostingOverride() {
            Map<String, DocumentAttributeBoostingConfiguration.Builder> result = DocumentAttributeBoostingOverrideMapCopier
                    .copyToBuilder(this.boostingOverride);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBoostingOverride(Map<String, DocumentAttributeBoostingConfiguration.BuilderImpl> boostingOverride) {
            this.boostingOverride = DocumentAttributeBoostingOverrideMapCopier.copyFromBuilder(boostingOverride);
        }

        @Override
        public final Builder boostingOverride(Map<String, DocumentAttributeBoostingConfiguration> boostingOverride) {
            this.boostingOverride = DocumentAttributeBoostingOverrideMapCopier.copy(boostingOverride);
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public NativeIndexConfiguration build() {
            return new NativeIndexConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
