/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on boosting <code>NUMBER</code> type document attributes.
 * </p>
 * <p>
 * For more information on how boosting document attributes work in Amazon Q, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html">Boosting using document
 * attributes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumberAttributeBoostingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NumberAttributeBoostingConfiguration.Builder, NumberAttributeBoostingConfiguration> {
    private static final SdkField<String> BOOSTING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("boostingLevel").getter(getter(NumberAttributeBoostingConfiguration::boostingLevelAsString))
            .setter(setter(Builder::boostingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingLevel").build()).build();

    private static final SdkField<String> BOOSTING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("boostingType").getter(getter(NumberAttributeBoostingConfiguration::boostingTypeAsString))
            .setter(setter(Builder::boostingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOSTING_LEVEL_FIELD,
            BOOSTING_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String boostingLevel;

    private final String boostingType;

    private NumberAttributeBoostingConfiguration(BuilderImpl builder) {
        this.boostingLevel = builder.boostingLevel;
        this.boostingType = builder.boostingType;
    }

    /**
     * <p>
     * Specifies the duration, in seconds, of a boost applies to a <code>NUMBER</code> type document attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #boostingLevel}
     * will return {@link DocumentAttributeBoostingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #boostingLevelAsString}.
     * </p>
     * 
     * @return Specifies the duration, in seconds, of a boost applies to a <code>NUMBER</code> type document attribute.
     * @see DocumentAttributeBoostingLevel
     */
    public final DocumentAttributeBoostingLevel boostingLevel() {
        return DocumentAttributeBoostingLevel.fromValue(boostingLevel);
    }

    /**
     * <p>
     * Specifies the duration, in seconds, of a boost applies to a <code>NUMBER</code> type document attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #boostingLevel}
     * will return {@link DocumentAttributeBoostingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #boostingLevelAsString}.
     * </p>
     * 
     * @return Specifies the duration, in seconds, of a boost applies to a <code>NUMBER</code> type document attribute.
     * @see DocumentAttributeBoostingLevel
     */
    public final String boostingLevelAsString() {
        return boostingLevel;
    }

    /**
     * <p>
     * Specifies how much a document attribute is boosted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #boostingType} will
     * return {@link NumberAttributeBoostingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #boostingTypeAsString}.
     * </p>
     * 
     * @return Specifies how much a document attribute is boosted.
     * @see NumberAttributeBoostingType
     */
    public final NumberAttributeBoostingType boostingType() {
        return NumberAttributeBoostingType.fromValue(boostingType);
    }

    /**
     * <p>
     * Specifies how much a document attribute is boosted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #boostingType} will
     * return {@link NumberAttributeBoostingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #boostingTypeAsString}.
     * </p>
     * 
     * @return Specifies how much a document attribute is boosted.
     * @see NumberAttributeBoostingType
     */
    public final String boostingTypeAsString() {
        return boostingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boostingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(boostingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberAttributeBoostingConfiguration)) {
            return false;
        }
        NumberAttributeBoostingConfiguration other = (NumberAttributeBoostingConfiguration) obj;
        return Objects.equals(boostingLevelAsString(), other.boostingLevelAsString())
                && Objects.equals(boostingTypeAsString(), other.boostingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumberAttributeBoostingConfiguration").add("BoostingLevel", boostingLevelAsString())
                .add("BoostingType", boostingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "boostingLevel":
            return Optional.ofNullable(clazz.cast(boostingLevelAsString()));
        case "boostingType":
            return Optional.ofNullable(clazz.cast(boostingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumberAttributeBoostingConfiguration, T> g) {
        return obj -> g.apply((NumberAttributeBoostingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumberAttributeBoostingConfiguration> {
        /**
         * <p>
         * Specifies the duration, in seconds, of a boost applies to a <code>NUMBER</code> type document attribute.
         * </p>
         * 
         * @param boostingLevel
         *        Specifies the duration, in seconds, of a boost applies to a <code>NUMBER</code> type document
         *        attribute.
         * @see DocumentAttributeBoostingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeBoostingLevel
         */
        Builder boostingLevel(String boostingLevel);

        /**
         * <p>
         * Specifies the duration, in seconds, of a boost applies to a <code>NUMBER</code> type document attribute.
         * </p>
         * 
         * @param boostingLevel
         *        Specifies the duration, in seconds, of a boost applies to a <code>NUMBER</code> type document
         *        attribute.
         * @see DocumentAttributeBoostingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeBoostingLevel
         */
        Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel);

        /**
         * <p>
         * Specifies how much a document attribute is boosted.
         * </p>
         * 
         * @param boostingType
         *        Specifies how much a document attribute is boosted.
         * @see NumberAttributeBoostingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberAttributeBoostingType
         */
        Builder boostingType(String boostingType);

        /**
         * <p>
         * Specifies how much a document attribute is boosted.
         * </p>
         * 
         * @param boostingType
         *        Specifies how much a document attribute is boosted.
         * @see NumberAttributeBoostingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberAttributeBoostingType
         */
        Builder boostingType(NumberAttributeBoostingType boostingType);
    }

    static final class BuilderImpl implements Builder {
        private String boostingLevel;

        private String boostingType;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberAttributeBoostingConfiguration model) {
            boostingLevel(model.boostingLevel);
            boostingType(model.boostingType);
        }

        public final String getBoostingLevel() {
            return boostingLevel;
        }

        public final void setBoostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
        }

        @Override
        public final Builder boostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
            return this;
        }

        @Override
        public final Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel) {
            this.boostingLevel(boostingLevel == null ? null : boostingLevel.toString());
            return this;
        }

        public final String getBoostingType() {
            return boostingType;
        }

        public final void setBoostingType(String boostingType) {
            this.boostingType = boostingType;
        }

        @Override
        public final Builder boostingType(String boostingType) {
            this.boostingType = boostingType;
            return this;
        }

        @Override
        public final Builder boostingType(NumberAttributeBoostingType boostingType) {
            this.boostingType(boostingType == null ? null : boostingType.toString());
            return this;
        }

        @Override
        public NumberAttributeBoostingConfiguration build() {
            return new NumberAttributeBoostingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
