/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on how the retriever used for your Amazon Q application is configured.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieverConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrieverConfiguration.Builder, RetrieverConfiguration> {
    private static final SdkField<KendraIndexConfiguration> KENDRA_INDEX_CONFIGURATION_FIELD = SdkField
            .<KendraIndexConfiguration> builder(MarshallingType.SDK_POJO).memberName("kendraIndexConfiguration")
            .getter(getter(RetrieverConfiguration::kendraIndexConfiguration)).setter(setter(Builder::kendraIndexConfiguration))
            .constructor(KendraIndexConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraIndexConfiguration").build())
            .build();

    private static final SdkField<NativeIndexConfiguration> NATIVE_INDEX_CONFIGURATION_FIELD = SdkField
            .<NativeIndexConfiguration> builder(MarshallingType.SDK_POJO).memberName("nativeIndexConfiguration")
            .getter(getter(RetrieverConfiguration::nativeIndexConfiguration)).setter(setter(Builder::nativeIndexConfiguration))
            .constructor(NativeIndexConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nativeIndexConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            KENDRA_INDEX_CONFIGURATION_FIELD, NATIVE_INDEX_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final KendraIndexConfiguration kendraIndexConfiguration;

    private final NativeIndexConfiguration nativeIndexConfiguration;

    private final Type type;

    private RetrieverConfiguration(BuilderImpl builder) {
        this.kendraIndexConfiguration = builder.kendraIndexConfiguration;
        this.nativeIndexConfiguration = builder.nativeIndexConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Provides information on how the Amazon Kendra index used as a retriever for your Amazon Q application is
     * configured.
     * </p>
     * 
     * @return Provides information on how the Amazon Kendra index used as a retriever for your Amazon Q application is
     *         configured.
     */
    public final KendraIndexConfiguration kendraIndexConfiguration() {
        return kendraIndexConfiguration;
    }

    /**
     * <p>
     * Provides information on how a Amazon Q index used as a retriever for your Amazon Q application is configured.
     * </p>
     * 
     * @return Provides information on how a Amazon Q index used as a retriever for your Amazon Q application is
     *         configured.
     */
    public final NativeIndexConfiguration nativeIndexConfiguration() {
        return nativeIndexConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kendraIndexConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(nativeIndexConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieverConfiguration)) {
            return false;
        }
        RetrieverConfiguration other = (RetrieverConfiguration) obj;
        return Objects.equals(kendraIndexConfiguration(), other.kendraIndexConfiguration())
                && Objects.equals(nativeIndexConfiguration(), other.nativeIndexConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieverConfiguration").add("KendraIndexConfiguration", kendraIndexConfiguration())
                .add("NativeIndexConfiguration", nativeIndexConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kendraIndexConfiguration":
            return Optional.ofNullable(clazz.cast(kendraIndexConfiguration()));
        case "nativeIndexConfiguration":
            return Optional.ofNullable(clazz.cast(nativeIndexConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #kendraIndexConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on how the Amazon Kendra index used as a retriever for your Amazon Q application is
     * configured.
     * </p>
     * 
     * @param kendraIndexConfiguration
     *        Provides information on how the Amazon Kendra index used as a retriever for your Amazon Q application is
     *        configured.
     */
    public static RetrieverConfiguration fromKendraIndexConfiguration(KendraIndexConfiguration kendraIndexConfiguration) {
        return builder().kendraIndexConfiguration(kendraIndexConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #kendraIndexConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on how the Amazon Kendra index used as a retriever for your Amazon Q application is
     * configured.
     * </p>
     * 
     * @param kendraIndexConfiguration
     *        Provides information on how the Amazon Kendra index used as a retriever for your Amazon Q application is
     *        configured.
     */
    public static RetrieverConfiguration fromKendraIndexConfiguration(
            Consumer<KendraIndexConfiguration.Builder> kendraIndexConfiguration) {
        KendraIndexConfiguration.Builder builder = KendraIndexConfiguration.builder();
        kendraIndexConfiguration.accept(builder);
        return fromKendraIndexConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #nativeIndexConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on how a Amazon Q index used as a retriever for your Amazon Q application is configured.
     * </p>
     * 
     * @param nativeIndexConfiguration
     *        Provides information on how a Amazon Q index used as a retriever for your Amazon Q application is
     *        configured.
     */
    public static RetrieverConfiguration fromNativeIndexConfiguration(NativeIndexConfiguration nativeIndexConfiguration) {
        return builder().nativeIndexConfiguration(nativeIndexConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #nativeIndexConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on how a Amazon Q index used as a retriever for your Amazon Q application is configured.
     * </p>
     * 
     * @param nativeIndexConfiguration
     *        Provides information on how a Amazon Q index used as a retriever for your Amazon Q application is
     *        configured.
     */
    public static RetrieverConfiguration fromNativeIndexConfiguration(
            Consumer<NativeIndexConfiguration.Builder> nativeIndexConfiguration) {
        NativeIndexConfiguration.Builder builder = NativeIndexConfiguration.builder();
        nativeIndexConfiguration.accept(builder);
        return fromNativeIndexConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieverConfiguration, T> g) {
        return obj -> g.apply((RetrieverConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrieverConfiguration> {
        /**
         * <p>
         * Provides information on how the Amazon Kendra index used as a retriever for your Amazon Q application is
         * configured.
         * </p>
         * 
         * @param kendraIndexConfiguration
         *        Provides information on how the Amazon Kendra index used as a retriever for your Amazon Q application
         *        is configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraIndexConfiguration(KendraIndexConfiguration kendraIndexConfiguration);

        /**
         * <p>
         * Provides information on how the Amazon Kendra index used as a retriever for your Amazon Q application is
         * configured.
         * </p>
         * This is a convenience method that creates an instance of the {@link KendraIndexConfiguration.Builder}
         * avoiding the need to create one manually via {@link KendraIndexConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KendraIndexConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #kendraIndexConfiguration(KendraIndexConfiguration)}.
         * 
         * @param kendraIndexConfiguration
         *        a consumer that will call methods on {@link KendraIndexConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraIndexConfiguration(KendraIndexConfiguration)
         */
        default Builder kendraIndexConfiguration(Consumer<KendraIndexConfiguration.Builder> kendraIndexConfiguration) {
            return kendraIndexConfiguration(KendraIndexConfiguration.builder().applyMutation(kendraIndexConfiguration).build());
        }

        /**
         * <p>
         * Provides information on how a Amazon Q index used as a retriever for your Amazon Q application is configured.
         * </p>
         * 
         * @param nativeIndexConfiguration
         *        Provides information on how a Amazon Q index used as a retriever for your Amazon Q application is
         *        configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nativeIndexConfiguration(NativeIndexConfiguration nativeIndexConfiguration);

        /**
         * <p>
         * Provides information on how a Amazon Q index used as a retriever for your Amazon Q application is configured.
         * </p>
         * This is a convenience method that creates an instance of the {@link NativeIndexConfiguration.Builder}
         * avoiding the need to create one manually via {@link NativeIndexConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NativeIndexConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #nativeIndexConfiguration(NativeIndexConfiguration)}.
         * 
         * @param nativeIndexConfiguration
         *        a consumer that will call methods on {@link NativeIndexConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nativeIndexConfiguration(NativeIndexConfiguration)
         */
        default Builder nativeIndexConfiguration(Consumer<NativeIndexConfiguration.Builder> nativeIndexConfiguration) {
            return nativeIndexConfiguration(NativeIndexConfiguration.builder().applyMutation(nativeIndexConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KendraIndexConfiguration kendraIndexConfiguration;

        private NativeIndexConfiguration nativeIndexConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieverConfiguration model) {
            kendraIndexConfiguration(model.kendraIndexConfiguration);
            nativeIndexConfiguration(model.nativeIndexConfiguration);
        }

        public final KendraIndexConfiguration.Builder getKendraIndexConfiguration() {
            return kendraIndexConfiguration != null ? kendraIndexConfiguration.toBuilder() : null;
        }

        public final void setKendraIndexConfiguration(KendraIndexConfiguration.BuilderImpl kendraIndexConfiguration) {
            Object oldValue = this.kendraIndexConfiguration;
            this.kendraIndexConfiguration = kendraIndexConfiguration != null ? kendraIndexConfiguration.build() : null;
            handleUnionValueChange(Type.KENDRA_INDEX_CONFIGURATION, oldValue, this.kendraIndexConfiguration);
        }

        @Override
        public final Builder kendraIndexConfiguration(KendraIndexConfiguration kendraIndexConfiguration) {
            Object oldValue = this.kendraIndexConfiguration;
            this.kendraIndexConfiguration = kendraIndexConfiguration;
            handleUnionValueChange(Type.KENDRA_INDEX_CONFIGURATION, oldValue, this.kendraIndexConfiguration);
            return this;
        }

        public final NativeIndexConfiguration.Builder getNativeIndexConfiguration() {
            return nativeIndexConfiguration != null ? nativeIndexConfiguration.toBuilder() : null;
        }

        public final void setNativeIndexConfiguration(NativeIndexConfiguration.BuilderImpl nativeIndexConfiguration) {
            Object oldValue = this.nativeIndexConfiguration;
            this.nativeIndexConfiguration = nativeIndexConfiguration != null ? nativeIndexConfiguration.build() : null;
            handleUnionValueChange(Type.NATIVE_INDEX_CONFIGURATION, oldValue, this.nativeIndexConfiguration);
        }

        @Override
        public final Builder nativeIndexConfiguration(NativeIndexConfiguration nativeIndexConfiguration) {
            Object oldValue = this.nativeIndexConfiguration;
            this.nativeIndexConfiguration = nativeIndexConfiguration;
            handleUnionValueChange(Type.NATIVE_INDEX_CONFIGURATION, oldValue, this.nativeIndexConfiguration);
            return this;
        }

        @Override
        public RetrieverConfiguration build() {
            return new RetrieverConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RetrieverConfiguration#type()
     */
    public enum Type {
        KENDRA_INDEX_CONFIGURATION,

        NATIVE_INDEX_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
