/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Guardrail rules for an Amazon Q application. Amazon Q supports only one rule at a time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<UsersAndGroups> EXCLUDED_USERS_AND_GROUPS_FIELD = SdkField
            .<UsersAndGroups> builder(MarshallingType.SDK_POJO).memberName("excludedUsersAndGroups")
            .getter(getter(Rule::excludedUsersAndGroups)).setter(setter(Builder::excludedUsersAndGroups))
            .constructor(UsersAndGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludedUsersAndGroups").build())
            .build();

    private static final SdkField<UsersAndGroups> INCLUDED_USERS_AND_GROUPS_FIELD = SdkField
            .<UsersAndGroups> builder(MarshallingType.SDK_POJO).memberName("includedUsersAndGroups")
            .getter(getter(Rule::includedUsersAndGroups)).setter(setter(Builder::includedUsersAndGroups))
            .constructor(UsersAndGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedUsersAndGroups").build())
            .build();

    private static final SdkField<RuleConfiguration> RULE_CONFIGURATION_FIELD = SdkField
            .<RuleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ruleConfiguration")
            .getter(getter(Rule::ruleConfiguration)).setter(setter(Builder::ruleConfiguration))
            .constructor(RuleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleConfiguration").build()).build();

    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleType").getter(getter(Rule::ruleTypeAsString)).setter(setter(Builder::ruleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXCLUDED_USERS_AND_GROUPS_FIELD, INCLUDED_USERS_AND_GROUPS_FIELD, RULE_CONFIGURATION_FIELD, RULE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final UsersAndGroups excludedUsersAndGroups;

    private final UsersAndGroups includedUsersAndGroups;

    private final RuleConfiguration ruleConfiguration;

    private final String ruleType;

    private Rule(BuilderImpl builder) {
        this.excludedUsersAndGroups = builder.excludedUsersAndGroups;
        this.includedUsersAndGroups = builder.includedUsersAndGroups;
        this.ruleConfiguration = builder.ruleConfiguration;
        this.ruleType = builder.ruleType;
    }

    /**
     * <p>
     * Users and groups to be excluded from a rule.
     * </p>
     * 
     * @return Users and groups to be excluded from a rule.
     */
    public final UsersAndGroups excludedUsersAndGroups() {
        return excludedUsersAndGroups;
    }

    /**
     * <p>
     * Users and groups to be included in a rule.
     * </p>
     * 
     * @return Users and groups to be included in a rule.
     */
    public final UsersAndGroups includedUsersAndGroups() {
        return includedUsersAndGroups;
    }

    /**
     * <p>
     * The configuration information for a rule.
     * </p>
     * 
     * @return The configuration information for a rule.
     */
    public final RuleConfiguration ruleConfiguration() {
        return ruleConfiguration;
    }

    /**
     * <p>
     * The type of rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return The type of rule.
     * @see RuleType
     */
    public final RuleType ruleType() {
        return RuleType.fromValue(ruleType);
    }

    /**
     * <p>
     * The type of rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return The type of rule.
     * @see RuleType
     */
    public final String ruleTypeAsString() {
        return ruleType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excludedUsersAndGroups());
        hashCode = 31 * hashCode + Objects.hashCode(includedUsersAndGroups());
        hashCode = 31 * hashCode + Objects.hashCode(ruleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(ruleTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(excludedUsersAndGroups(), other.excludedUsersAndGroups())
                && Objects.equals(includedUsersAndGroups(), other.includedUsersAndGroups())
                && Objects.equals(ruleConfiguration(), other.ruleConfiguration())
                && Objects.equals(ruleTypeAsString(), other.ruleTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rule").add("ExcludedUsersAndGroups", excludedUsersAndGroups())
                .add("IncludedUsersAndGroups", includedUsersAndGroups()).add("RuleConfiguration", ruleConfiguration())
                .add("RuleType", ruleTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "excludedUsersAndGroups":
            return Optional.ofNullable(clazz.cast(excludedUsersAndGroups()));
        case "includedUsersAndGroups":
            return Optional.ofNullable(clazz.cast(includedUsersAndGroups()));
        case "ruleConfiguration":
            return Optional.ofNullable(clazz.cast(ruleConfiguration()));
        case "ruleType":
            return Optional.ofNullable(clazz.cast(ruleTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * Users and groups to be excluded from a rule.
         * </p>
         * 
         * @param excludedUsersAndGroups
         *        Users and groups to be excluded from a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedUsersAndGroups(UsersAndGroups excludedUsersAndGroups);

        /**
         * <p>
         * Users and groups to be excluded from a rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsersAndGroups.Builder} avoiding the need
         * to create one manually via {@link UsersAndGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsersAndGroups.Builder#build()} is called immediately and its
         * result is passed to {@link #excludedUsersAndGroups(UsersAndGroups)}.
         * 
         * @param excludedUsersAndGroups
         *        a consumer that will call methods on {@link UsersAndGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludedUsersAndGroups(UsersAndGroups)
         */
        default Builder excludedUsersAndGroups(Consumer<UsersAndGroups.Builder> excludedUsersAndGroups) {
            return excludedUsersAndGroups(UsersAndGroups.builder().applyMutation(excludedUsersAndGroups).build());
        }

        /**
         * <p>
         * Users and groups to be included in a rule.
         * </p>
         * 
         * @param includedUsersAndGroups
         *        Users and groups to be included in a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedUsersAndGroups(UsersAndGroups includedUsersAndGroups);

        /**
         * <p>
         * Users and groups to be included in a rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsersAndGroups.Builder} avoiding the need
         * to create one manually via {@link UsersAndGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsersAndGroups.Builder#build()} is called immediately and its
         * result is passed to {@link #includedUsersAndGroups(UsersAndGroups)}.
         * 
         * @param includedUsersAndGroups
         *        a consumer that will call methods on {@link UsersAndGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includedUsersAndGroups(UsersAndGroups)
         */
        default Builder includedUsersAndGroups(Consumer<UsersAndGroups.Builder> includedUsersAndGroups) {
            return includedUsersAndGroups(UsersAndGroups.builder().applyMutation(includedUsersAndGroups).build());
        }

        /**
         * <p>
         * The configuration information for a rule.
         * </p>
         * 
         * @param ruleConfiguration
         *        The configuration information for a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleConfiguration(RuleConfiguration ruleConfiguration);

        /**
         * <p>
         * The configuration information for a rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleConfiguration.Builder} avoiding the
         * need to create one manually via {@link RuleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleConfiguration(RuleConfiguration)}.
         * 
         * @param ruleConfiguration
         *        a consumer that will call methods on {@link RuleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleConfiguration(RuleConfiguration)
         */
        default Builder ruleConfiguration(Consumer<RuleConfiguration.Builder> ruleConfiguration) {
            return ruleConfiguration(RuleConfiguration.builder().applyMutation(ruleConfiguration).build());
        }

        /**
         * <p>
         * The type of rule.
         * </p>
         * 
         * @param ruleType
         *        The type of rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(String ruleType);

        /**
         * <p>
         * The type of rule.
         * </p>
         * 
         * @param ruleType
         *        The type of rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(RuleType ruleType);
    }

    static final class BuilderImpl implements Builder {
        private UsersAndGroups excludedUsersAndGroups;

        private UsersAndGroups includedUsersAndGroups;

        private RuleConfiguration ruleConfiguration;

        private String ruleType;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            excludedUsersAndGroups(model.excludedUsersAndGroups);
            includedUsersAndGroups(model.includedUsersAndGroups);
            ruleConfiguration(model.ruleConfiguration);
            ruleType(model.ruleType);
        }

        public final UsersAndGroups.Builder getExcludedUsersAndGroups() {
            return excludedUsersAndGroups != null ? excludedUsersAndGroups.toBuilder() : null;
        }

        public final void setExcludedUsersAndGroups(UsersAndGroups.BuilderImpl excludedUsersAndGroups) {
            this.excludedUsersAndGroups = excludedUsersAndGroups != null ? excludedUsersAndGroups.build() : null;
        }

        @Override
        public final Builder excludedUsersAndGroups(UsersAndGroups excludedUsersAndGroups) {
            this.excludedUsersAndGroups = excludedUsersAndGroups;
            return this;
        }

        public final UsersAndGroups.Builder getIncludedUsersAndGroups() {
            return includedUsersAndGroups != null ? includedUsersAndGroups.toBuilder() : null;
        }

        public final void setIncludedUsersAndGroups(UsersAndGroups.BuilderImpl includedUsersAndGroups) {
            this.includedUsersAndGroups = includedUsersAndGroups != null ? includedUsersAndGroups.build() : null;
        }

        @Override
        public final Builder includedUsersAndGroups(UsersAndGroups includedUsersAndGroups) {
            this.includedUsersAndGroups = includedUsersAndGroups;
            return this;
        }

        public final RuleConfiguration.Builder getRuleConfiguration() {
            return ruleConfiguration != null ? ruleConfiguration.toBuilder() : null;
        }

        public final void setRuleConfiguration(RuleConfiguration.BuilderImpl ruleConfiguration) {
            this.ruleConfiguration = ruleConfiguration != null ? ruleConfiguration.build() : null;
        }

        @Override
        public final Builder ruleConfiguration(RuleConfiguration ruleConfiguration) {
            this.ruleConfiguration = ruleConfiguration;
            return this;
        }

        public final String getRuleType() {
            return ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
